<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: GCharts (c) 2013 by Oliver Seddon 
#         (oliver@threefold.co.uk)
#  An addon module for CMS Made Simple to add Google Charts to your pages
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

if (!isset($gCms)) exit;

$current_version = $oldversion;
$db =& $this->GetDb();
$dict = NewDataDictionary($db);
$taboptarray = array('mysql' => 'TYPE=MyISAM');

switch($current_version) {
  // we are now 1.0 and want to upgrade to latest
 case "1.0":
 case "1.1":
 case "1.2":
	$fields = '
		aggregationTarget C(255),
		groupWidth C(255)
	';

	$sqlarray = $dict->AddColumnSQL(cms_db_prefix() . 'module_gcharts', $fields, $taboptarray);
	$dict->ExecuteSQLArray($sqlarray);

	$query = 'INSERT INTO '.cms_db_prefix().'module_gcharts_categories (gcharts_category_id, gcharts_category_name, parent_id, create_date, modified_date) VALUES (?,?,?,'.$db->DBTimeStamp(time()).','.$db->DBTimeStamp(time()).')';
	$db->Execute($query, array('4', 'Column Chart', -1));
 case "1.3":
	$fields = '
		dataOpacity C(255),
	 	avoidOverlappingGridLines C(255),
	 	timeline C(255)
	';

	$sqlarray = $dict->AddColumnSQL(cms_db_prefix() . 'module_gcharts', $fields, $taboptarray);
	$dict->ExecuteSQLArray($sqlarray);

	$query = 'INSERT INTO '.cms_db_prefix().'module_gcharts_categories (gcharts_category_id, gcharts_category_name, parent_id, create_date, modified_date) VALUES (?,?,?,'.$db->DBTimeStamp(time()).','.$db->DBTimeStamp(time()).')';
	$db->Execute($query, array('5', 'Histogram', -1));

	$query = 'INSERT INTO '.cms_db_prefix().'module_gcharts_categories (gcharts_category_id, gcharts_category_name, parent_id, create_date, modified_date) VALUES (?,?,?,'.$db->DBTimeStamp(time()).','.$db->DBTimeStamp(time()).')';
	$db->Execute($query, array('6', 'Timeline', -1));
 case "1.3.1":
 case "1.4":
	$fields = '
		allowHtml C(255),
		alternatingRowStyle C(255),
		cssClassNames C(255),
		firstRowNumber C(255),
		chartpage C(255),
		pageSize C(255),
		rtlTable C(255),
		scrollLeftStartPosition C(255),
		showRowNumber C(255),
		sort C(255),
		sortAscending C(255),
		sortColumn C(255),
		startPage C(255)
	';

	$sqlarray = $dict->AddColumnSQL(cms_db_prefix() . 'module_gcharts', $fields, $taboptarray);
	$dict->ExecuteSQLArray($sqlarray);

	$query = 'INSERT INTO '.cms_db_prefix().'module_gcharts_categories (gcharts_category_id, gcharts_category_name, parent_id, create_date, modified_date) VALUES (?,?,?,'.$db->DBTimeStamp(time()).','.$db->DBTimeStamp(time()).')';
	$db->Execute($query, array('7', 'Table', -1));

}

// put mention into the admin log
$this->Audit( 0, 
	      $this->Lang('friendlyname'), 
	      $this->Lang('upgraded', $this->GetVersion()));

//note: module api handles sending generic event of module upgraded here
?>