<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: GCharts (c) 2013 by Oliver Seddon 
#         (oliver@threefold.co.uk)
#  An addon module for CMS Made Simple to add Google Charts to your pages
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class GCharts extends CMSModule
{

  function GetName()
  {
    return 'GCharts';
  }

  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }

  function GetVersion()
  {
    return '1.4';
  }

  function GetHelp()
  {
    return $this->Lang('help');
  }

  function GetAuthor()
  {
    return 'oliverseddon';
  }

  function GetAuthorEmail()
  {
    return 'oliver@threefold.co.uk';
  }

  function GetChangeLog()
  {
    return $this->Lang('changelog');
  }

  function IsPluginModule()
  {
    return true;
  }

  function HasAdmin()
  {
    return true;
  }

  function GetAdminSection()
  {
    return 'content';
  }

  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }

  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Use GCharts');
  }

  function GetDashboardOutput() 
  {
	$db = cmsms()->GetDb();

	$rcount = $db->GetOne('select count(*) from '.cms_db_prefix().'module_gcharts');
	
    return $this->Lang('dash_record_count',$rcount);
  }

  function DisplayErrorPage($id, &$params, $return_id, $message='')
    {
		$this->smarty->assign('title_error', $this->Lang('error'));
		$this->smarty->assign_by_ref('message', $message);

        // Display the populated template
        echo $this->ProcessTemplate('error.tpl');
    }

  function GetDependencies()
  {
    return array();
  }

  function MinimumCMSVersion()
  {
    return "1.11";
  }

  function MaximumCMSVersion()
  {
    return "1.15";
  }

  function InitializeAdmin()
	{
	  $this->CreateParameter('gcharts_id', '1', $this->Lang('help_gcharts_id'));
	  $this->CreateParameter('gcharts_category_id', '1', $this->Lang('help_gcharts_category_id'));
	  $this->CreateParameter('backgroundColor', 'white', $this->Lang('help_backgroundColor'));
	  $this->CreateParameter('chartArea', 'null', $this->Lang('help_chartArea'));
	  $this->CreateParameter('colors', 'default colors', $this->Lang('help_colors'));
	  $this->CreateParameter('fontSize', 'automatic', $this->Lang('help_fontSize'));
	  $this->CreateParameter('fontName', 'Arial', $this->Lang('help_fontName'));
	  $this->CreateParameter('height', 'auto', $this->Lang('help_height'));
	  $this->CreateParameter('legend', 'null', $this->Lang('help_legend'));
	  $this->CreateParameter('reverseCategories', 'false', $this->Lang('help_reverseCategories'));
	  $this->CreateParameter('titleTextStyle', '', $this->Lang('help_titleTextStyle'));
	  $this->CreateParameter('tooltip', 'null', $this->Lang('help_tooltip'));
	  $this->CreateParameter('width', 'auto', $this->Lang('help_width'));
	  $this->CreateParameter('is3D', 'false', $this->Lang('help_is3D'));
	  $this->CreateParameter('slices', '&#123;&#125;', $this->Lang('help_slices'));
	  $this->CreateParameter('pieSliceBorderColor', 'white', $this->Lang('help_pieSliceBorderColor'));
	  $this->CreateParameter('pieSliceText', 'percentage', $this->Lang('help_pieSliceText'));
	  $this->CreateParameter('pieSliceTextStyle', '', $this->Lang('help_pieSliceTextStyle'));
	  $this->CreateParameter('sliceVisibilityThreshold', '1/720', $this->Lang('help_sliceVisibilityThreshold'));
	  $this->CreateParameter('pieResidueSliceColor', '#ccc', $this->Lang('help_pieResidueSliceColor'));
	  $this->CreateParameter('pieResidueSliceLabel', 'Other', $this->Lang('help_pieResidueSliceLabel'));
	  $this->CreateParameter('axisTitlesPosition', 'out', $this->Lang('help_axisTitlesPosition'));
	  $this->CreateParameter('enableInteractivity', 'true', $this->Lang('help_enableInteractivity'));
	  $this->CreateParameter('focusTarget', 'datum', $this->Lang('help_focusTarget'));
	  $this->CreateParameter('hAxis', 'null', $this->Lang('help_hAxis'));
	  $this->CreateParameter('isHtml', 'false', $this->Lang('help_isHtml'));
	  $this->CreateParameter('series', '&#123;&#125;', $this->Lang('help_series'));
	  $this->CreateParameter('theme', 'null', $this->Lang('help_theme'));
	  $this->CreateParameter('titlePosition', 'out', $this->Lang('help_titlePosition'));
	  $this->CreateParameter('vAxes', 'null', $this->Lang('help_vAxes'));
	  $this->CreateParameter('aggregationTarget', 'auto', $this->Lang('help_aggregationTarget'));
	  $this->CreateParameter('curveType', 'none', $this->Lang('help_curveType'));
	  $this->CreateParameter('interpolatedNulls', 'false', $this->Lang('help_interpolatedNulls'));
	  $this->CreateParameter('vAxis', 'null', $this->Lang('help_vAxis'));
	  $this->CreateParameter('lineWidth', '2', $this->Lang('help_lineWidth'));
	  $this->CreateParameter('pointSize', '0', $this->Lang('help_pointSize'));
	  $this->CreateParameter('isStacked', 'false', $this->Lang('help_isStacked'));
	  $this->CreateParameter('groupWidth', '61.8%', $this->Lang('help_groupWidth'));
	  $this->CreateParameter('dataOpacity', '1.0', $this->Lang('help_dataOpacity'));
	  $this->CreateParameter('avoidOverlappingGridLines', 'true', $this->Lang('help_avoidOverlappingGridLines'));
	  $this->CreateParameter('timeline', '', $this->Lang('help_timeline'));
	  $this->CreateParameter('allowHtml', 'false', $this->Lang('help_allowHtml'));
	  $this->CreateParameter('alternatingRowStyle', 'true', $this->Lang('help_alternatingRowStyle'));
	  $this->CreateParameter('cssClassNames', 'null', $this->Lang('help_cssClassNames'));
	  $this->CreateParameter('firstRowNumber', '1', $this->Lang('help_firstRowNumber'));
	  $this->CreateParameter('chartpage', 'disable', $this->Lang('help_chartpage'));
	  $this->CreateParameter('pageSize', '10', $this->Lang('help_pageSize'));
	  $this->CreateParameter('rtlTable', 'false', $this->Lang('help_rtlTable'));
	  $this->CreateParameter('scrollLeftStartPosition', '0', $this->Lang('help_scrollLeftStartPosition'));
	  $this->CreateParameter('showRowNumber', 'false', $this->Lang('help_showRowNumber'));
	  $this->CreateParameter('sort', 'enable', $this->Lang('help_sort'));
	  $this->CreateParameter('sortAscending', 'true', $this->Lang('help_sortAscending'));
	  $this->CreateParameter('sortColumn', '-1', $this->Lang('help_sortColumn'));
	  $this->CreateParameter('startPage', '0', $this->Lang('help_startPage'));
	}

  function InitializeFrontend()
  {
  $this->RegisterModulePlugin();
   
	$this->RegisterRoute('/gcharts\/view\/(?P<gcharts_id>[0-9]+)\/(?P<returnid>[0-9]+)$/',array('action'=>'default'));  
	
	$gCms = cmsms();
	$contentops = $gCms->GetContentOperations();
	$returnid = $contentops->GetDefaultContent();
	// The previous three lines are to get a returnid; many modules, like News, have a default
	// page in which to display detail views. In that case, the page_id would be used for returnid.
	
	// The next three lines are where we map the URL to our detail page.
	$parms = array('action'=>'default','gcharts_id'=>1,'returnid'=>$returnid);
	$route = new CmsRoute('this/is/insanely/great/stuff',$this->GetName(),$parms,TRUE);
	cms_route_manager::register($route);
	
  
   // Don't allow parameters other than the ones you've explicitly defined
   $this->RestrictUnknownParams();
  
   // syntax for creating a parameter is parameter name, default value, description
   $this->CreateParameter('gcharts_id', -1, $this->Lang('help_gcharts_id'));

   $this->SetParameterType('gcharts_id',CLEAN_INT);
   $this->SetParameterType('gcharts_category_id',CLEAN_INT);

   $this->SetParameterType('backgroundColor',CLEAN_STRING);
   $this->SetParameterType('chartArea',CLEAN_STRING);
   $this->SetParameterType('colors',CLEAN_STRING);
   $this->SetParameterType('fontSize',CLEAN_STRING);
   $this->SetParameterType('fontName',CLEAN_STRING);
   $this->SetParameterType('height',CLEAN_STRING);
   $this->SetParameterType('legend',CLEAN_STRING);
   $this->SetParameterType('reverseCategories',CLEAN_STRING);
   $this->SetParameterType('titleTextStyle',CLEAN_STRING);
   $this->SetParameterType('tooltip',CLEAN_STRING);
   $this->SetParameterType('width',CLEAN_STRING);
   $this->SetParameterType('is3D',CLEAN_STRING);
   $this->SetParameterType('slices',CLEAN_STRING);
   $this->SetParameterType('pieSliceBorderColor',CLEAN_STRING);
   $this->SetParameterType('pieSliceText',CLEAN_STRING);
   $this->SetParameterType('pieSliceTextStyle',CLEAN_STRING);
   $this->SetParameterType('sliceVisibilityThreshold',CLEAN_STRING);
   $this->SetParameterType('pieResidueSliceColor',CLEAN_STRING);
   $this->SetParameterType('pieResidueSliceLabel',CLEAN_STRING);
   $this->SetParameterType('axisTitlesPosition',CLEAN_STRING);
   $this->SetParameterType('enableInteractivity',CLEAN_STRING);
   $this->SetParameterType('focusTarget',CLEAN_STRING);
   $this->SetParameterType('hAxis',CLEAN_STRING);
   $this->SetParameterType('isHtml',CLEAN_STRING);
   $this->SetParameterType('series',CLEAN_STRING);
   $this->SetParameterType('theme',CLEAN_STRING);
   $this->SetParameterType('titlePosition',CLEAN_STRING);
   $this->SetParameterType('vAxes',CLEAN_STRING);
   $this->SetParameterType('aggregationTarget',CLEAN_STRING);
   $this->SetParameterType('curveType',CLEAN_STRING);
   $this->SetParameterType('interpolatedNulls',CLEAN_STRING);
   $this->SetParameterType('vAxis',CLEAN_STRING);
   $this->SetParameterType('lineWidth',CLEAN_STRING);
   $this->SetParameterType('pointSize',CLEAN_STRING);
   $this->SetParameterType('isStacked',CLEAN_STRING);
   $this->SetParameterType('groupWidth',CLEAN_STRING);
   $this->SetParameterType('dataOpacity',CLEAN_STRING);
   $this->SetParameterType('avoidOverlappingGridLines',CLEAN_STRING);
   $this->SetParameterType('timeline',CLEAN_STRING);
   $this->SetParameterType('allowHtml',CLEAN_STRING);
   $this->SetParameterType('alternatingRowStyle',CLEAN_STRING);
   $this->SetParameterType('cssClassNames',CLEAN_STRING);
   $this->SetParameterType('firstRowNumber',CLEAN_STRING);
   $this->SetParameterType('chartpage',CLEAN_STRING);
   $this->SetParameterType('pageSize',CLEAN_STRING);
   $this->SetParameterType('rtlTable',CLEAN_STRING);
   $this->SetParameterType('scrollLeftStartPosition',CLEAN_STRING);
   $this->SetParameterType('showRowNumber',CLEAN_STRING);
   $this->SetParameterType('sort',CLEAN_STRING);
   $this->SetParameterType('sortAscending',CLEAN_STRING);
   $this->SetParameterType('sortColumn',CLEAN_STRING);
   $this->SetParameterType('startPage',CLEAN_STRING);

   $this->CreateParameter('module_message','',$this->Lang('help_module_message'));
   $this->SetParameterType('module_message',CLEAN_STRING);

   $this->CreateParameter('name','',$this->Lang('help_description'));
   $this->SetParameterType('name',CLEAN_STRING);

   $this->CreateParameter('content','',$this->Lang('help_explanation'));
   $this->SetParameterType('content',CLEAN_STRING);

   $this->CreateParameter('location','',$this->Lang('help_explanation'));
   $this->SetParameterType('location',CLEAN_STRING);

   $this->CreateParameter('author','',$this->Lang('help_author'));
   $this->SetParameterType('author',CLEAN_STRING);

   $this->SetParameterType('cancel',CLEAN_STRING);

   $this->CreateParameter('sortby', 'document_date', $this->lang('helpsortby'));
   $this->SetParameterType('sortby',CLEAN_STRING);

   $this->CreateParameter('sortdesc', 'true', $this->lang('helpsortdesc'));
   $this->SetParameterType('sortdesc',CLEAN_STRING);

   $this->SetParameterType('postdate',CLEAN_STRING);
   $this->SetParameterType('postdate_Hour',CLEAN_STRING);
   $this->SetParameterType('postdate_Minute',CLEAN_STRING);
   $this->SetParameterType('postdate_Second',CLEAN_STRING);
   $this->SetParameterType('postdate_Month',CLEAN_STRING);
   $this->SetParameterType('postdate_Day',CLEAN_STRING);
   $this->SetParameterType('postdate_Year',CLEAN_STRING);

  
  }

  function GetEventDescription ( $eventname )
  {
    return $this->Lang('event_info_'.$eventname );
  }

  function GetEventHelp ( $eventname )
  {
    return $this->Lang('event_help_'.$eventname );
  }

  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }

  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }

  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }


	function SearchResult($returnid, $articleid, $attr = '') {
		$documentid = $params['gcharts_id'];
		if (!empty($chartid)) $returnid = $chartid;
		$result = array();
		if ($attr == 'gcharts') {
			$db  = cmsms()->GetDb();
			$q = 'SELECT * FROM ' . cms_db_prefix() . 'module_gcharts WHERE gcharts_id = ?';
			$row = $db->GetRow($q, array($articleid) );
			if ($row) {
				$result[0] = utf8_encode(html_entity_decode($this->GetFriendlyName()));
				$result[1] = $row['name'];
				$prettyurl = 'uploads/gcharts/id'.$row['gcharts_id'].'/'.$row['location'];
				$result[2] = $this->CreateLink('cntnt01', 'default', $returnid, $row['name'], 
				       array('gcharts_id' => $row['gcharts_id']),
				       '', true, true, '', true, $prettyurl);
			}
		}
		return $result;
	}


	function SearchReindex(&$module) {
		$db = cmsms()->GetDb();

		$query = 'SELECT * FROM '.cms_db_prefix().'module_gcharts ORDER BY gcharts_id';
		$result = $db->Execute($query);

		while ($result && !$result->EOF) {
			$module->AddWords($this->Getname(), $result->fields['gcharts_id'], 'gcharts', $result->fields['content'], NULL);
			$result->MoveNext();
		}
	}

	public function DoAction ($action, $id, $params, $return_id = -1) {
		switch ($action) {	
			case 'updatetemplate': {
				// check permissions again
				if ($this->CheckPermission ('Modify Templates')) {
					if (isset ($params['defaultbutton'])) {
						$fn = dirname(__FILE__).'/templates/gcharts_list.tpl';
						if( file_exists($fn) ) {
							$template = @file_get_contents($fn);
							$this->SetTemplate( 'detailSample', $template);
						}
					} else {
						$this->SetTemplate ('detailSample', $params['templatecontent']);
					}
	  				$params = array('tab_message'=> 'templateupdated', 'active_tab' => 'templates');
	  				$this->Redirect($id, 'defaultadmin', $returnid, $params);
				}
			}

			default:
				parent::DoAction( $action, $id, $params, $return_id );
				break;
		}
	}




} //end class
?>