{if isset($error)}<strong>{$error}</strong>{/if}
<h3>{$rdmap->title}</h3>
<div id="map{$rdmap->map_id}" style="height: 400px">
</div>
<script type="text/javascript">
var basemap_url = "{$rdmap->basemap}";
var overlay_url = "{$rdmap->overlay}";
var initial_extent = "{$rdmap->initial_extent}";
{literal}
function createPopup(geojson,layer) {
	if (geojson.properties) {
		var popupText = "<div style='overflow-y:scroll; max-height:200px;'>";
		for (prop in geojson.properties) {
			var val = geojson.properties[prop];
			if (val && prop !== "globalid" && !prop.match(/objectid_\d+/)) {
				popupText += "<b>" + prop + "</b>:" + val + "<br/>";
			}
		}
		popupText += "</div>";
		layer.bindPopup(popupText);
	}
}

var x = initial_extent.split('/')[0];
var y = initial_extent.split('/')[1];
var zoom = initial_extent.split('/')[2];
{/literal}
var map = L.map('map{$rdmap->map_id}').setView([y,x],zoom);
{literal}
L.tileLayer(basemap_url + '/tile/{z}/{y}/{x}', {
	maxzoom: 19 }).addTo(map);
if (overlay_url !== null) {
	layerFS = L.esri.featureLayer(overlay_url, {
		onEachFeature: createPopup
}).addTo(map);
}

{/literal}
</script>
