<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Save and load maps to/from the database
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/

final class map_operations {
	public static function save_map(rdffg_map& $map) {
		$db = cmsms()->GetDb();
		$tmp = self::map_to_row($map);
		if (is_null($map->map_id)) {
			// save map
			$sql = "INSERT INTO ".cms_db_prefix()."module_rdmap (name, title, basemap, overlay, initial_extent, template_name) VALUES (?,?,?,?,?,?)";
		}
		else {
			// update map
			$sql = "UPDATE ".cms_db_prefix()."module_rdmap SET name = ?, title = ?, basemap = ?, overlay = ?, initial_extent = ?, template_name = ? WHERE map_id = ?";
			$tmp['map_id'] = (int)$map->map_id;
		}
		if(!$db->Execute($sql, $tmp)) {
			die ($db->sql.'<br/>'.$db->ErrorMsg());
			return false;
		}

		if (is_null($map->map_id)) {
			$map->map_id = $db->Insert_Id();
		}
		return true;
	}

	public static function get_map_by_id($id) {
		$db = cmsms()->GetDb();
		$q = 'SELECT * FROM '.cms_db_prefix().'module_rdmap WHERE map_id = ?';
		$result = $db->Execute($q, array($id));
		if ($result !== false) { 
			$row = $result->FetchRow();
			$map = self::row_to_map($row);
		}
		else {
			throw new Exception('map not found');
		}
		return $map;
	}

	public static function get_map_by_name($name) {
		$db = cmsms()->GetDb();
		$q = 'SELECT * FROM '.cms_db_prefix().'module_rdmap WHERE name = ?';
		$result = $db->Execute($q, array($name));
		if ($result !== false && $result->RecordCount() == 1) {
			$row = $result->FetchRow();
			$map = self::row_to_map($row);
		} else {
			throw new Exception('map not found,'.$db->sql);
		}

		return $map;
	}

	public static function get_maps() {
		$maps = array();
		$db = cmsms()->GetDb();
		$q = 'SELECT * FROM '.cms_db_prefix().'module_rdmap';
		$result = $db->Execute($q);
		if ($result !== false) {
			foreach ($result->GetRows() as $row) {
				$maps[] = self::row_to_map($row);
			}
		}
		return $maps;
	}

	public static function map_to_row(rdffg_map& $map) {
		$arr = array();
		//$arr[] = $map->map_id;
		$arr[] = $map->name;
		$arr[] = $map->title;
		$arr[] = $map->basemap;
		$arr[] = $map->overlay;
		$arr[] = $map->initial_extent;
		$arr[] = $map->template_name;
		return $arr;
	}

	public static function &row_to_map($row) {
		$m = new rdffg_map;
		$m->map_id = $row['map_id'];
		$m->name = $row['name'];
		$m->title = $row['title'];
		$m->basemap = $row['basemap'];
		$m->overlay = $row['overlay'];
		$m->initial_extent = $row['initial_extent'];
		$m->template_name = $row['template_name'];
		return $m;
	}

	public static function delete_map(rdffg_map& $map) {
		if (!isset($map->map_id)) {
			throw new Exception('Can\'t delete a map with no ID');
		}
		$db = cmsms()->GetDb();
		$q = 'DELETE FROM '.cms_db_prefix().'module_rdmap WHERE map_id = ?';
		$result = $db->Execute($q,array($map->map_id));
		if ($result !== false) {
			return;
		}
		else {
			throw new Exception('Failed to delete the map');
		}
	}
}
?>
