<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Create the map on the page
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/

if (!isset($gCms)) exit;

$error = null;
$map = null;

if (!isset($params['name'])) {
	$error = $this->Lang('map_name_not_set');
} else {
	try {
		$map = map_operations::get_map_by_name($params['name']);
		$this->smarty->assign('rdmap', $map);
	} catch (Exception $e) {
		$this->FireDebug('error', 'Could not retrieve map '.$params['name']);
		$error = $this->Lang('error_map_not_found') . ' (' . $params['name'] . ')';
	}
}
$this->smarty->assign('error', $error);
if ($map === null) {
    echo $this->ProcessTemplate('error.tpl');
    return;
}

if ($map->basemap == NULL) {
	$map->basemap = $this->GetPreference('default_basemap');
}
if ($map->initial_extent == NULL) {
	$map->initial_extent = $this->GetPreference('initial_extent');
}

if ($map->template_name == 'default') {
    $this->FireDebug('info', 'Processing default template');
	echo $this->ProcessTemplate('map.tpl');
} else {
	echo $this->ProcessTemplateFromDatabase($map->template_name);
}
?>
