<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Save changes to a map template
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/

// make sure we're running as a cmsms module action
if (!isset($gCms)) exit; 

if (isset($params['cancel'])) {
	$this->RedirectToAdminTab('templates');
} else if (isset($params['submit'])) {
    if ($params['name'] == 'default') {
        $params['error'] = '"default" is not a valid template name.';
        $this->Redirect($id,'admin_add_template',$returnid,$params);
    }
    if (!isset($params['name']) || strlen($params['name']) == 0 || is_null($params['name'])) {
        $params['error'] = $this->Lang('error_template_no_name');
        $this->Redirect($id, 'admin_add_template', $returnid, $params);
    }
    $template = new rdffg_template;
	$template->name = $params['name'];
	$template->content = $params['template_code'];
    try {
        $this->SetTemplate($params['name'],$params['template_code']);
    } catch (Exception $e) {
        $params['error'] = 'Failed to save template, '.$e->getMessage();
    }

    $this->RedirectToAdminTab('templates', $params);

} else {
	// should never get here
	$this->FireDebug('warning','Got to save template with no submit or cancel action defined.');
	$this->RedirectToAdminTab('templates');
}
?>
