<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Edit a map template
 *
 * copyright 2013, Regional District of Fraser-Fort George
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or
 * read it online: http://www.gnu.org/licenses/licenses.html#GPL

**/

// make sure we're running as a cmsms module action
if (!isset($gCms)) exit; 

$template = new Template();
if (isset($params['template_name'])) {
    // populate fields from the database
    try {
        $template->content = $this->GetTemplate($params['template_name']);
    } catch (Exception $e) {
        $this->RedirectToAdminTab(
                'templates',
                array('error'=> 'Failed to load template '.$params['template_name'].' Also, '.$e->getMessage()));
    }
    if (!isset($params['copy_template'])) {
        $template->name = $params['template_name'];
    }
} else {
    // new template -- populate code with the default template.
    $template->content = file_get_contents(__DIR__.'/templates/map.tpl');
}

// populate the fields with data in we are returning from this page, ie
// following failed form validation.
if (isset($params['name'])) $template->name = $params['name'];
if (isset($params['code'])) $template->content = $params['template_code'];

$smarty = $this->smarty;
$smarty->assign('start_form', $this->CreateFormStart($id, 'admin_save_template', $returnid));
$smarty->assign('name', 
    $this->CreateInputText($id, 
        'name', 
        $template->name, 
        96, 
        96, 
        strlen($template->name) > 0 && !array_key_exists('copy_template',$params) ?' readonly="readonly"':''));
$smarty->assign('title_name', $this->Lang('title_template_name'));
$smarty->assign('code', $this->CreateSyntaxArea($id, $template->content, 'template_code'));
$smarty->assign('title_code', $this->Lang('title_template_code'));
$smarty->assign('help_name', $this->Lang('help_template_name'));
$smarty->assign('help_code', $this->Lang('help_template_code'));
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));
if (isset($params['error'])) {
    $smarty->assign('error', $params['error']);
}
echo $this->ProcessTemplate('edit_template.tpl');
?>
