<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGJobMgr (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to manage jobs that take considerable
#  amounts of time to process.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgjobmgr_iterativetask extends cgjobmgr_task
{
  /**
   * Run the specified functions.
   * This task calls the specified function and interprets the result
   *
   * If the status returned from the function is invalid, an exception is thrown.
   */
  protected function _run_task()
  {
    $fn = $this->get_function();
    if( !is_callable($fn) ) throw new CGJobMgrException('Invalid function specification');

    $res = call_user_func_array($fn,array(&$this));
    switch( $res ) {
    case self::STATUS_ERROR:
    case self::STATUS_INCOMPLETE:
    case self::STATUS_COMPLETE:
      $this->set_status($res);
      return $res;
    default:
      throw new CGJobMgrException('Invalid return value from task function');
    }
  }


  /**
   * Perform the task numerous times until allowed time is elapsed
   *
   * This method asks the job manager for the amout of time that it is allowed to run, and other data
   * then executes the task, and calculates a running average of the amount of time required to perform
   * the task.  The running avaerage, and a slack factor is used to determine if the task can be
   * executed again
   */
  public function execute()
  {
    $jobmgr = cgjobmgr_jobhandler::get_instance();

    // get the total amount of time we're allowed to process
    $orig_timelimit = ini_get('max_execution_time');
    if( $orig_timelimit <= 0 ) $orig_timelimit = 30;
    $max_timelimit = $jobmgr->get_value('max_time',0);
    $max_timelimit = max($orig_timelimit,$max_timelimit);
    set_time_limit($max_timelimit);

    // ready to go.
    $total_time = 0;
    $average_time = 0;
    $num_iterations = 0;
    while( ($total_time + $average_time) < ($max_timelimit * 0.95) ) {
      $start_time = microtime(true);
      $status = $this->_run_task();

      $td = microtime(true) - $start_time;
      $total_time += $td;
      $average_time = ($average_time * $num_iterations + $td)/($num_iterations + 1);
      $num_iterations++;

      switch( $status ) {
      case self::STATUS_ERROR:
	$this->set_status($status);
	throw new CGJobMgrException($this->get_name().' failed');

      case self::STATUS_COMPLETE:
	// done
	$this->set_status($status);
	return;

      case self::STATUS_INCOMPLETE:
	// go at it again
	$this->set_status($status);
	break;

      default:
	throw new CGJobMgrException('Invalid return value: '.$status.' from task function');
      }
    }
  }
} // end of class

#
# EOF
#
?>