<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGJobMgr (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to manage jobs that take considerable
#  amounts of time to process.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgjobmgr_autohandler extends cgjobmgr_jobhandler
{
  public function process()
  {
    $job =& $this->_job;

    // process a task
    switch( $job->get_status() ) {
    case cgjobmgr_job::STATUS_UNSTARTED:
      try {
	// if there is a start task
	if( ($task = $job->get_start_task()) ) {
	  $task->execute();
	  audit($job->get_id(),'CGJobMgr - AutoJobHandler -- Executed start task: '.$task->get_name());
	}
	$job->set_status(cgjobmgr_job::STATUS_INPROGRESS);
      }
      catch( Exception $e ) {
	audit($job->get_id(),'CGJobMgr','ERROR: '.$e->getMessage());
	$job->set_status(cgjobmgr_job::STATUS_ERROR,$e->getMessage());
      }
      break;

    case cgjobmgr_job::STATUS_INPROGRESS:
      try {
	// first, get the current task.
	$task = $job->get_current_task();
	if( $task ) {
	  $task->execute();
	  if( $job->recur_interval == 0 ) $job->set_priority($job->get_priority()-1);
	  audit($job->get_id(),'CGJobMgr','CGJobMgr - AutoJobHandler -- Executed task: '.$task->get_name().' -- task status: '.$task->get_status());
	}
	else {
	  $job->set_status(cgjobmgr_job::STATUS_COMPLETING);
	}
      }
      catch( Exception $e ) {
	audit($job->get_id(),'CGJobMgr','ERROR: '.$e->getMessage());
	$job->set_status(cgjobmgr_job::STATUS_ERROR,$e->getMessage());
      }
      break;

    case cgjobmgr_job::STATUS_COMPLETING:
      try {
	// if there is a end task
	if( ($task = $job->get_end_task()) ) {
	  $task->execute();
	  audit($job->get_id(),'CGJobMgr','AutoJobHandler -- Executed end task: '.$task->get_name());
	}

	$job->set_status(cgjobmgr_job::STATUS_FINISHED);

	$mod = cms_utils::get_module('CGJobMgr');
	$mod->SendEvent('JobFinished',array('job'=>$this));
      }
      catch( Exception $e ) {
	audit($job->get_id(),'CGJobMgr','ERROR: '.$e->getMessage());
	$job->set_status(cgjobmgr_job::STATUS_ERROR,$e->getMessage());
	$mod->SendEvent('JobError',array('job'=>$this,'error'=>$e->GetMessage(),'exception'=>$e));
      }
      break;

    default:
      // throw a new exception, shouldn't ever get here.
      throw new CGJobMgrException('Job with invalid status attempted to process');
      break;
    }

    // handle an error or something
    switch( $job->get_status() ) {
    case cgjobmgr_job::STATUS_ERROR:
      // here we will try to send an email or something.
      break;

    default:
      // do nothing...
      break;
    }

    return $job->get_status();
  }
} // end of class

#
# EOF
#
?>