<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGJobMgr (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to manage jobs that take considerable
#  amounts of time to process.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Manage Jobs') ) exit;

$query = 'SELECT * FROM '.cms_db_prefix().'module_cgjobmgr ORDER BY modified DESC';
$jobs = $db->GetArray($query);
$userops = cmsms()->GetUserOperations();
$usercache = array();

if( $jobs ) {
  for( $i = 0; $i < count($jobs); $i++ ) {
    if( isset($jobs[$i]['owner']) && $jobs[$i]['owner'] > 0 ) {
      $uid = $jobs[$i]['owner'];
      if( !isset($usercache[$uid]) ) {
	$user = $userops->LoadUserById($uid);
	if( is_object($user) ) $usercache[$uid] = $user->username;
      }
      if( isset($usercache[$uid]) ) $jobs[$i]['owner_name'] = $usercache[$uid];
    }
    if( in_array($jobs[$i]['status'],array(cgjobmgr_job::STATUS_INPROGRESS,cgjobmgr_job::STATUS_COMPLETING)) ||
	($jobs[$i]['recur_interval'] > 0 && $jobs[$i]['status'] != cgjobmgr_job::STATUS_PAUSED) ) {

      $jobs[$i]['pause_link'] = $this->CreateImageLink($id,'admin_pausejob','',
						       $this->Lang('pause'),
						       'control_pause_blue.png',
						       array('jobid'=>$jobs[$i]['id'],'pause'=>1),
						       '',$this->Lang('confirm_pause'));
    }
    else if( $jobs[$i]['status'] == cgjobmgr_job::STATUS_PAUSED ) {
      $jobs[$i]['pause_link'] = $this->CreateImageLink($id,'admin_pausejob','',
						       $this->Lang('resume'),
						       'control_play_blue.png',
						       array('jobid'=>$jobs[$i]['id'],'pause'=>0),
						       '',$this->Lang('confirm_unpause'));
    }
    if( !in_array($jobs[$i]['status'],array(cgjobmgr_job::STATUS_INPROGRESS,cgjobmgr_job::STATUS_COMPLETING)) ) {
      $jobs[$i]['delete_link'] = $this->CreateImageLink($id,'admin_deletejob','',
							$this->Lang('delete'),
							'icons/system/delete.gif',
							array('jobid'=>$jobs[$i]['id']),
							'',$this->Lang('confirm_delete'));
    }
  }
  $smarty->assign('jobs',$jobs);
}

$smarty->assign('link_deletefinished',
		$this->CreateImageLink($id,'admin_deletefinished',$returnid,
				       $this->Lang('prompt_deletefinished'),
				       'icons/system/delete.gif',
				       array(),'',
				       $this->Lang('confirm_deletefinished'),
				       false));
				       
echo $this->ProcessTemplate('admin_jobstab.tpl');

#
# EOF
#
?>