<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGJobMgr (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to manage jobs that take considerable
#  amounts of time to process.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// setup
//
$handlers = ob_list_handlers(); 
for ($cnt = 0; $cnt < sizeof($handlers); $cnt++) { ob_end_clean(); }

$job_timeout = (int)$this->GetPreference('task_timeout');
if( $job_timeout > 0 ) {
  $job_timeout = max(10,min(9999,$job_timeout));
  set_time_limit($job_timeout);
}
$iterative_slack = (float)$this->GetPreference('iterative_slack',1.5);
$iterative_slack = max(0.25,min(5.0,$iterative_slack));

$cronjob_interval = $this->GetPreference('cronjob_interval');
$cronjob_interval = max(0,min(9999,$cronjob_interval));

$escalation_intervallimit = $this->GetPreference('escalation_intervallimit',10);
$escalation_intervallimit = min(100,max(1,$escalation_intervallimit));

try {
  if( !isset($params['jobid']) ) {

    // reset any recurring jobs that are finished.
    $time = $db->DbTimeStamp(time()-30);
    $query = 'UPDATE '.cms_db_prefix()."module_cgjobmgr SET status = ? 
               WHERE status = ? AND COALESCE(recur_interval,0) > 0 AND COALESCE(locked,0) = 0 AND modified < $time";
    $dbr = $db->Execute($query,array(cgjobmgr_job::STATUS_UNSTARTED,cgjobmgr_job::STATUS_FINISHED));

    if( $cronjob_interval > 0 ) {
      $escalate_from = time() - $cronjob_interval * 60 * $escalation_intervallimit;
      $escalate_from = $db->DbTimeStamp($escalate_from);

      // Here we unlock any jobs that have been locked for a long time.
      $query = 'UPDATE '.cms_db_prefix()."module_cgjobmgr SET locked = 0
                 WHERE COALESCE(locked,0) = 1 AND (status = ? OR status = ?) AND modified < $escalate_from";
      $db->Execute($query,array(cgjobmgr_job::STATUS_INPROGRESS,
				cgjobmgr_job::STATUS_COMPLETING));

      // here we adjust the priority of tasks based on some criteria so that
      // lower priority jobs are not always drowned out by higher prioroty jobs.
      // @todo change the 3600 to N*60 increments.  need preference for increment in minutes.
      $query = 'UPDATE '.cms_db_prefix()."module_cgjobmgr SET priority=priority+2
                 WHERE priority <= ? AND priority > ? AND COALESCE(locked,0) = 0 AND status = ? AND modified < $escalate_from";
      $db->Execute($query,array(cgjobmgr_job::PRIORITY_NORMAL,cgjobmgr_job::PRIORITY_LOW,
				cgjobmgr_job::STATUS_UNSTARTED));

      $query = 'UPDATE '.cms_db_prefix().'module_cgjobmgr SET priority=priority+1
                 WHERE priority <= ? AND COALESCE(locked,0) = 0 AND status = ? AND modified < $escalate_from';
      $db->Execute($query,array(cgjobmgr_job::PRIORITY_LOW,
				cgjobmgr_job::STATUS_UNSTARTED));
    }
  }

  // find a job we can start
  $keys = array(cgjobmgr_job::STATUS_PAUSED,cgjobmgr_job::STATUS_FINISHED,cgjobmgr_job::STATUS_ERROR,
		cgjobmgr_job::STATUS_ABORTED,cgjobmgr_job::STATUS_ERROR);
  $tmp = '';
  if( !isset($params['jobid']) ) {
    // this is our task selection mechanism... this may need to be optimized
    $query = 'SELECT * FROM '.cms_db_prefix().'module_cgjobmgr WHERE COALESCE(locked,0) = 0 
              AND COALESCE(start_at,0) <= UNIX_TIMESTAMP() AND status NOT IN ('.cge_array::implode_quoted($keys).') 
              ORDER BY priority DESC, modified ASC';
    $tmp = $db->GetRow($query);
  }
  else {
    $query = 'SELECT * FROM '.cms_db_prefix().'module_cgjobmgr WHERE COALESCE(locked,0) = 1 
              AND COALESCE(start_at,0) <= UNIX_TIMESTAMP() AND id = ? AND status NOT IN ('.cge_array::implode_quoted($keys).')';
    $tmp = $db->GetRow($query,array((int)$params['jobid']));
  }

  // did we get a job?
  if( !$tmp ) {
    $time = $this->GetPreference('last_ping_time',0);
    if( $time < time() - 7200 ) {
      audit('',$this->GetName(),'PING: No jobs found (pings at least every 2 hours)');
      $this->SetPreference('last_ping_time',time());
    }

    return;
  }

  // we have a job to play with.
  // get the job
  $job = cgjobmgr_job::load_from_data($tmp);
  $job->lock();

  audit($job->id,$this->GetName(),'Processing Job '.$job->name);

  if( !isset($params['runcount']) ) $job->set_persistent_value('__NUM_AUTOTASK_ITERATIONS__',0);
  
  // get our handler.
  $jobmgr = new cgjobmgr_autohandler($job);

  // set some stuff into the job manager... maybe time limits, notification rules, etc.
  $jobmgr->set_value('iterative_slack',$iterative_slack);
  $jobmgr->set_value('max_time',$job_timeout);
  $jobmgr->set_value('max_autotask_iterations',$this->GetPreference('max_autotask_iterations',10));

  // then do the work.
  $status = $jobmgr->process();

  // this will do the check to see if we can iterate via a redirect.
  // to prevent the browser complaining about a redirect loop.
  // this number can be larger, if the maximum timeout is larger.
  $can_iterate = $job->get_iterate_flag();
  $iter = 0;
  if( $can_iterate ) {
    $max_autotask_iterations = $this->GetPreference('max_autotask_iterations',10);
    $max_autotask_iterations = min(20,max(0,$max_autotask_iterations));
    if( $max_autotask_iterations > 0 ) {
      $iter = $job->get_persistent_value('__NUM_AUTOTASK_ITERATIONS__',0);
      if( isset($params['runcount']) ) {
	// we are here via a iteration redirect.
	$iter++;
	if( $iter >= $max_autotask_iterations ) {
	  audit($job->get_id(),$this->GetName(),'reached '.$iter.' iterations... must wait for cron job to restart this job');
	  $can_iterate = FALSE;
	  $iter = 0;
	}
	$job->set_persistent_value('__NUM_AUTOTASK_ITERATIONS__',$iter);
      }
    }
  }
  
  // save the job
  $job->save();

  // are we done, or do we have to redirect?
  if( in_array($job->get_status(),$keys) || !$can_iterate ) {
    // job is finished (or stopped for some reason)
    $job->unlock();
  }
  else {
    // if the job is not done... we have to redirect somewhere.
    $contentops = cmsms()->GetContentOperations();
    $returnid = $contentops->GetDefaultContent(); // change me, use page in preferences.

    // the repeat process.. is just so we dont get too many redirects.
    $url = $this->create_url($id,'process',$returnid,array('showtemplate'=>'false','runcount'=>$iter,'jobid'=>$job->get_id(),'time'=>time()));
    $url = str_replace('&amp;','&',$url);
    redirect($url);
  }
}
catch( Exception $e ) {
  audit('',$this->GetName(),'Exception: '.$e->getMessage());
}

exit;
#
# EOF
#
?>