<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGJobMgr (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to manage jobs that take considerable
#  amounts of time to process.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

$cgextensions = cms_join_path($gCms->config['root_path'],'modules','CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) ) {
  echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
  return;
}
require_once($cgextensions);

class CGJobMgr extends CGExtensions
{
  private $_stats;

  public function InitializeFrontend()
  {
    $this->SetParameterType('time',CLEAN_INT); // used to randomize URLS.
    $this->SetParameterType('runcount',CLEAN_INT);
    $this->SetParameterType('jobid',CLEAN_INT);
    $this->RestrictUnknownParams();
    $this->RegisterRoute('/'.$this->GetName().'\/process$/', array('action'=>'process','showtemplate'=>'false'));
  }

  public function InitializeAdmin() { $this->AddImageDir('icons'); }
  public function GetName() { return get_class($this); }
  public function GetFriendlyName() { return $this->Lang('friendlyname'); }
  public function GetVersion() { return '1.3.1'; }
  public function GetDependencies() { return array('CGExtensions'=>'1.38.1'); }
  public function MinimumCMSVersion() { return '1.11.8'; }
  public function GetAdminSection() { return 'siteadmin'; }
  public function LazyLoadAdmin() { return TRUE; }
  public function GetHelp() { return @file_get_contents(__DIR__.'/help.inc'); }
  public function GetAuthor() { return 'calguy1000'; }
  public function GetAuthorEmail() { return 'calguy1000@gmail.com'; }
  public function IsPluginModule() { return true; }
  public function GetAdminDescription() { return $this->Lang('moddescription'); }
  public function HasAdmin() { return true; }
  public function GetChangeLog() { return @file_get_contents(__DIR__.'/changelog.inc'); }
  public function InstallPostMessage() { return $this->Lang('postinstall'); }
  public function UninstallPostMessage() { return $this->Lang('postuninstall'); }
  public function GetEventHelp( $eventname ) { return $this->Lang('help_event_'.$eventname); }
  public function AllowAutoInstall() { return FALSE; }
  public function AllowAutoUpgrade() { return FALSE; }
  
  public function VisibleToAdminUser() {
    return $this->CheckPermission('Manage Jobs') || $this->CheckPermission('Modify Site Preferences');
  }
  
} // end of class

#
# EOF
#
?>
