(function($){
  $.widget('calguy1000.cggm2', {
    // possible options: zoom, (mapTypeID || type), center, mapinstance, staticpoints, infowindow, infowindow_trigger, infowindow_cb, 
    // infowindow_content_cb, zoomcontrol, zoomControlOptions, type_controls, icons, nav_controls, scale_controls, sv_controls, width, height,
    // infowindow_boxClass, tooltip, tooltip_Class, marker_click_cb, marker_mouseover_cb, marker_mouseout_cb, directions, sv_radius, 
    // type_control_options, directions_dest, directions_units, sensor, sensor_center, sensor_marker, sensor_icon, zoom_encompass,
    // bounds_fudge, combine_points, point_combine_fudge, combined_icon, default_icon, idle_cb, mylocation, youareherestr
    options: {
      zoop: 5,
      mapTypeId: 'roadmap'
    },

    _create: function() {
      var mapOptions = this._getMapOptions();
      if( typeof this.options.infowindow_cb == 'undefined' ) this.options.infowindow_cb = this._doInfoWindow;
      if( typeof this.options.infowindow_boxClass == 'undefined' ) this.options.infowindow_boxClass = 'infoBox';
      if( typeof this.options.tooltip_Class == 'undefined' ) this.options.tooltip_Class = 'm_tooltip';

      this.data = {
        map: null,
        icons: {},
        markers: [],
        inupdate: 0,
        directionsService: null,
        directionsDisplay: null
      };

      this.data.map = new google.maps.Map(this.element[0],mapOptions);
      this.data.map.cggm = this;
      google.maps.event.addListener(this.data.map,'idle',this._doIdle);
      if( this.options.directions ) this.data.directionsService = new google.maps.DirectionsService();
      if( this.options.directions && this.options.directions_draw ) {
        this.data.directionsDisplay = new google.maps.DirectionsRenderer();
        this.data.directionsDisplay.setMap(this.data.map);
      }
      this._getInfoWindow();
      this._createIcons();
      this._update();

      if( this.options.sensor ) {
	var self = this;
	if( navigator.geolocation ) {
	  navigator.geolocation.getCurrentPosition(function(pos) {
	    self.options.mylocation = new google.maps.LatLng(pos.coords.latitude,pos.coords.longitude);
	    if( self.options.sensor_marker ) self._addMyLocationMarker();
          });
	}
      }
      this._trigger('ready', null, { value: 'foo' });
    },

    _setOption: function( key, value ) {
      if( key == 'icons' || key == 'icon' ) return;
      this.options[key] = value;
      if( this.data.directions && this.data.directionsService == null ) {
        this.data.directionsService = new google.maps.DirectionsService();
      }
      if( this.options.directions && this.options.directions_draw && this.data.directionsDisplay == null ) {
	this.data.directionsDisplay = new google.maps.DirectionsRenderer();
      }
      this._update();
    },

    getMap: function() {
      return this.data.map;
    },

    addMarker: function( markerOptions ) {
      if( typeof(markerOptions) != 'object' ) {
        console.debug('addMarker - invalid marker options');
	return;
      }
      if( typeof(markerOptions.position) == 'undefined' || typeof(markerOptions.name) == 'undefined' ) {
	console.debug('addMarker - invalid marker options object');
	return;
      }
      markerOptions.map = this.data.map;
      if( markerOptions.position ) markerOptions.position = this._latLng(markerOptions.position);
      var marker = new google.maps.Marker(markerOptions);
      marker.name = markerOptions.name;
      if( markerOptions.container ) marker.container = markerOptions.container;
      marker.cggm = this;
      this.data.markers[marker.name] = marker;

      if( this.options.infowindow && this.options.infowindow_trigger ) {
	google.maps.event.addListener(marker,this.options.infowindow_trigger,this.options.infowindow_cb);
      }

      if( this.options.tooltip && markerOptions.tooltip ) {
        var opts = {
	  marker: marker,
  	  content: markerOptions.tooltip,
  	  cssClass: this.options.tooltip_Class
        };
        marker.tooltip = new Tooltip(opts);
	delete marker.title;
      }

      if( typeof this.options.marker_click_cb === 'function' ) google.maps.event.addListener(marker,'click',this.options.marker_click_cb);
      if( typeof this.options.marker_mouseover_cb === 'function' ) {
	google.maps.event.addListener(marker,'mouseover',this.options.marker_mouseover_cb);
      }
      if( typeof this.options.marker_mouseout_cb === 'function' ) {
	google.maps.event.addListener(marker,'mouseover',this.options.marker_mouseout_cb);
      }

      if( marker.zoom_encompass == 'auto' ) {
        bounds = this.data.map.getBounds();
        bounds.extend(marker.position);
	this.data.map.fitBounds(bounds);
      }

      this._update();
      this._trigger('markerAdded',marker);
    },

    removeAllMarkers: function() {
      for( var p in this.data.markers) {
	this.data.markers[p].setMap(null);
      }
      this.data.markers = Array();
      this._trigger('clearAllMarkers',null);
    },

    removeMarker: function(id) {
      if( this.data.markers[id] ) {
        this.data.markers[id].setMap(null);
        delete this.data.markers[id];
      }
      this._update();
      this._trigger('markerRemoved',marker);
    },

    addIcon: function(opts) {
      if( typeof opts.name == 'undefined' || typeof opts.href == 'undefined' ) return;
      this.data.icons[opts.name] = opts;
    },

    getMarkerList: function() {
      var out = [];
      if( typeof this.options.mylocation != 'undefined' ) {
        var str = 'My Location';
        if( typeof this.options.mylocationstr != 'undefined' ) str = this.options.mylocationstr;
        out.push({ 'value': '__MYLOCATION__', 'text': str });
      }
      for( key in this.data.markers ) {
	if( key != 'undefined' ) out[key] = key;
        out.push({ value: key, text: key });
      }
      return out;
    },

    getDirections: function(list,callback) {
      if( typeof this.options.directions == 'undefined' || !this.options.directions ) return;
      self = this;

      function _getLocPosition(key) {
	if( key == '__MYLOCATION__' && self.options.mylocation ) return self.options.mylocation;
        if( typeof self.data.markers[key] == 'undefined' ) return;
        return self.data.markers[key].position;
      };

      if( list.length < 2 ) return;
      if( list[0] == list[list.length-1] ) return;

      var opts = {
        origin: _getLocPosition(list[0]),
        destination: _getLocPosition(list[list.length-1]),
        travelMode: google.maps.DirectionsTravelMode.DRIVING,
        unitSystem: google.maps.DirectionsUnitSystem[this.options.directions_units]
      };
      if( list.length > 2 ) {
        var waypoints = [];
        for( var i = 1; i < list.length - 1; i++ ) {
          waypoints.push({ location: _getLocPosition(list[i]) });
	}
        opts.waypoints = waypoints;
      }
      if( typeof callback === 'function' ) {
        self.data.directionsService.route(opts,function(result,status) {
          if( this.options.directions_draw ) self.data.directionsDisplay.setDirections(result);
          callback({ map: self.data.map, directions: result });
        });
      }
    },

    /*** helper methods ***/

    _doIdle: function(e) {
      var timer;
      var map = this;
      clearTimeout(timer);
      timer = setTimeout(function() {
       if( typeof map.cggm.options.idle_cb === 'function' ) map.cggm.options.idle_cb(self);
       map.cggm._trigger('idle');
      }, 500);
    },

    _getInfoWindowContents: function(marker) {
      var self = marker.cggm;
      var ntabs = 0;
      var tabcontent = null;
      if( typeof self.options.infowindow_content_cb == 'function' ) {
        tabcontent = self.options.infowindow_content_cb(self,marker);
      }
      else if( marker.bubbletext ) {
        tabcontent = marker.bubbletext;
      }
      else if( marker.container ) {
        tabcontent = $('.cggm2_infowindow_item',marker.container).html();
      }
      return tabcontent;
    },

    _getInfoWindow: function() {
      if( typeof this.data.infowindow == 'undefined' ) {
        var opts = {};
        opts.boxClass = this.data.infowindow_boxClass;
        this.data.infowindow = new InfoBox(opts);
      }
      return this.data.infowindow;
    },

    _doInfoWindow: function() {
       var self = this.cggm;
       content = self._getInfoWindowContents(this);
       if( content ) {
         infowindow = self._getInfoWindow();
         infowindow.setContent(content);
         infowindow.setPosition(this.getPosition());
         infowindow.open(self.data.map,this);
       }
    },

    /**
     * Helper method for google.maps.Latlng
     * @param latLng:string/google.maps.LatLng
     */
    _latLng: function(latLng) {
      if ( !latLng ) return new google.maps.LatLng(0.0, 0.0);
      if ( latLng instanceof google.maps.LatLng ) {
	return latLng;
      } if( latLng instanceof Array && latLng.length == 2 ) {
        return new google.maps.LatLng(latLng[0],latLng[1]);
      } else {
	latLng = latLng.replace(/ /g,'').split(',');
	return new google.maps.LatLng(latLng[0], latLng[1]);
      }
    },

    _getMapOptions: function() {
      var opts = {};
      var iopts = this.options;
      opts.mapTypeId = 'roadmap';
      if( typeof this.options.type != 'undefined' ) {
	if( this.options.type == 'map' ) this.options.type = 'roadmap';
	opts.mapTypeId = this.options.type;
      }
      opts.zoom = this.options.zoom;
      opts.center = this._latLng("0, 0");
      opts.zoomcontrol = true;
      opts.zoomControlOptions = { style: 'default' }; // fix me.
      if( typeof iopts.center != 'undefined' ) opts.center = this._latLng(iopts.center);
      if( typeof iopts.type_controls != 'undefined' ) opts.mapTypeControl = Boolean(iopts.type_controls);
      if( typeof iopts.type_control_options != 'undefined' ) opts.mapTypeControlOptions = { style: iopts.type_control_option };
      if( typeof iopts.nav_controls != 'undefined' ) opts.panControl = Boolean(iopts.nav_controls);
      if( typeof iopts.scale_controls != 'undefined' ) opts.scaleControl = Boolean(iopts.scale_controls);
      if( typeof iopts.sv_controls != 'undefined' ) opts.streetViewControl = Boolean(iopts.sv_controls);
      return opts;
    },

    _createIcons: function() {
      if( typeof this.options.icons != undefined ) {
        this.data.icons = this.options.icons;
        delete this.options.icons;
      }
    },

    _getIcon: function(preferred) {
       if( typeof this.data.icons != 'undefined' ) {
	 if( typeof this.data.icons[preferred] != 'undefined' ) {
	   return this.data.icons[preferred];
	 }
         if( typeof this.data.icons[this.options.default_icon] != 'undefined' ) {
	   return this.data.icons[this.options.default_icon];
	 }
         for( var tmp in this.data.icons ) {
	   return this.data.icons[tmp];
	 }
       }
    },

    _addMyLocationMarker: function() {
      if( this.options.sensor && this.options.sensor_marker && typeof this.options.mylocation != 'undefined' && this.options.mylocation != null ) {
	var opts = {
	  position: this.options.mylocation,
	  name: '** My Location **',
          icon: this._getIcon(this.options.sensor_icon),
	  title: (typeof this.options.youareherestr != 'undefined') ? this.options.youareherestr : ''
	};
	this.addMarker(opts);
      }
    },

    _addStaticMarkers: function() {
      var self = this;
      var selector = null;
      if( this.options.markers ) {
        $.each(this.options.markers,function(idx,markerOpts){
	  if( typeof(markerOpts) == 'object' ) {
	    if( markerOpts.icon && typeof self.data.icons[markerOpts.icon] != 'undefined' ) markerOpts.icon = self._getIcon(markerOpts.icon);
            self.addMarker(markerOpts);
	  }
        });
      }
      if( this.options.mapinstance ) selector = $('#cggm2_map_data_'+this.options.mapinstance);
      if( this.options.staticpoints ) selector = this.options.staticpoints;
      if( selector == null ) return;
      $('div.cggm2_marker',selector).each(function(){
	var opts = {};
        opts.container = this;
	opts.name = $(":input[name='name']",this).val();
	opts.title = $(":input[name='title']",this).val();
        opts.position = jQuery(":input[name='latitude']",this).val()+', '+jQuery(":input[name='longitude']",this).val();
	var tooltip = $(":input[name='tooltip']",this).val();
	if( typeof tooltip != 'undefined' && tooltip.length > 0 ) opts.tooltip = tooltip;
	var icon = $(":input[name='icon']",this).val();
	if( icon.length > 0 && typeof self.data.icons[icon] != 'undefined' ) opts.icon = self._getIcon(icon);
	self.addMarker(opts);
      });
    },

    _update: function() {
      if( this.data.inupdate == 0 ) {
	this.data.inupdate = 1;
        this.removeAllMarkers();
        this._addStaticMarkers();
        this._addMyLocationMarker();
	if( this.options.sensor &this.options.sensor_center && typeof this.options.mylocation != 'undefined' ) {
	  self.data.map.setCenter(this.options.mylocation);
	}
        // this._addKMLFiles(); // todo
        // this._addLayers(); // todo
	this.data.inupdate = 0;
	this._trigger('update', null, { value: 'foo' });
      }
    },

    __nothing: function() {}
  });
})(jQuery);
