<?php
if (!isset($gCms)) exit;

$db = $gCms->GetDb();
$prfx = cms_db_prefix();

$dict = NewDataDictionary( $db );

#Create Tables
$table_name = "{$prfx}module_newsletter_mailing";
$table_options = array('mysql' => 'TYPE=MyISAM');
$fields = "id                   I NOTNULL KEY AUTO,
           mailing_name         C(255) NOTNULL,
           sender_email         C(255) NOTNULL,           
           subject              C(255) NOTNULL,
           template_id          I,
           content              X,
           txt_content          X,
           date_created         ".CMS_ADODB_DT.",
           date_modified        ".CMS_ADODB_DT.",
           date_mailing         ".CMS_ADODB_DT;
$sqlarray = $dict->CreateTableSQL( $table_name, $fields, $table_options);
$dict->ExecuteSQLArray($sqlarray);

$table_name = "{$prfx}module_newsletter_template";
$table_options = array('mysql' => 'TYPE=MyISAM');
$fields = "id                   I NOTNULL KEY AUTO,
           template_name        C(255) NOTNULL,
           template_content     X,
           txt_template_content X,
           date_created         ".CMS_ADODB_DT.",
           date_modified        ".CMS_ADODB_DT.",
           active               C(1) NOTNULL DEFAULT 1";

$sqlarray = $dict->CreateTableSQL( $table_name, $fields, $table_options);
$dict->ExecuteSQLArray($sqlarray);

$table_name = "{$prfx}module_newsletter_settings";
$table_options = array('mysql' => 'TYPE=MyISAM');
$fields = "id                   I NOTNULL KEY AUTO,
           setting_name         C(255) NOTNULL,
           value                C(255)";

$sqlarray = $dict->CreateTableSQL( $table_name, $fields, $table_options);
$dict->ExecuteSQLArray($sqlarray);

#Create Indexes
$sqlarray = $dict->CreateIndexSQL("{$prfx}date_created", "{$prfx}module_newsletter_mailing", 'date_created');
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL("{$prfx}date_modified", "{$prfx}module_newsletter_mailing", 'date_modified');
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL("{$prfx}template_id", "{$prfx}module_newsletter_mailing", 'template_id');
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL("{$prfx}date_created", "{$prfx}module_newsletter_template", 'date_created');
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL("{$prfx}date_modified", "{$prfx}module_newsletter_template", 'date_modified');
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL("{$prfx}setting_name", "{$prfx}module_newsletter_settings", 'setting_name');
$dict->ExecuteSQLArray($sqlarray);

#Init data
$datetime = $db->DBTimeStamp(time());

$sample_template = $db->qstr(file_get_contents($this->GetModulePath()."/templates/samples/sample_template.tpl"));
$txt_sample_template = $db->qstr(file_get_contents($this->GetModulePath()."/templates/samples/txt_sample_template.tpl"));

$query = "INSERT INTO {$prfx}module_newsletter_template 
          (template_name, template_content, txt_template_content, date_created, date_modified, active) 
          VALUES 
          ('Sample template', $sample_template, $txt_sample_template, $datetime, $datetime, 1)";

$db->Execute($query);

$templateID = $db->Insert_ID();

$sample_mailing = $db->qstr(file_get_contents($this->GetModulePath()."/templates/samples/sample_mailing.tpl"));
$txt_sample_mailing = $db->qstr(file_get_contents($this->GetModulePath()."/templates/samples/txt_sample_mailing.tpl"));

$CMSMailer = $this->GetModuleInstance('CMSMailer');
$sender_email = $db->qstr($CMSMailer->GetFrom());
if(empty($sender_email))
  $sender_email = $db->qstr('newsletter@yourdomain.com');

$query = "INSERT INTO {$prfx}module_newsletter_mailing 
          (mailing_name, sender_email, subject, template_id, content, txt_content, date_created, date_modified) 
          VALUES 
          ('Sample mailing', $sender_email, 'Newsletter from CMS Madesimple', $templateID, $sample_mailing, $txt_sample_mailing, $datetime, $datetime)";

$db->Execute($query);

$query = "INSERT INTO {$prfx}module_newsletter_settings (setting_name) VALUES ('feu_email_field')";
$db->Execute($query);

$query = "INSERT INTO {$prfx}module_newsletter_settings (setting_name) VALUES ('feu_first_name_field')";
$db->Execute($query);

$query = "INSERT INTO {$prfx}module_newsletter_settings (setting_name, value) VALUES ('feu_last_name_field', '-1')";
$db->Execute($query);

#Permissions
$this->CreatePermission('Newsletter::ShowModule', $this->Lang('PermissionsShowModule'));
$this->CreatePermission('Newsletter::ViewMailings', $this->Lang('PermissionsViewMailings'));
$this->CreatePermission('Newsletter::CreateMailings', $this->Lang('PermissionsCreateMailings'));
$this->CreatePermission('Newsletter::DeleteMailings', $this->Lang('PermissionsDeleteMailings'));
$this->CreatePermission('Newsletter::ProcessMailings', $this->Lang('PermissionsProcessMailings'));
$this->CreatePermission('Newsletter::ViewTemplates', $this->Lang('PermissionsViewTemplates'));
$this->CreatePermission('Newsletter::CreateTemplates', $this->Lang('PermissionsCreateTemplates'));
$this->CreatePermission('Newsletter::DeleteTemplates', $this->Lang('PermissionsDeleteTemplates'));
$this->CreatePermission('Newsletter::ChangeModuleSettings', $this->Lang('PermissionsChangeModuleSettings'));

// put mention into the admin log
$this->Audit(0, $this->Lang('friendlyname'), $this->Lang('installed', $this->GetVersion()));
?>
