<?php
if (!isset($gCms)) exit;

if(!$this->CheckPermission('Newsletter::CreateTemplates'))
{
  $this->Redirect($id, 'defaultadmin', $returnid);
  exit();
}

$templateID = '';

if(!empty($params["template_id"]))
  $templateID = $params["template_id"];

if(!empty($params['act']) && $params['act'] == 'delete' && !empty($templateID))
{
  $this->DeleteNLTemplate($templateID);
  $this->Redirect($id, 'defaultadmin', $returnid, array('tab' => 'templates'));
  exit();
}
  
if(isset($params["save"]) || isset($params["save_exit"]))
{
  $templateID = $this->SaveTemplate($params);
  if($templateID && isset($params["save_exit"]))
  {
    $this->Redirect($id, 'defaultadmin', $returnid, array('tab' => 'templates'));
    exit();
  }  
}

if(isset($params["cancel"]))
{
  $this->Redirect($id, 'defaultadmin', $returnid, array('tab' => 'templates'));
  exit();
}

$template_data = array("template_name" => '',                       
                       "template_content" => '',
                       "txt_template_content" => '');

if(!empty($templateID) && empty($params['save']))
  $template_data = $this->FetchTemplateData($templateID);
  
if(!empty($params['act']) && $params['act'] == 'copy')
{
  $templateID = '';
  $template_data['template_name'] = '';  
}
                       
if(isset($params["template_name"]))
  $template_data["template_name"] = $params["template_name"];

if(isset($params["template_content"]))
  $template_data["template_content"] = $params["template_content"];

if(isset($params["txt_template_content"]))
  $template_data["txt_template_content"] = $params["txt_template_content"];

$smarty->assign('startForm', $this->CreateFormStart($id, 'edit_template', $returnid));
$smarty->assign('endForm', $this->CreateFormEnd());
$smarty->assign('SaveButton', $this->CreateInputSubmit($id, 'save_exit', lang('submitdescription')));
$smarty->assign('SaveAndExitButton', $this->CreateInputSubmit($id, 'save', lang('applydescription')));
$smarty->assign('CancelButton', $this->CreateInputSubmit($id, 'cancel', lang("cancel"), '', '', lang('confirmcancel')));
$smarty->assign('TemplateNameLabel', $this->CreateLabelForInput($id, 'template_name', lang('name')));
$smarty->assign('TemplateName', $this->CreateInputText($id, 'template_name', $template_data["template_name"], 60));
$smarty->assign('TemplateContentLabel', $this->CreateLabelForInput($id, 'template_content', $this->Lang('HTMLTemplate')));
$smarty->assign('TemplateContent', $this->CreateTextArea(true, $id, $template_data['template_content'], 'template_content'));
$smarty->assign('TXTTemplateContentLabel', $this->CreateLabelForInput($id, 'txt_template_content', $this->Lang('TXTTemplate')));
$smarty->assign('TXTTemplateContent', $this->CreateTextArea(false, $id, $template_data['txt_template_content'], 'txt_template_content'));
$smarty->assign('templateIDHiddenField', $this->CreateInputHidden($id, 'template_id', $templateID));

$admintheme = CmsAdminThemeBase::GetThemeObject();
$smarty->assign('infoIcon', $admintheme->DisplayImage('icons/system/info.gif', '', '', '', 'systemicon'));
$smarty->assign('AllowedTagsText', $this->Lang('AllowedTagsText'));
$smarty->assign('EmailText', $this->Lang('EmailText'));
$smarty->assign('UsernameText', lang('username'));

echo $smarty->fetch($this->GetFileResource("edit_template.tpl"));
?>
