<?php
if (!isset($gCms)) exit;

if(empty($params['act']) || !$this->CheckPermission('Newsletter::ProcessMailings'))
{
  $this->Redirect($id, 'defaultadmin', $returnid, array('tab' => 'mailings'));
  exit();
}

if(!empty($params['act']) && $params['act'] == 'do_job')
{
  if(empty($_POST['from']) || empty($_POST['subject']) || empty($_POST['address']) || empty($_POST['address_name']) || empty($_POST['body']) || empty($_POST['alt_body']))
  {
    echo json_encode(array("success" => false));
    exit();
  }
  
  $CMSMailer = $this->GetModuleInstance('CMSMailer');

  $CMSMailer->IsHTML(true);
  //$CMSMailer->SetFromName($_POST["from_name"]);
  $CMSMailer->SetSender($_POST["from"]);
  $CMSMailer->SetSubject($_POST["subject"]);
  $CMSMailer->SetBody($_POST['body']);
  $CMSMailer->SetAltBody($_POST['alt_body']);
      
  $CMSMailer->AddAddress($_POST['address'], $_POST['address_name']);
  
  $result = $CMSMailer->Send();  
  echo json_encode(array("success" => $result));
  exit();
}

if(isset($params["cancel"]))
{
  $this->Redirect($id, 'defaultadmin', $returnid, array('tab' => 'mailings'));
  exit();
}

if(!empty($params['act']) && $params['act'] == 'proccess_mails')
{
  $mail_data = $this->GetMailingData($params['mailing_id']);

  #Form JSON for Mail Jobs
  $mail_jobs = array();

  if(isset($params['cms_groups']))
  {
    $UserOperations = UserOperations::get_instance();
    
    foreach($params['cms_groups'] as $group_id)
    {
      $UsersInGroup = $UserOperations->LoadUsersInGroup($group_id);
      
      foreach($UsersInGroup as $User)
      {
        if($User->active != 1 || empty($User->email) || $User->username == 'admin')
          continue;
        
        $Username = '';
        if(!empty($User->firstname))
          $Username .= $User->firstname.' ';
        if(!empty($User->lastname))
          $Username .= $User->lastname;
        
        if(empty($Username))
          $Username = $User->username;
        
        $mail_jobs[] = array("from" => $mail_data["sender_email"],
                             "subject" => $mail_data["subject"],
                             "address" => $User->email,
                             "address_name" => $Username,
                             "body" => $this->ProcessPlaceholders($mail_data['mail_body'], $User),
                             "alt_body" => strip_tags($this->ProcessPlaceholders($mail_data['alt_mail_body'], $User)),
                             'showtemplate' => false);
      }
    }
  }

  $FrontEndUsers = $this->GetModuleInstance('FrontEndUsers');
  if(isset($params['feu_groups']) && $FrontEndUsers)
  {
    foreach($params['feu_groups'] as $group_id)
    {
      $UsersInGroup = $FrontEndUsers->GetUsersInGroup($group_id);
      
      foreach($UsersInGroup as $User)
      {
        if(strtotime($User['expires']) < time())
          continue;
        
        $mail_jobs[] = array("from" => $mail_data["sender_email"],
                             "subject" => $mail_data["subject"],
                             "address" => $this->GetFEUEmail($User),
                             "address_name" => $this->GetFEUUsername($User),
                             "body" => $this->ProcessPlaceholders($mail_data['mail_body'], $User, true),
                             "alt_body" => strip_tags($this->ProcessPlaceholders($mail_data['alt_mail_body'], $User, true)),
                             'showtemplate' => false);
      }        
    }
  }    
  
  $this->UpdateMailingSenddate($params['mailing_id']);
  
  // put mention into the admin log
  $this->Audit($params['mailing_id'], $this->Lang('friendlyname'), $this->Lang('EventLogMailingCommited'));
}

$smarty->assign('mail_jobs_json', json_encode($mail_jobs), true);
$smarty->assign('mail_jobs_count', count($mail_jobs), true);
$smarty->assign('TotalToSendText', $this->Lang('TotalToSend'));
$smarty->assign('SentText', $this->Lang('Sent'));
$smarty->assign('SendingMessageText', $this->Lang('SendingMessage'));
$smarty->assign('ErrorsText', $this->Lang('ErrorsWhileSending'));
$smarty->assign('DoneText', $this->Lang('Done'));
$smarty->assign('ErrorSendingText', $this->Lang('ErrorSending'));
$smarty->assign('ErrorsWhileSendingText', $this->Lang('ErrorsWhileSending'));
$smarty->assign('SelfLink', htmlspecialchars_decode($this->CreateLink($id, 'send_mails', $return_id, '', array('act' => 'do_job'), '', true)));
$smarty->assign('returnLink', $this->CreateLink($id, 'defaultadmin', $returnid, lang('close'), array(), '', false, false, 'class="cms_submit"'));

$admintheme = &$gCms->variables['admintheme'];
$smarty->assign('errorExistsIcon', $admintheme->DisplayImage('icons/system/warning.gif', '', '', '', 'systemicon errors hidden'));
$smarty->assign('completeIcon', $admintheme->DisplayImage('icons/system/accept.gif', '', '', '', 'systemicon complete hidden'));
$smarty->assign('loadingIcon', $admintheme->DisplayImage('../../../../modules/Newsletter/images/ajax-loader.gif', '', '', '', 'systemicon loading'));

$smarty->assign('backIcon', $admintheme->DisplayImage('icons/system/back.gif', '', '', '', 'systemicon'));

echo $smarty->fetch($this->GetFileResource("send_emails.tpl"));
?>
