<?php
if (!isset($gCms)) exit;

$smarty->assign('ViewMailingsPermission', $this->CheckPermission('Newsletter::ViewMailings'));
$smarty->assign('ViewTemplatesPermission', $this->CheckPermission('Newsletter::ViewTemplates'));
$smarty->assign('ChangeModuleSettingsPermission', $this->CheckPermission('Newsletter::ChangeModuleSettings'));
$smarty->assign('CreateMailingsPermission', $this->CheckPermission('Newsletter::CreateMailings'));
$smarty->assign('DeleteMailingsPermission', $this->CheckPermission('Newsletter::DeleteMailings'));
$smarty->assign('ProcessMailingsPermission', $this->CheckPermission('Newsletter::ProcessMailings'));
$smarty->assign('CreateTemplatesPermission', $this->CheckPermission('Newsletter::CreateTemplates'));
$smarty->assign('DeleteTemplatesPermission', $this->CheckPermission('Newsletter::DeleteTemplates'));

$smarty->assign('NoPermissionsText', $this->Lang('NoPermissions'));

$admintheme = &$gCms->variables['admintheme'];

$smarty->assign('startTabHeaders', $this->StartTabHeaders());
$smarty->assign('endTabHeaders', $this->EndTabHeaders());
$smarty->assign('startTabContent', $this->StartTabContent());
$smarty->assign('endTabContent', $this->EndTabContent());
$smarty->assign('endTab', $this->EndTab());

$activeTab = 'mailings';
if(!empty($params['tab']) && $params['tab'] == 'templates' && $this->CheckPermission('Newsletter::ViewTemplates'))
  $activeTab = 'templates';

if(!empty($params['tab']) && $params['tab'] == 'feu_settings' && $this->CheckPermission('Newsletter::ChangeModuleSettings'))
  $activeTab = 'feu_settings';

#common
$FrontEndUsers = $this->GetModuleInstance('FrontEndUsers');

$smarty->assign('FEUInstalled', ($FrontEndUsers));
$smarty->assign('MailingsTabHeader', $this->SetTabHeader('newsletters', $this->Lang('Mailings'), ($activeTab == 'mailings')));
$smarty->assign('TemplatesTabHeader', $this->SetTabHeader('templates', $this->Lang('EmailTemplates'), ($activeTab == 'templates')));
$smarty->assign('FEUSettingsTabHeader', $this->SetTabHeader('feu_settings', $this->Lang('FEUSettings'), ($activeTab == 'feu_settings')));
$smarty->assign('StartMailingsTabContent', $this->StartTab('newsletters', $params));
$smarty->assign('StartTemplatesTabContent', $this->StartTab('templates', $params));
$smarty->assign('StartFEUSettingsTabContent', $this->StartTab('feu_settings', $params));
$smarty->assign('active', lang('active'));
$smarty->assign('name', lang('name'));
$smarty->assign('date_mailing', $this->Lang('LastMailingDate'));
$smarty->assign('ConfirmDelete', lang('deleteconfirm'));
$smarty->assign('trueIcon', $admintheme->DisplayImage('icons/system/true.gif', $this->Lang('SetInactive'), '', '', 'systemicon'));
$smarty->assign('falseIcon', $admintheme->DisplayImage('icons/system/false.gif', $this->Lang('SetActive'), '', '', 'systemicon'));
$smarty->assign('copyIcon', $admintheme->DisplayImage('icons/system/copy.gif', lang('copy'), '', '', 'systemicon'));
$smarty->assign('editIcon', $admintheme->DisplayImage('icons/system/edit.gif', lang('edit'), '', '', 'systemicon'));
$smarty->assign('deleteIcon', $admintheme->DisplayImage('icons/system/delete.gif', lang('delete'), '', '', 'systemicon'));

#TAB: mailings
$smarty->assign('addMailingButton', $this->CreateLink($id, 'edit_mailing', $returnid, $admintheme->DisplayImage('icons/system/newobject.gif', $this->Lang('AddMailing'), '', '', 'systemicon').' '.$this->Lang('AddMailing')));

$mailingsList = $this->FetchMailings();

foreach($mailingsList as $mailing_id => &$mailing)
{
  $mailing["edit_link"] = $this->CreateLink($id, 'edit_mailing', $returnid, 'Edit', array("mailing_id" => $mailing_id), '', true);
  $mailing["copy_link"] = $this->CreateLink($id, 'edit_mailing', $returnid, 'Copy', array("act" => "copy", "mailing_id" => $mailing_id), '', true);
  $mailing["delete_link"] = $this->CreateLink($id, 'edit_mailing', $returnid, 'Delete', array("act" => "delete", "mailing_id" => $mailing_id), '', true);
  $mailing["send_mails_link"] = $this->CreateLink($id, 'users_selection', $returnid, 'Send Mails', array("mailing_id" => $mailing_id), '', true);
}

$smarty->assign('mailingsList', $mailingsList);
$smarty->assign('SendMails', $this->Lang("SendMails"));

#TAB: templates
if(!empty($params['act']) && $params['act'] == 'set_inactive' && !empty($params['template_id']))
{
  $this->SetTemplateActive(false, $params['template_id']);
  $this->Redirect($id, 'defaultadmin', $returnid, array('tab' => 'templates'));
  exit();
}

if(!empty($params['act']) && $params['act'] == 'set_active' && !empty($params['template_id']))
{
  $this->SetTemplateActive(true, $params['template_id']);
  $this->Redirect($id, 'defaultadmin', $returnid, array('tab' => 'templates'));
  exit();
}

$smarty->assign('addTemplateButton', $this->CreateLink($id, 'edit_template', $returnid, $admintheme->DisplayImage('icons/system/newobject.gif', lang('addtemplate'), '', '', 'systemicon').' '.lang('addtemplate')));

$templatesList = $this->FetchTemplates();

foreach($templatesList as $template_id => &$template)
{
  $template["edit_link"] = $this->CreateLink($id, 'edit_template', $returnid, 'Edit', array("template_id" => $template_id), '', true);
  $template["copy_link"] = $this->CreateLink($id, 'edit_template', $returnid, 'Copy', array("act" => "copy", "template_id" => $template_id), '', true);
  $template["delete_link"] = $this->CreateLink($id, 'edit_template', $returnid, 'Delete', array("act" => "delete", "template_id" => $template_id), '', true);
  $template["set_active_link"] = $this->CreateLink($id, 'defaultadmin', $returnid, 'Set active', array("act" => "set_active", "template_id" => $template_id), '', true);
  $template["set_inactive_link"] = $this->CreateLink($id, 'defaultadmin', $returnid, 'Set inactive', array("act" => "set_inactive", "template_id" => $template_id), '', true);
}

$smarty->assign('templatesList', $templatesList);

#TAB: feu_settings
if($FrontEndUsers)
{
  if(!empty($params["save"]))
  {
    $this->SaveFEUSettings($params["feu_settings"]);
  }
  
  $settings = $this->GetSettings();
  
  $feu_email_field = array();
  $feu_first_name_field = array();
  $feu_last_name_field = array();
  $props = $FrontEndUsers->GetPropertyDefns();
  
  $feu_first_name_field[$this->Lang('FEUModuleNoProperty')] = -1;
  $feu_last_name_field[$this->Lang('FEUModuleNoProperty')] = -1;
  
  $feu_email_field[$this->Lang('FEUModuleNoEmailProperty')] = "";
  $feu_first_name_field[$this->Lang('FEUModuleNoEmailProperty')] = "";
  $feu_last_name_field[$this->Lang('FEUModuleNoEmailProperty')] = "";  
  
  foreach($props as $prop)
  {
    $feu_email_field[$prop["prompt"]." [".$prop["name"]."]"] = $prop["name"];
    $feu_first_name_field[$prop["prompt"]." [".$prop["name"]."]"] = $prop["name"];
    $feu_last_name_field[$prop["prompt"]." [".$prop["name"]."]"] = $prop["name"];
  }
    
  $smarty->assign('startForm', $this->CreateFormStart($id, 'defaultadmin', $returnid, 'post', '', false, '', array('tab' => 'feu_settings')));
  $smarty->assign('endForm', $this->CreateFormEnd());
  $smarty->assign('SaveButton', $this->CreateInputSubmit($id, 'save', lang('submitdescription')));

  $smarty->assign('FEUModuleEmailFieldText', $this->Lang('FEUModuleEmailField'));
  $smarty->assign('FEUModuleEmailFieldDropdown', $this->CreateInputDropDown($id, 'feu_settings[email_field]', $feu_email_field, -1, $settings['feu_email_field']));
  $smarty->assign('FEUModuleFirstNameFieldDropdown', $this->CreateInputDropDown($id, 'feu_settings[first_name_field]', $feu_first_name_field, -1, $settings['feu_first_name_field']));
  $smarty->assign('FEUModuleLastNameFieldDropdown', $this->CreateInputDropDown($id, 'feu_settings[last_name_field]', $feu_last_name_field, -1, $settings['feu_last_name_field']));  
  $smarty->assign('FEUModuleFirstNameFieldText', $this->Lang('FEUModuleFirstNameField'));
  $smarty->assign('FEUModuleLastNameFieldText', $this->Lang('FEUModuleLastNameField'));
}

echo $smarty->fetch($this->GetFileResource("defaultadmin.tpl"));
?>
