<?php
class Newsletter extends CMSModule
{
	function GetName()
  {
    return 'Newsletter';
  }
	
	function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }
	
	function GetVersion()
  {
    return '1.1.0';
  }
	
	function GetHelp()
  {    
    return $this->Lang('help');
  }
	
	function GetAuthor()
  {
    return 'Mikhail Sazonov';
  }
	
	function GetAuthorEmail()
  {
    return 'wursta@gmail.com';
  }
	
	function GetChangeLog()
  {
    return file_get_contents(dirname(__FILE__).'/changelog.inc');
  }
	
	function IsPluginModule()
  {
    return false;
  }
	
	function HasAdmin()
  {
    return true;
  }
	
	function GetAdminSection()
  {
    return 'extensions';
  }
	
	function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }
	
	function VisibleToAdminUser()
  {    
    return $this->CheckPermission('Newsletter::ShowModule');
  }
	
	function GetDashboardOutput() 
  {        
    return '';
  }
	
	function GetNotificationOutput($priority=2) 
  {
    return '';
  }
	
	function GetDependencies()
  {
    return array('CMSMailer'=>'5.2.2');
  }
	
	function MinimumCMSVersion()
  {
    return "1.11.9";
  }
	
	function SetParameters()
  {
	
	}
	
	function GetEventDescription($eventname)
  {
    return $this->Lang('EventInfo_'.$eventname );
  }
	
	function GetEventHelp ($eventname)
  {
    return $this->Lang('EventHelp_'.$eventname );
  }
	
	function DoEvent($originator, $eventname, &$params)
  {
		
  }
	
	function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }
	
	function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }
  
  function UninstallPreMessage()
  {
    return $this->Lang('uninstallconfirm');
  }
  
  function FetchTemplates()
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $templates_list = array();        
    
    $query = "SELECT * FROM {$prfx}module_newsletter_template ORDER BY date_created";
    
    $dbresult = $db->Execute($query);
    
    if($dbresult)
    {
      while ($data = $dbresult->FetchRow())
      {
        $templates_list[$data['id']] = array('id' => $data['id'],
                                             'template_name' => $data['template_name'],
                                             'active' => $data['active']);
      }
    }
    
    return $templates_list;
  }
  
  function FetchTemplatesForDropdown()
  {
    $templates_list = $this->FetchTemplates();
    
    $items = array($this->Lang("NoTemplate") => "-1");
    $i = 1;
    foreach($templates_list as $template_id => $template_data)
    {
      $items[$i.". ".$template_data["template_name"]] = $template_id;
      $i++;
    }
    
    return $items;
  }
  
  function FetchTemplateData($templateID)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
      
    $query = "SELECT * FROM {$prfx}module_newsletter_template WHERE id = ?";
    
    $dbresult = $db->Execute($query, array($templateID));
    
    $template_data = array();
    if($dbresult)
    {
      while($data = $dbresult->FetchRow())
      {
        $template_data = array("template_name" => $data["template_name"],                               
                               "template_content" => $data["template_content"],
                               "txt_template_content" => $data["txt_template_content"]
                               );
      }
    }
    
    return $template_data;
  }
  
  function SaveTemplate($data)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
        
    $insert = empty($data["template_id"]);
    
    if(empty($data["template_name"]))
    {
      $this->ShowErrors(array($this->Lang("ErrTemplateNameEmpty")));
      return false;
    }
    
    #prepare_data
    $timestamp = $db->DBTimeStamp(time());
    
    $inputArr = array();
    
    $inputArr[] = $data["template_name"];    
    $inputArr[] = $data["template_content"];
    $inputArr[] = $data["txt_template_content"];
    
    if($insert)
      $query = "INSERT INTO {$prfx}module_newsletter_template (template_name, template_content, txt_template_content, date_created, date_modified, active) VALUES (?, ?, ?, $timestamp, $timestamp, 1)";
    else
    {
      $inputArr[] = $data["template_id"];
      $query = "UPDATE {$prfx}module_newsletter_template SET
                template_name = ?,                
                template_content = ?,
                txt_template_content = ?,
                date_modified = $timestamp
                WHERE
                id = ?";
    }
    
    $result = $db->Execute($query, $inputArr);
    
    if($insert)
      $templateID = $db->Insert_ID();
    else
      $templateID = $data["template_id"];
    
    // put mention into the admin log
    $this->Audit($templateID, $this->Lang('friendlyname'), $this->Lang('EventLogTemplateSaved'));
    
    return $templateID;
  }
  
  function SetTemplateActive($active, $templateID)
  {
    if(!is_bool($active) || empty($templateID))
      return false;
    
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    if($active)
      $query = "UPDATE {$prfx}module_newsletter_template SET active = 1 WHERE id = ?";
    else
      $query = "UPDATE {$prfx}module_newsletter_template SET active = 0 WHERE id = ?";
    
    $result = $db->Execute($query, array($templateID));
    
    return $result;
  }
  
  function DeleteNLTemplate($templateID)
  {
    if(empty($templateID))
      return false;
    
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $query = "DELETE FROM {$prfx}module_newsletter_template WHERE id = ?";
    
    $dbresult = $db->Execute($query, array($templateID));
    
    // put mention into the admin log
    $this->Audit($templateID, $this->Lang('friendlyname'), $this->Lang('EventLogTemplateRemoved'));
    
    return $dbresult;
  }
  
  function FetchMailings()
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $mailing_list = array();        
    
    $query = "SELECT * FROM {$prfx}module_newsletter_mailing ORDER BY date_created";
    
    $dbresult = $db->Execute($query);
    
    if($dbresult)
    {
      while ($data = $dbresult->FetchRow())
      {
        $mailing_list[$data['id']] = array('id' => $data['id'],
                                           'mailing_name' => $data['mailing_name'],
                                           'date_mailing' => $data['date_mailing']
                                          );
      }
    }
    
    return $mailing_list;
  }
  
  function FetchMailingData($mailingID)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
      
    $query = "SELECT * FROM {$prfx}module_newsletter_mailing WHERE id = ?";
    
    $dbresult = $db->Execute($query, array($mailingID));
    
    $mailing_data = array();
    if($dbresult)
    {
      while($data = $dbresult->FetchRow())
      {
        $mailing_data = array("mailing_name" => $data["mailing_name"],                               
                              "sender_email" => $data["sender_email"],
                              "subject" => $data["subject"],
                              "template" => $data["template_id"],
                              "content" => $data["content"],
                              "txt_content" => $data["txt_content"],
                              "date_created" => $data["date_created"],
                              "date_modified" => $data["date_modified"],
                              "date_mailing" => $data["date_mailing"]
                               );
      }
    }
    
    return $mailing_data;
  }
  
  function SaveMailing($data)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
        
    $insert = empty($data["mailing_id"]);
    
    if(empty($data["mailing_name"]))
    {
      $this->ShowErrors(array($this->Lang("ErrMailingNameEmpty")));
      return false;
    }
    
    if(empty($data["sender_email"]))
    {
      $this->ShowErrors(array($this->Lang("ErrSenderEmailEmpty")));
      return false;
    }
    
    if(empty($data["subject"]))
    {
      $this->ShowErrors(array($this->Lang("ErrSubjectEmpty")));
      return false;
    }
    
    #prepare_data
    $timestamp = $db->DBTimeStamp(time());
    
    $inputArr = array();
    
    $inputArr[] = $data["mailing_name"];    
    $inputArr[] = $data["sender_email"];    
    $inputArr[] = $data["subject"];
    if($data["template"] != -1)
      $inputArr[] = $data["template"];
    else
      $inputArr[] = null;
    $inputArr[] = $data["content"];
    $inputArr[] = $data["txt_content"];
    
    if($insert)
      $query = "INSERT INTO {$prfx}module_newsletter_mailing (mailing_name, sender_email, subject, template_id, content, txt_content,  date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, $timestamp, $timestamp)";
    else
    {
      $inputArr[] = $data["mailing_id"];
      $query = "UPDATE {$prfx}module_newsletter_mailing SET
                mailing_name = ?,
                sender_email = ?,
                subject = ?,
                template_id = ?,
                content = ?,
                txt_content = ?,
                date_modified = $timestamp
                WHERE
                id = ?";
    }
    
    $result = $db->Execute($query, $inputArr);
    
    if($insert)
      $mailingID = $db->Insert_ID();
    else
      $mailingID = $data["mailing_id"];
    
    // put mention into the admin log
    $this->Audit($mailingID, $this->Lang('friendlyname'), $this->Lang('EventLogMailingSaved'));
    
    return $mailingID;
  }
  
  function DeleteMailing($mailingID)
  {
    if(empty($mailingID))
      return false;
    
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $query = "DELETE FROM {$prfx}module_newsletter_mailing WHERE id = ?";
    
    $dbresult = $db->Execute($query, array($mailingID));
    
    // put mention into the admin log
    $this->Audit($mailingID, $this->Lang('friendlyname'), $this->Lang('EventLogMailingRemoved'));
    
    return $dbresult;
  }
  
  function GetMailingData($mailingID)
  {
    $mailing_data = $this->FetchMailingData($mailingID);
    
    $tempalate_data = array();
    if(!empty($mailing_data["template"]))
      $tempalate_data = $this->FetchTemplateData($mailing_data["template"]);
    
    $mail_data = array();
    
    $mail_data["sender_email"] = $mailing_data["sender_email"];
    $mail_data["subject"] = $mailing_data["subject"];
    
    $mail_content = $mailing_data['content'];
    $txt_mail_content = $mailing_data['txt_content'];
    
    if(empty($tempalate_data))
    {
      $mail_body = $mail_content;
      $alt_mail_body = $txt_mail_content;
    }
    else
    {
      $template = $tempalate_data['template_content'];
      $txt_template = $tempalate_data['txt_template_content'];
      
      $mail_body = str_ireplace("{Content}", $mail_content, $template);
      $alt_mail_body = str_ireplace("{Content}", $txt_mail_content, $txt_template);
    }
    
    $mail_body = $this->ProcessImages($mail_body);
    
    $mail_data["mail_body"] = $mail_body;
    $mail_data["alt_mail_body"] = $alt_mail_body;
    
    return $mail_data;
  }
  
  function ProcessPlaceholders($mail_html, $User, $FEU = false)
  {
    if(!$FEU)
    {
      $Username = '';
      if(!empty($User->firstname))
        $Username .= $User->firstname.' ';
      if(!empty($User->lastname))
        $Username .= $User->lastname;
      
      if(empty($Username))
        $Username = $User->username;            
    }
    else
    {
      $Username = $this->GetFEUUsername($User);
    }        
    
    $mail_html = str_ireplace("{Username}", $Username, $mail_html);
    
    return $mail_html;
  }    
  
  function ProcessImages($mail_html)
  {    
    $cms_config = $this->GetConfig();
    $root_url = $cms_config->offsetGet('root_url');
    
    $matches = array();    
    preg_match_all('/src=["\']([^"\':]+)["\']/i', $mail_html, $matches);
    
    foreach($matches[1] as $src)
    {
      $base = $root_url.'/';
      $abs_src = 'src="'.$base.$src.'"';
      $mail_html = preg_replace('/src=["\']([^"\':]+)["\']/i', $abs_src, $mail_html);
    }
        
    return $mail_html;
  }
  
  function SaveFEUSettings($feu_settings)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $updateArr = array();
    foreach($feu_settings as $name => $value)
    {
      $updateArr[] = array($value, 'feu_'.$name);
    }
    
    $query = "UPDATE {$prfx}module_newsletter_settings SET
              value = ?
              WHERE setting_name = ?";
    
    $dbresult = $db->Execute($query, $updateArr);        
    
    // put mention into the admin log
    $this->Audit(0, $this->Lang('friendlyname'), $this->Lang('EventLogFEUSettingsSaved'));
    
    return $dbresult;    
  }
  
  function GetSettings()
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $query = "SELECT * FROM {$prfx}module_newsletter_settings";
    
    $dbresult = $db->Execute($query);
        
    if(!$dbresult)
      return false;
    
    $settings = array();
    while($data = $dbresult->FetchRow())
    {
      $settings[$data['setting_name']] = $data['value'];
    }
    
    return $settings;
  }
  
  function UpdateMailingSenddate($mailingID)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $timestamp = $db->DBTimeStamp(time());
    $updateArr = array($mailingID);
    
    $query = "UPDATE {$prfx}module_newsletter_mailing SET date_mailing = $timestamp WHERE id = ?";     
    
    $dbresult = $db->Execute($query, $updateArr);
    
    return $dbresult;
  }
  
  function GetFEUUsername($User)
  {
    $FrontEndUsers = $this->GetModuleInstance('FrontEndUsers');
    
    if(!$FrontEndUsers)
      return null;
    
    $settings = $this->GetSettings();
    
    $Username = '';
    
    if($settings['feu_first_name_field'] != -1)
    {
      if($settings['feu_first_name_field'] == '')
        $Username .= $User['username'].' ';
      else
      {
        $first_name = $FrontEndUsers->GetUserPropertyFull($settings['feu_first_name_field'], $User["id"]);
        $Username .= $first_name.' ';
      }
    }
    
    if($settings['feu_last_name_field'] != -1)
    {
      if($settings['feu_last_name_field'] == '')
        $Username .= $User['username'].' ';
      else
      {
        $last_name = $FrontEndUsers->GetUserPropertyFull($settings['feu_last_name_field'], $User["id"]);
        $Username .= $last_name;
      }
    }
    
    return $Username;
  }
  
  function GetFEUEmail($User)
  {
    $FrontEndUsers = $this->GetModuleInstance('FrontEndUsers');
    
    if(!$FrontEndUsers)
      return null;
    
    $settings = $this->GetSettings();
    
    $Email = '';
        
    if(empty($settings['feu_email_field']) == '')
      $Email = $User['username'];
    else
      $Email = $FrontEndUsers->GetUserPropertyFull($settings['feu_email_field'], $User["id"]);
    
    return $Email;
  }
}

?>