<?php
/**
* $Id$
*
* Copyright (c) 2013, Clip Magic.  All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
* - Redistributions of source code must retain the above copyright notice,
*   this list of conditions and the following disclaimer.
* - Redistributions in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in the
*   documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
*
*/

/**
* ListIt2XLinks lib xlink PHP class
*
*/
class xlink
{


    /**
    * Constructor - if you're not using the class statically
    *
    * @return void
    */
    public function __construct()
    {
    }
    
    public static function render_for_fe ($params) {
        return self::_render_for_fe($params);
    }
    
    public static function fdef_admin_list_remote_fields ($mod) {
        return self::_fdef_admin_list_remote_fields($mod);
    }
    
    #---------------------
    # Manipulation methods
    #---------------------

    private function _render_for_fe($params) {

         // Front end display
         // Retrieve data from remote LI2 module
         
         
         // Set things up
         $retval = '';
         $db = cmsms()->GetDb();
         $field_id = $params['fielddef_id'];
         $item_id = $params['item_id'];
         $modname = $params['mod'];
         
         $mod = cms_utils::get_module($modname); 

         $obj = $mod->LoadItemByIdentifier('item_id', $item_id);
         
                 
        // Get the field alias
        $query = "SELECT `alias` FROM " . cms_db_prefix() . "module_" . $modname . "_fielddef WHERE fielddef_id = ?";
        $fld_alias = $db->GetOne($query, array($field_id));
        
        
        // Load the remote module
         $remote_mod_id    = $obj->fielddefs[$fld_alias]->GetOptionValue('limod_options');
         
         
         $query = "SELECT `module_name` FROM " . cms_db_prefix() . "module_listit2_instances WHERE `module_id` = ?";
         $remote_mod_name = $db->GetOne($query, array($remote_mod_id));

         $remote_mod = cms_utils::get_module($remote_mod_name);
         $available = cms_utils::module_available($remote_mod_name);

         $datasrc  = $obj->fielddefs[$fld_alias]->GetOptionValue('datasrc_options');
         


        // Return the data 
        if (is_object($remote_mod) && $available) {                 
             switch ($datasrc) {
                case 0:   // title
                    $remote_item_id =  $obj->fielddefs[$fld_alias]->GetValue();
                    
                    if (!$remote_item = $remote_mod->LoadItemByIdentifier('item_id', $remote_item_id)){
                        $retval = $this->ModLang('remote_item_unavailable');                    
                    } else {
                        $retval = $remote_item->title;
                    }
                break;
             
             case 1:  // alias
                    $remote_item_id =  $obj->fielddefs[$fld_alias]->GetValue();
                    if (!$remote_item = $remote_mod->LoadItemByIdentifier('item_id', $remote_item_id)){
                        $retval = $this->ModLang('remote_item_unavailable');                    
                    } else {
                        $retval = $remote_item->alias;
                    }
                break;
             
             case 2:  // custom field
                $ids = explode('::', $obj->fielddefs[$fld_alias]->GetValue());
                
                
                // Get the remote item
                if (!$remote_item = $remote_mod->LoadItemByIdentifier('item_id', $ids[0])) {
                    $retval = $this->ModLang('remote_item_unavailable');
                } else {
                    // Get the field alias
                    $query = "SELECT `alias` FROM " . cms_db_prefix() . "module_" . $remote_mod_name . "_fielddef WHERE fielddef_id = ?";
                    if (!$remote_fld_alias = $db->GetOne($query, array($ids[1]))){
                        $retval = $this->ModLang('remote_field_unavailable');                                       
                    } else {                
                        $retval = $remote_item->fielddefs[$remote_fld_alias]->GetValue();  
                    }
                }
                break;
    
             default:
                break;
             }
         
         }

         return $retval;         
    }
    
    private function _fdef_admin_list_remote_fields ($mod) {
    
    }
    
	public function test_function() {
		return 'this is a string in the test_function';
	}

}