<?php
#-------------------------------------------------------------------------
#
# Clip Magic, <admin@clipmagic.com.su>
# Web: www.clipmagic.com.au
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class ListIt2XLink extends CMSModule {


	public function GetName()
	{
		return 'ListIt2XLink';
	}

    public function GetFriendlyName() {
        return $this->Lang('module_friendlyname');
    }

    public function GetAdminDescription() {
        return $this->Lang('module_description');
    }

    public function GetVersion() {
        return '1.0';
    }

    public function MinimumCMSVersion() {
        return '1.11';
    }

    function GetHelp() {
        return @file_get_contents(dirname(__FILE__) . '/help.html');
    }

    public function GetAuthor() {
        return 'Clip Magic';
    }

    public function GetAuthorEmail() {
        return 'admin@clipmagic.com.au';
    }

    public function GetChangeLog() {
        return @file_get_contents(dirname(__FILE__) . '/changelog.html');
    }

    public function InitializeFrontend() {
        $this->RegisterModulePlugin();
        $this->RestrictUnknownParams();
        

        $this->SetParameterType('fielddef_id', CLEAN_INT);
        $this->SetParameterType('item_id', CLEAN_INT);
        $this->SetParameterType('mod', CLEAN_STRING);
	}
	
		public function InitializeAdmin()
	{
        $this->CreateParameter('fielddef_id','$fielddef->GetId()',$this->Lang('help_param_fielddef_id'),false);
        $this->CreateParameter('mod','$mod->GetName()',$this->Lang('help_param_mod'),false);
        $this->CreateParameter('item_id','$item->item_id',$this->Lang('help_param_item_id'));


    }

    public function IsAdminOnly() {
        return false;
    }

    public function HasAdmin() {
        return true;
    }

    function IsPluginModule() {
        return true;
    }
    	

} //end of class
?>