<?php
#CMS - CMS Made Simple
#(c)2004 by Ted Kulp (wishy@users.sf.net)
#This project's homepage is: http://www.cmsmadesimple.org
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#$Id: GCharts.module.php 2114 2005-11-04 21:51:13Z wishy $

final class gcharts_ops
{
  protected function __construct() {}

  private static $_categories_loaded;
  private static $_cached_categories;

  public static function get_categories($id,$params,$returnid=-1)
  {
    $tmp = self::get_all_categories();
    if( !count($tmp) ) return;

    $catinfo = array();
    if( !isset($params['category']) || $params['category'] == '' ) {
      $catinfo = $tmp;
    }
    else {
      $categories = explode(',', $params['category']);
      foreach( $categories as $onecat ) {
	if( strpos($onecat,'*') !== FALSE ) {
	  foreach( $tmp as $rec ) {
 	    if( fnmatch($onecat,$rec['gcharts_category_name']) ) {
	      $catinfo[] = $rec;
	    }
	  }
	}
	else {
	  foreach( $tmp as $rec ) {
	    if( $rec['gcharts_category_name'] == $onecat ) {
	      $catinfo[] = $rec;
	    }
	  }
	}
      }
    }
    unset($tmp);
    if( !count($catinfo) ) return;

    $cat_ids = array();
    for( $i = 0; $i < count($catinfo); $i++ ) {
      $cat_ids[] = $catinfo[$i]['gcharts_category_id'];
    }
    sort($cat_ids);
    $cat_ids = array_unique($cat_ids);

    // get counts.
    $depth = 1;
    $db = cmsms()->GetDb();
    $counts = array();

    {
      $q2 = 'SELECT gcharts_category_id,COUNT(gcharts_id) AS cnt FROM '.cms_db_prefix().'module_gcharts WHERE gcharts_category_id IN (';
      $q2 .= implode(',',$cat_ids).')';
      $q2 .= ' AND status = \'published\' GROUP BY gcharts_category_id';
      $tmp = $db->GetArray($q2);
      if( count($tmp) ) {
	for( $i = 0; $i < count($tmp); $i++ ) {
	  $counts[$tmp[$i]['gcharts_category_id']] = $tmp[$i]['cnt'];
	}
      }
    }

    $rowcounter=0;
    $items = array();
    $depth = 1;
    for( $i = 0; $i < count($catinfo); $i++ ) {
      $row =& $catinfo[$i];
      $row['index'] = $rowcounter++;
      $row['count'] = (isset($counts[$row['gcharts_category_id']]))?$counts[$row['gcharts_category_id']]:0;
      $row['prevdepth'] = $depth;
      $depth = count(explode('.', $row['hierarchy']));
      $row['depth']=$depth;

      // changes so that parameters supplied to the tag
      // gets carried down through the links
      // screw pretty urls
      $parms = $params;
      unset($parms['browsecat']);
      unset($parms['category']);
      $parms['category_id'] = $row['gcharts_category_id'];

      $pageid = (isset($params['detailpage']) && $params['detailpage']!='')?$params['detailpage']:$returnid;
      $mod = cms_utils::get_module('GCharts');
      $row['url'] = $mod->CreateLink($id,'default',$pageid,$row['gcharts_category_name'],$parms,'',true);
      $items[] = $row;
    }
    return $items;
  }


  public static function get_all_categories()
  {
    if( !self::$_categories_loaded ) {
      $db = cmsms()->GetDb();
      $query = "SELECT * FROM ".cms_db_prefix()."module_gcharts_categories ORDER BY hierarchy";
      $dbresult = $db->GetArray($query);
      if( $dbresult ) self::$_cached_categories = $dbresult;
      self::$_categories_loaded = TRUE;
    }
    return self::$_cached_categories;
  }


  public static function get_category_list()
  {
    self::get_all_categories();
    $categorylist = array();
    for( $i = 0; $i < count(self::$_cached_categories); $i++ ) {
      $row = self::$_cached_categories[$i];
      $categorylist[$row['gcharts_category_name']] = $row['gcharts_category_id'];
    }

    return $categorylist;
  }


  public static function get_category_names_by_id()
  {
    self::get_all_categories();
    $list = array();
    for( $i = 0; $i < count(self::$_cached_categories); $i++ ) {
      $list[self::$_cached_categories[$i]['gcharts_category_id']] = self::$_cached_categories[$i]['gcharts_category_name'];
    }
    return $list;
  }

  
  public static function get_category_name_from_id($id)
  {
    self::get_all_categories();
    for( $i = 0; $i < count(self::$_cached_categories); $i++ ) {
      if( $id == self::$_cached_categories[$i]['gcharts_category_id'] ) {
	return self::$_cached_categories[$i]['gcharts_category_name'];
      }
    }
  }


  public static function fill_chart_from_formparams(gcharts_chart &$gcharts,$params,$handle_uploads = FALSE,$handle_deletes = FALSE)
  {
    foreach( $params as $key => $value ) {
      switch( $key ) {
      case 'chartid':
	$gcharts->id = $value;
	break;

      case 'name':
      case 'data':
      case 'status':
	$gcharts->$key = $value;
	break;

      case 'category':
	$list = self::get_category_names_by_id();
	for( $i = 0; $i < count(self::$_cached_categories); $i++ ) {
	  if( $value == self::$_cached_categories[$i]['gcharts_category_name'] )
	    $gcharts->category_id = self::$_cached_categories[$i]['gcharts_category_id'];
	}
	break;
    }
	}

    return $gcharts;
  }


  static private function &get_chart_from_row($row)
  {
    if( !is_array($row) ) return;
    $chart = new gcharts_chart;
    foreach( $row as $key => $value ) {
      switch( $key ) {
      case 'gcharts_id':
	$chart->id = $value;
	break;

      case 'gcharts_category_id':
	$chart->category_id = $value;
	break;

      case 'gcharts_name':
	$chart->name = $value;
	break;

      case 'gcharts_data':
	$chart->data = $value;
	break;

      case 'status':
	$chart->status = $value;
	break;
      }
    }

    return $chart;
  }

  static public function &get_latest_chart($for_display = TRUE)
  {
    $db = cmsms()->GetDb();
    $now = $db->DbTimeStamp(time());
    $query = "SELECT mn.*, mnc.gcharts_category_name FROM ".cms_db_prefix()."module_gcharts mn LEFT OUTER JOIN ".cms_db_prefix()."module_gcharts_categories mnc ON mnc.gcharts_category_id = mn.gcharts_category_id WHERE status = 'published' AND ";
    $query .= 'ORDER BY gcharts_id DESC LIMIT 1';
    $row = $db->GetRow($query);

    return self::get_chart_from_row($row,($for_display)?'PUBLIC':'ALL');    
  }


  static public function &get_chart_by_id($chart_id,$for_display = TRUE,$allow_expired = FALSE)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT mn.*, mnc.gcharts_category_name FROM '.cms_db_prefix().'module_gcharts mn 
              LEFT OUTER JOIN '.cms_db_prefix().'module_gcharts_categories mnc ON mnc.gcharts_category_id = mn.gcharts_category_id 
              WHERE status = \'published\' AND gcharts_id = ?';
    $row = $db->GetRow($query, array($chart_id));

    $res = null;
    if( !$row ) return $res;
    
    return self::get_chart_from_row($row,($for_display)?'PUBLIC':'ALL');    
  }
} // end of class

#
# EOF
#
?>