<script type="text/javascript">
$(document).ready(function(){
  $(document).on('click','#categories img.delete',function(){
    if( !confirm('{$mod->Lang('cal_areyousure')}') ) return false;
    $(this).closest('tr').remove();
  });
  $('#categories > tbody').sortable({ cursor: 'move' });
  $(document).on('click','#cal_newcat',function(){
    var row = $('tr#skeleton').clone();
    $(row).show().removeAttr('id').appendTo('#categories > tbody');
    return false;
  });
  $(document).on('click','#cat_submit',function(){
    var error = null;
    var count = 0;    
    $('#categories > tbody tr').each(function(idx){
      if( $(this).attr('id') == 'skeleton' ) return;
      if( typeof error != 'string' ) {
        var id = $('input.cat_id',this).val();
        var name = $('input.cat_name',this).val();
        if( name == '' ) {
      	  if( id > 0 ) {
  	    error = '{$mod->Lang('error_categorynamerow')}'+' '+idx;
  	    return;
          }
        } else {
          count++;
        }
      }
    });
    if( error ) {
      alert(error); return false;
    }
    if( count == 0 ) {
      return confirm('{$mod->Lang('confirm_nocategories')}');
    }
    return true;
  });
});
</script>

<div class="information">{$mod->Lang('info_reorder_categories')}</div>
{$formstart}
<table class="pagetable" id="categories">
  <thead>
    <tr>
      <th>{$mod->Lang('name')}</th>
      <th class="pageicon">{$mod->Lang('delete')}</th>
    </tr>
  </thead>
  <tbody>
  {foreach $categories as $cat}
    <tr>
      <td>
        <input class="cat_id" type="hidden" name="{$actionid}category_ids[]" value="{$cat.category_id}"/>
        <input class="cat_name" type="text" name="{$actionid}category_names[]" value="{$cat.category_name}" maxlength="255"/>
      </td>
      <td>{if $cat.category_id != -1}{cgimage image='icons/system/delete.gif' class="delete" alt=$mod->Lang('delete')}{/if}</td>
    </tr>
  {/foreach}
    <tr id="skeleton" style="display: none;">
      <td>
        <input class="cat_id" type="hidden" name="{$actionid}category_ids[]" value="-1"/>
        <input class="cat_name" type="text" name="{$actionid}category_names[]" value="" maxlength="255"/>
      </td>
      <td>{cgimage image='icons/system/delete.gif' class="delete" alt=$mod->Lang('delete')}</td>
    </tr>
  </tbody>
</table>
<div class="pageoverflow">
  <p class="pagetext"></p>
  <p class="pageinput">
    <input id="cal_newcat" type="submit" value="{$mod->Lang('add_category')}"/>
    <input id="cat_submit" type="submit" name="{$actionid}submit" value="{$mod->Lang('cal_update_categories')}"/>
  </p>
</div>
{$formend}