<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Skeleton (c) 2008 
#      by Robert Allen (akrabat) and
#         Robert Campbell (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow displaying calendars,
#  and management and display of time based events.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission("Modify Calendar") ) return;

$error="";
$message="";
$this->SetCurrentTab('admin_manage_categories');

$ids = $params['category_ids'];
$names = $params['category_names'];
$num_records = count($ids);

// build records
$cats = $this->GetCategories();
$newrecs = array();
for($i = 0; $i < $num_records; $i++)
{
  // don't trust user input, but do $name later as quote() will add '' to it.
  $category_id = (int)$ids[$i];
  $category_name = trim($names[$i]);
  if( $category_id == -1 && $category_name == '' ) continue; // trivial exclusion
  if( $category_id > 0 && $category_name == '' ) {
    // error... empty category name, valid category id.
    $this->SetError($this->Lang('error_categorynamerow')+' '+$i);
    $this->RedirectToTab($id);
  }
  $rec = array('category_id'=>$category_id,'category_name'=>$category_name,'category_order'=>count($newrecs));
  $newrecs[] = $rec;
}

// double check for duplicate names
$tmp_names = array();
for( $i = 0; $i < count($newrecs); $i++ ) {
  if( in_array($newrecs[$i]['category_name'],$tmp_names) ) {
    $this->SetError($this->Lang('error_categorynameexists',$newrecs[$i]['category_name']));
    $this->RedirectToTab($id);
  }
  $tmp_names[] = $newrecs[$i]['category_name'];
}

// cross reference into added, updated, and deleted arrays
$added = array();
$updated = array();
$deleted = array();
$curcat_ids = cge_array::extract_field($cats,'category_id');
$curcat_names = cge_array::extract_field($cats,'category_name');
$newcat_ids = cge_array::extract_field($newrecs,'category_id');
$newcat_names = cge_array::extract_field($newrecs,'category_name');
foreach( $newrecs as $rec ) {
  // find the item in cats
  $fnd = null;
  foreach( $cats as $tmp ) {
    if( $tmp['category_id'] == $rec['category_id'] ) {
      $fnd = $tmp;
      break;
    }
  }
  if( $fnd ) {
    // found the matching id... check if name or order changed.
    if( $fnd['category_name'] != $rec['category_name'] || $fnd['category_order'] != $rec['category_order'] ) $updated[] = $rec;
  }
  else {
    // new record
    $added[] = $rec;
  }
}
foreach( $cats as $rec ) {
  if( !in_array($rec['category_id'],$newcat_ids) ) $deleted[] = $rec;
}

// do deletions
foreach( $deleted as $todelete ) {
  $category_id = $todelete['category_id'];
  if( $category_id < 1 ) continue;

  $sql = 'DELETE FROM '.$this->events_to_categories_table_name.' WHERE category_id = ?';
  $db->Execute($sql,array($category_id));
  $sql = 'DELETE FROM '.$this->categories_table_name.' WHERE category_id = ?';
  $db->Execute($sql,array($category_id));
  $this->SendEvent('CategoryDeleted',array('category_id'=>$category_id));
}
// do additions
foreach( $added as $toadd ) {
  $category_id = $db->GenID($this->categories_table_name.'_seq');
  $category_name = $toadd['category_name'];
  $category_order = $toadd['category_order'];
  $toadd['category_id'] = $category_id;

  $sql = 'INSERT INTO '.$this->categories_table_name." (category_id, category_name, category_order) VALUES (?,?,?)";
  $db->Execute($sql,array($category_id,$category_name,$category_order));
  $this->SendEvent('CategoryAdded',$toadd);
}
// do updates
foreach( $updated as $toupdate ) {
  $category_id = $toupdate['category_id'];
  $category_name = $toupdate['category_name'];
  $category_order = $toupdate['category_order'];

  $sql = 'UPDATE '.$this->categories_table_name . " SET category_name = ?, category_order = ? WHERE category_id = ?";
  $db->Execute($sql,array($category_name,$category_order,$category_id));
  $this->SendEvent('CategoryEdited',$toupdate);
}

$this->SetMessage($this->Lang('msg_categories_updated'));
$this->RedirectToTab($id);
?>
