<?php
# BirthdayListing (Who is celebrating today his/her birthday?). A module for CMS - CMS Made Simple
# This module has specially written for the first Dutch Workshop on CMSMS held Januari 24th 2009
# Copyright (c) 2009-2011 by Duketown 
#
# This function will add a birthday
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/birthdaylisting
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Prepare the various sorting methods
$orderbackendlist = array();
$orderbackendlist = $this->GetListOrderBackend();

// Prepare list of possible date formats
$dateformatlist = array();
$dateformatlist = $this->GetDateformats();

// Prepare the list of page limits
$pagelimitlist = array();
$pagelimitlist = $this->GetListPageLimit();

$smarty->assign('startform', $this->CreateFormStart($id, 'save_admin_options', $returnid));
$smarty->assign('endform', $this->CreateFormEnd());
$smarty->assign('title_nobirthdaystext',$this->Lang('title_nobirthdaystext'));
$smarty->assign('input_nobirthdaystext', $this->CreateInputText($id, 'nobirthdaystext', 
	$this->GetPreference('nobirthdaystext', $this->Lang('nobirthdays')), '50', '255'));
$smarty->assign('title_orderbackend',$this->Lang('title_orderbackend'));
$smarty->assign('input_orderbackend', $this->CreateInputDropdown($id, 'orderbackend', $orderbackendlist, -1,
	$this->GetPreference('orderbackend', 'name')));
$smarty->assign('title_dateformat',$this->Lang('title_dateformat'));
$smarty->assign('input_dateformat', $this->CreateInputDropdown($id, 'dateformat',$dateformatlist, -1, 
	$this->GetPreference('dateformat', 'd-m-yy')));
$smarty->assign('title_splitdateused',$this->Lang('title_splitdateused'));
$smarty->assign('input_splitdateused', $this->CreateInputCheckbox($id, 'splitdateused', true, 
	$this->GetPreference('splitdateused', true)));
$smarty->assign('title_pagelimit',$this->Lang('title_pagelimit'));
$smarty->assign('input_pagelimit', $this->CreateInputDropdown($id, 'pagelimit', $pagelimitlist, -1, 
	get_preference(get_userid(),'pagelimit')));

$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
$smarty->assign('createsamples', $this->CreateLink ($id, 'samplehandler', $returnid, 
	$this->Lang('createsamples'), array ('sample'=>'create'), '', false, false, ''));
$smarty->assign('deletesamples', $this->CreateLink ($id, 'samplehandler', $returnid, 
	$this->Lang('deletesamples'), array ('sample'=>'delete'), '', false, false, ''));

// Display the options
echo $this->ProcessTemplate('listoptions.tpl');

?>
