<?php
# BirthdayListing (Who is celebrating today his/her birthday?). A module for CMS - CMS Made Simple
# This module has specially written for the first Dutch Workshop on CMSMS held Januari 24th 2009
# Copyright (c) 2009-2011 by Duketown 
#
# This function will list the birthdays
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/birthdaylisting
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$user_id = '';
if (get_userid() ) {
	$user_id = get_userid();
}
if (isset($user_id) ) {
	$pagelimit = get_preference($user_id, 'pagelimit');
}
// Setup pagination
if (!isset($pagelimit) || $pagelimit == 0) {
	$pagelimit = $this->GetPreference('pagelimit',20);
}
$pagenumber = 1;
if( isset( $params['pagenumber'] ) ) {
	$pagenumber = $params['pagenumber'];
}
$startelement = ($pagenumber-1) * $pagelimit;

$rowentry = array ();
$query = '';
$dbresult = '';

$query1 = 'SELECT * FROM '.cms_db_prefix ().'module_birthdaylisting_birthdays';
$query2 = 'SELECT COUNT(*) AS count FROM '.cms_db_prefix ().'module_birthdaylisting_birthdays';
switch ($this->GetPreference('orderbackend', 'name')) {
	case 'name':
		$query1 .=	' ORDER BY name';
		break;
	case 'monthday':
		$query1 .= ' ORDER BY month(birthday),day(birthday), name';
		break;
}
// Make sure pagination works
$numrows = -1;
if( count($parms) ) {
	$dbresult = $db->SelectLimit( $query1, $pagelimit, $startelement, $parms);
	$row = $db->GetRow($query2,$parms);
	$numrows = $row['count'];
}
else {
	$dbresult = $db->SelectLimit( $query1, $pagelimit, $startelement);
	$row = $db->GetRow($query2);
	
	$numrows = $row['count'];
}
// Let's get the total available birthdays
$query3 = 'SELECT COUNT(*) AS count FROM '.cms_db_prefix ().'module_birthdaylisting_birthdays';
$sqlresult = $db->GetRow($query3);
$smarty->assign('totalcount', $sqlresult['count']);

$pagecount = (int)($numrows/$pagelimit);

if( ($numrows % $pagelimit) != 0 ) $pagecount++;
// Some pagination variables to smarty.
if( $pagenumber == 1 ) {
	$this->smarty->assign('prevpage',$this->Lang('prevpage'));
	$this->smarty->assign('firstpage',$this->Lang('firstpage'));
}
else {
	$this->smarty->assign('prevpage',
			$this->CreateLink($id,'defaultadmin',
					  $returnid,$this->Lang('prevpage'),
					  array('pagenumber'=>$pagenumber-1,
						'active_tab'=>'birthdays')));
	$this->smarty->assign('firstpage',
			$this->CreateLink($id,'defaultadmin',
					  $returnid,$this->Lang('firstpage'),
					  array('pagenumber'=>1,
						'active_tab'=>'birthdays')));
}
if( $pagenumber >= $pagecount ) {
	$this->smarty->assign('nextpage',$this->Lang('nextpage'));
	$this->smarty->assign('lastpage',$this->Lang('lastpage'));
}
else {
	$this->smarty->assign('nextpage',
			$this->CreateLink($id,'defaultadmin',
					  $returnid,$this->Lang('nextpage'),
					  array('pagenumber'=>$pagenumber+1,
						'active_tab'=>'birthdays')));
	$this->smarty->assign('lastpage',
			$this->CreateLink($id,'defaultadmin',
					  $returnid,$this->Lang('lastpage'),
					  array('pagenumber'=>$pagecount,
						'active_tab'=>'birthdays')));
}
$this->smarty->assign('pagenumber',$pagenumber);
$this->smarty->assign('pagecount',$pagecount);
$this->smarty->assign('pagename',$this->Lang('pagename'));
$this->smarty->assign('oftext',$this->Lang('prompt_of'));

$rowclass = 'row1';
	
while ($row = $dbresult->FetchRow ())
{
	$onerow = new stdClass ();
	$onerow->id = $row['verj_id'];
	$onerow->name = $this->CreateLink( $id, 'editbirthday', $returnid, $row['name'], array('birthday_id'=>$row['birthday_id']));
	$onerow->date = $row['birthday'];
	$onerow->age = $this->CalculateNumYears($row['birthday'], $row['deceased']);
	if ($row['deceased'] > 0) {
		$onerow->deceased = $row['deceased'];
	}
	else {
		$onerow->deceased ='';
	}

	$onerow->editlink = $this->CreateLink ($id, 'editbirthday', $returnid, $gCms->variables['admintheme']->DisplayImage ('icons/system/edit.gif', $this->Lang ('edit'), '', '', 'systemicon'), array('birthday_id' => $row['birthday_id']));
	$onerow->deletelink = $this->CreateLink ($id, 'deletebirthday', $returnid, $gCms->variables['admintheme']->DisplayImage ('icons/system/delete.gif', $this->Lang ('delete'), '', '', 'systemicon'), array('birthday_id' => $row['birthday_id']), $this->Lang ('areyousure'));

	$onerow->rowclass = $rowclass;

	array_push ($rowentry, $onerow);
	($rowclass == "row1" ? $rowclass = "row2" : $rowclass = "row1");
}

$smarty->assign('startform' ,$this->CreateFormStart($id,'defaultadmin'));
$smarty->assign('endform',$this->CreateFormEnd());

$smarty->assign('title_birthdaysfound', $this->Lang('title_birthdaysfound'));
$smarty->assign('datetext', $this->Lang('birthdates'));
$smarty->assign('nametext', $this->Lang('names'));
$smarty->assign('agetext', $this->Lang('age'));
$smarty->assign('diedtext', $this->Lang('deceaseddates'));
$smarty->assign('items', $rowentry);
$smarty->assign('itemcount', count ($rowentry));
if ( get_preference( $user_id, 'date_format_string') != '') {
	$user_date_format_string = get_preference( $user_id, 'date_format_string');
}
else {
	$user_date_format_string = '%d %B %Y';
}
$smarty->assign('date_format_string', $user_date_format_string);

$smarty->assign('addlink', $this->CreateLink ($id, 'addbirthday', $returnid, $this->Lang('addbirthday'), array (), '', false, false));

// Display the birthdays
echo $this->ProcessTemplate('listbirthdays.tpl');

?>
