<?php
# BirthdayListing (Who is celebrating today his/her birthday?). A module for CMS - CMS Made Simple
# This module has specially written for the first Dutch Workshop on CMSMS held Januari 24th 2009
# Copyright (c) 2009-2011 by Duketown 
#
# This function will create/delete sample data for the module Birthday Listing
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/birthdaylisting
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Allow only creation and deletion of sample data
if ($params['sample'] != 'create' && $params['sample'] != 'delete'){
  $params = array('tab_message'=> 'samplehandlingstopped', 'active_tab' => 'options');
  $this->Redirect($id, 'defaultadmin', $returnid, $params);                       
}

if ($params['sample'] == 'create'){
	// Save the currently used sequence id, so the sample range can be deleted
  $query = 'SELECT * FROM '.cms_db_prefix().'module_birthdaylisting_birthdays_seq';
  $row = $db->GetRow($query);
  $this->SetPreference('sampleloadbefore', $row['id']);
  
  $query = 'INSERT INTO '.cms_db_prefix().'module_birthdaylisting_birthdays (birthday_id, name, birthday, deceased) VALUES (?,?,?,?)';
  
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, ' The author is not responsible for the correctness of dates', '1900-01-01 00:00:00', '2020-12-31 00:00:00'));
  
  // http://thecelebritycafe.com/birthdays has been used as source
  // January Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Famke Janssen', '1964-01-01 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Tommy Morrison', '1969-01-02 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'George Martin', '1926-01-03 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Patty Loveless', '1964-01-04 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Marilyn Manson', '1969-01-05 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'George Ledyard Stebbins', '1906-01-06 00:00:00', '2000-01-19 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Nicolas Cage', '1964-01-07 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Shirley Bassey', '1937-01-08 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Haddaway', '1965-01-09 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Pat Benatar', '1953-01-10 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Butterfly McQueen', '1911-01-11 00:00:00', '1995-12-22 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Vendela Kirsebom', '1967-01-12 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Brandon Tartikoff', '1949-01-13 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Masahiro Muramatsu', '1972-01-14 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Gil Hova', '1974-01-15 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Aaliyah', '1979-01-16 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Jim Carrey', '1962-01-17 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Oliver Hardy', '1892-01-18 00:00:00', '1957-08-07 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Janis Joplin', '1943-01-19 00:00:00', '1970-10-04 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Paul Stanley', '1952-01-20 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Telly Savalas', '1924-01-21 00:00:00', '1994-01-22 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'George Byron', '1788-01-22 00:00:00', '1824-04-19 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Joe Kelly', '1988-01-23 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Warren Zevon', '1947-01-24 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Terrence Hill', '1965-01-25 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Eddie Van Halen', '1955-01-26 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Charlotte J. Helmkamp', '1961-01-27 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Nicholas Pryor', '1935-01-28 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Andrew Keegan', '1979-01-29 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Wilmer Valderrama', '1980-01-30 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Anthony LaPaglia', '1959-01-31 00:00:00', '0000-00-00 00:00:00'));

  // February Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Heinosuke Gosho', '1902-02-01 00:00:00', '1981-05-01 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Howard Bellamy', '1946-02-02 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Thomas Calabro', '1960-02-03 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Alice Cooper', '1948-02-04 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Michael Sheen', '1969-02-05 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'April Lerman', '1969-02-06 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'George Oppenheimer', '1900-02-07 00:00:00', '1977-08-14 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Satsuki Igarashi', '1969-02-08 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Mia Farrow', '1945-02-09 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'George Stephanopolous', '1961-02-10 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Kelly Slater', '1972-02-11 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Abraham Lincoln', '1809-02-12 00:00:00', '1865-04-15 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Robbie Williams', '1974-02-13 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Drew Bledsoe', '1972-02-14 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Diego Quemada', '1969-02-15 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Elizabeth Olsen', '1989-02-16 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Michael Jordan', '1963-02-17 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Yoko Ono', '1933-02-18 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Amy Tan', '1952-02-19 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Cindy Crawford', '1966-02-20 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'William Baldwin', '1963-02-21 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'George Washington', '1732-02-22 00:00:00', '1799-12-14 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Sylvia Millecam', '1956-02-23 00:00:00', '2001-08-19 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Beth Broderick', '1959-02-24 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'George Harrison', '1943-02-25 00:00:00', '2001-11-29 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Erykah Badu', '1972-02-26 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'John Steinbeck', '1902-02-27 00:00:00', '1968-12-20 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Bubba Smith', '1945-02-28 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Antonella Ponziani', '1964-02-29 00:00:00', '0000-00-00 00:00:00'));

  // March Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'David Niven', '1910-03-01 00:00:00', '1983-07-29 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Tempany Deckert', '1978-03-02 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Alexander Graham Bell', '1874-03-03 00:00:00', '1922-08-02 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Jason Newsted', '1963-03-04 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Niki Taylor', '1975-03-05 00:00:00', '0000-00-00 00:00:00'));

  // April Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Abraham Maslow', '1908-04-01 00:00:00', '1970-06-08 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Tony Calabretta', '1961-04-02 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Erik Hazelhoff Roelfzema', '1917-04-03 00:00:00', '2007-09-26 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Jennifer Chambers Lynch', '1968-04-04 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Agnetha Faltskog', '1950-04-05 00:00:00', '0000-00-00 00:00:00'));

  // May Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Rita Coolidge', '1945-05-01 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Bing Crosby', '1901-05-02 00:00:00', '1977-10-14 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'James Brown', '1933-05-03 00:00:00', '2006-12-25 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Audrey Hepburn', '1929-05-04 00:00:00', '1993-01-20 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Minami Takayama', '1964-05-05 00:00:00', '0000-00-00 00:00:00'));

  // June Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Alanis Morissette', '1974-06-01 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Nikki Cox', '1978-06-02 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Suzi Quatro', '1950-06-03 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Rosalind Russell', '1907-06-04 00:00:00', '1977-11-28 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Brian McKnight', '1969-06-05 00:00:00', '0000-00-00 00:00:00'));

  // July Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Lady Diana Frances Spencer', '1961-07-01 00:00:00', '1981-06-29 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Jarrod Emick', '1969-07-02 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Shane Lynch', '1976-07-03 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Angela Baddeley', '1904-07-04 00:00:00', '1976-02-22 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Shirley Knight', '1936-07-05 00:00:00', '0000-00-00 00:00:00'));

  // August Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Barack Obama', '1961-08-04 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Steve (Duketown): a donation is welcome on my birthday :-)', '1962-08-14 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Halle Berry', '1966-08-14 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Robert De Niro', '1943-08-16 23:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Mark Webber', '1976-08-27 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Cameron Diaz', '1972-08-30 00:00:00', '0000-00-00 00:00:00'));

  // September Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Scott Bigelow', '1961-09-01 00:00:00', '2007-01-19 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Terry Bradshaw', '1961-09-02 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Charlie Sheen', '1965-09-03 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Keiko Oginome', '1964-09-04 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Freddie Mercury', '1946-09-05 00:00:00', '1991-11-24 00:00:00'));

  // October Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Julie Andrews', '1935-10-01 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Tara Moss', '1973-10-02 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'James Herriot', '1916-10-03 00:00:00', '1995-02-23 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Chris Lowe', '1959-10-04 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Kate Elizabeth Winslet', '1975-10-05 00:00:00', '0000-00-00 00:00:00'));

  // November Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Gary Player', '1935-11-01 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Pat Buchanan', '1938-11-02 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Travis Robertson', '1981-11-03 00:00:00', '1995-02-23 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Gary Stretch', '1968-11-04 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'John McGiver', '1913-11-05 00:00:00', '1975-11-09 00:00:00'));

  // November Birthdays
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Bette Midler', '1945-12-01 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Britney Spears', '1981-12-02 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Ozzy Osbourne', '1948-12-03 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Tyra Banks', '1973-12-04 00:00:00', '0000-00-00 00:00:00'));
  $birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
  $db->Execute($query, array($birthday_id, 'Sinterklaas', '1713-12-05 00:00:00', '0000-00-00 00:00:00'));
  
  // Save the last used sequence id, so the sample range can be deleted
  $query = 'SELECT * FROM '.cms_db_prefix().'module_birthdaylisting_birthdays_seq';
  $row = $db->GetRow($query);
  $this->SetPreference('sampleloadafter', $row['id']);

  $params = array('tab_message'=> 'samplehandlingcreated', 'active_tab' => 'birthdays');
  $this->Redirect($id, 'defaultadmin', $returnid, $params);                       
}
else {
  // Apparantly the user wants to delete all the sample data
  $query = 'DELETE FROM '.cms_db_prefix().'module_birthdaylisting_birthdays WHERE birthday_id BETWEEN ? AND ?';
  $db->Execute($query, array($this->GetPreference('sampleloadbefore'), $this->GetPreference('sampleloadafter')));

  $params = array('tab_message'=> 'samplehandlingdeleted', 'active_tab' => 'birthdays');
  $this->Redirect($id, 'defaultadmin', $returnid, $params);                       
}
?>