<?php
# BirthdayListing (Who is celebrating today his/her birthday?). A module for CMS - CMS Made Simple
# This module has specially written for the first Dutch Workshop on CMSMS held Januari 24th 2009
# Copyright (c) 2010 by Duketown <duketown@mantox.nl>
#
# This function supports the back end for the module birthday listing
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/birthdaylisting
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

if (isset($params['cancel'])) 
	$this->Redirect($id, 'defaultadmin', $returnid);

if( !$this->CheckPermission('Modify Templates') )
{
	return;
}
$themeObject = &$gCms->variables['admintheme'];

$templatename = (isset($params['templatename']) ? $params['templatename'] : '');
$newtemplatename = (isset($params['newtemplatename']) ? $params['newtemplatename'] : '');
$templatecontent = (isset($params['templatecontent']) ? $params['templatecontent'] : '');

if (isset($params['submit']) || isset($params['apply']))
{
	if ($newtemplatename != "")
	{
		$error = false;
		if ($newtemplatename != $templatename)
		{
			if ($this->GetTemplate($newtemplatename) != '')
			{
				$themeObject = $gCms->variables['admintheme'];
				echo $themeObject->ShowErrors($this->Lang('errortemplatenameexists'));
				$newtemplatename = $templatename;
				$error = true;
			}
			else
			{
				// Seems as though this line was causing adding a template 
				//  to delete the template that already existed
				// $this->DeleteTemplate($templatename);
			}
		}
		
		if (!$error)
		{
			$this->SetTemplate($newtemplatename, $templatecontent);
			if (isset($params['submit']))
			{
				$params = array('tab_message' => 'updatetemplatesuccess', 'tab' => 'templates');
				$this->Redirect($id, 'defaultadmin', $returnid, $params);
			} else {
				$templatename = $newtemplatename;
			}
		}

	}
	else
	{
		echo $this->lang('noname');
	}
}
else
	$templatecontent = $this->GetTemplate($templatename);

echo $this->StartTabHeaders();
echo $this->SetTabHeader('template',$this->Lang('template'));
echo $this->SetTabHeader('help',$this->Lang('template_help'));
echo $this->EndTabHeaders();
echo $this->StartTabContent();
echo $this->StartTab("template");

echo $this->CreateFormStart($id, 'edittemplate', $returnid);

echo $this->CreateInputHidden($id, 'templatename', $templatename);

$this->smarty->assign('nametext', $this->Lang('templatename'));
$this->smarty->assign('nameinput', $this->CreateInputText($id, 'newtemplatename', $templatename, 30, 255));

$this->smarty->assign('contenttext', $this->Lang('template'));
$this->smarty->assign('contentinput', $this->CreateTextArea(false, $id, $templatecontent, 'templatecontent', '', '', '', '', '80', '20'));
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$this->smarty->assign('apply', $this->CreateInputSubmit($id, 'apply', lang('apply')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));

echo $this->ProcessTemplate('newedittemplate.tpl');

echo $this->CreateFormEnd();
echo $this->EndTab();
echo $this->StartTab("help");
echo $this->Lang('help_template');
echo $this->EndTab();
echo $this->EndTabContent();
?>