<?php

if (!isset($gCms)) 
{
	exit(); 
}

check_login();

if (! $this->CheckPermission('Use Enhanced XSPF'))
{
	echo $this->ShowErrors($this->Lang('err_access_denied'));
	return;
}

$modparms = $this->GetParameters();
$messages = array();
$param_prefs_inputs = array();
$no_param_prefs_inputs = array();

if (isset($params['cancel']))
{
	return $this->Redirect($id, 'defaultadmin', $returnid);
} 
elseif (isset($params['submit']) && isset($params['prefs']))
{
	foreach (array('count_downloads', 'no_direct_downloads', 'repeat', 'shuffle', 'autoload', 'autoplay', 'autoresume') as $bool_pref)
	if (!isset($params['prefs'][$bool_pref]))
	{
		$params['prefs'][$bool_pref] = '0';
	}
	$prefs_changed = false;
	foreach ($params['prefs'] as $submitted_pref => $value)
	{
		$pref_changed = false;
		if ($value != $this->GetPreference($submitted_pref))
		{
			$this->SetPreference($submitted_pref, $value);
			$messages[] = $this->ShowMessage($this->Lang('msg_set_preference', $submitted_pref));
			$pref_changed = true;
			$prefs_changed = true;
		}
		if ($pref_changed)
		{
			$this->Audit(0, $this->GetFriendlyName(), $this->Lang('audit_admin_prefs_changed'));
		}
	}
	if (!$prefs_changed)
	{
		$messages[] = $this->ShowMessage($this->Lang('msg_no_changes'));
	}
}

$themeObject  = (isset($this->cms->variables['admintheme']) ? $this->cms->variables['admintheme'] : '');

$this->smarty->assign('formstart', $this->CreateFormStart($id, 'defaultadmin', $returnid, 'post', '', false, '', array('active_tab' => 'prefs')));
foreach ($modparms as $param)
{
	if (
		! in_array($param['name'], $this->getExtraParameters()) 
		&& 
		! in_array($param['name'], array('playlist', 'song', 'song_title', 'lang'))
	)
	{
		$input_name = 'prefs[' . $param['name'] . ']';
		$input = array();
		if (
			$param['name'] == 'count_downloads' ||
			$param['name'] == 'no_direct_downloads' ||
			$param['name'] == 'shuffle' ||
			$param['name'] == 'repeat' ||
			$param['name'] == 'autoload' ||
			$param['name'] == 'autoplay' ||
			$param['name'] == 'autoresume'
		)
		{
			$input['input'] = $this->CreateInputCheckbox($id, $input_name, 1, $this->GetPreference($param['name']), 'id="'.$param['name'].'"');
		}
		if (
			$param['name'] == 'slim_player_height' ||
			$param['name'] == 'extended_player_height' ||
			$param['name'] == 'player_width'
		)
		{
			$input['input'] = $this->CreateInputText($id, $input_name, $this->GetPreference($param['name']), 3); 
		}
		if (
			$param['name'] == 'player'
		)
		{
			$items = array($this->Lang('dropdown_item_player_extended') => 'extended', $this->Lang('dropdown_item_player_slim') => 'slim');
			$input['input'] = $this->CreateInputDropDown($id, $input_name, $items, -1, $this->GetPreference('player'));
		}
		if (
			$param['name'] == 'extended_player_url' ||
			$param['name'] == 'slim_player_url'
		)
		{
			$input['input'] = $this->CreateInputText($id, $input_name, $this->GetPreference($param['name']), 64);
		}
		
		$input['param_name'] = $param['name'];
		$input['help'] = $this->ShowMessage($this->Lang('help_parameter_' . $param['name']));
		$input['label'] = $this->CreateLabelForInput($id, $input_name, $this->Lang('label_admin_prefs_' . $param['name']), '');
		$input['info_image'] = $themeObject->DisplayImage('icons/system/info.gif', lang('help'), '', '', 'systemicon');
		
		$param_prefs_inputs[] = $input;
	}
}
foreach (array('no_direct_downloads') as $no_param_pref)
{
	$input_name = 'prefs[' . $no_param_pref . ']';
	$input = array();
	if (
		$no_param_pref == 'no_direct_downloads'
	)
	{
		$input['input'] = 
			$this->CreateInputCheckbox(
				$id, 
				$input_name, 
				1, 
				$this->GetPreference($no_param_pref, 'id="'.$no_param_pref.'"')
			)
		;
		$input['param_name'] = $no_param_pref;
		$input['help'] = $this->ShowMessage($this->Lang('help_parameter_' . $no_param_pref));
		$input['label'] = $this->CreateLabelForInput($id, $input_name, $this->Lang('label_admin_prefs_' . $no_param_pref), '');
		$input['info_image'] = $themeObject->DisplayImage('icons/system/info.gif', lang('help'), '', '', 'systemicon');
		$no_param_prefs_inputs[] = $input;
	}

}

$headers = array();
foreach (array('module_options', 'parameter_defaults') as $header)
{
	$headers[$header] = $this->Lang('header_' . $header);
}
$this->smarty->assign('param_prefs_inputs'  , $param_prefs_inputs);
$this->smarty->assign('no_param_prefs_inputs'  , $no_param_prefs_inputs);
$this->smarty->assign('messages', $messages);
$this->smarty->assign('headers', $headers);
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', 'Cancel'));
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', 'Submit'));
$this->smarty->assign('formend', $this->CreateFormEnd());

?>