<?php

if (!isset($gCms)) 
{
	exit(); 
}

check_login();

if (! $this->CheckPermission('Use Enhanced XSPF'))
{
	echo $this->ShowErrors($this->Lang('err_access_denied'));
	return;
}

require_once cms_join_path('lib', 'classes', 'class.EnhancedXSPFAdmin.php');

$errors = array();

// create an Admin object
$admin =& new EnhancedXSPFAdmin($this->cms->smarty, $this->cms->db, $params);

if (isset($params['cancel']))
{
	return $this->doAction('defaultadmin', $id, $params, $returnid);
} 
elseif (isset($params['submit'])) 
{
	require_once cms_join_path('lib', 'classes', 'class.PlaylistManager.php');
	require_once cms_join_path('lib', 'classes', 'class.Playlist.php');
	
	$submitted_playlist =& new Playlist($params['playlist_name'], $params['playlist_description']);
	$playlist_manager =& new PlaylistManager($this->cms->db);
	$ret = $playlist_manager->addPlaylist($submitted_playlist);
	switch (empty($ret['errors']))
	{
		case false:
			$errors = $ret['errors'];
			foreach ($errors as $index => $error)
			{
				$errors[$index] = $this->ShowErrors($this->Lang('err_admin_add_playlist_'. $error));
			}
			break;
		case true:
			$params = array();
			$params['active_tab'] = 'playlists';
			$params['playlist_id'] = $ret['new_id'];
			$params['messages'] = array($this->Lang('msg_playlist_added'));
			
			$this->Audit($ret['new_id'], $this->GetFriendlyName(), $this->Lang('audit_admin_playlist_added'));

			return $this->DoAction('admin_add_playlist_songs', $id, $params, $returnid);
	}
	$this->smarty->assign('errors', $errors);
}

// create the tabheaders
$tabheaders = array();
foreach ($admin->getTabs() as $tabname)
{
	$tabheaders[] = $this->SetTabHeader($tabname, $this->Lang('title_admintab_' . $tabname), ($admin->getActiveTab() == $tabname));
}

// create the tabs content
$tabcontent = array();
foreach ($admin->getTabs() as $tabname)
{
	$tab = array();
	$tab['start'] = $this->StartTab($tabname);
	if ($tabname == 'playlists')
	{
		$module =& $this->GetModuleInstance('Uploads');
		if (!$module)
		{
			echo $this->ShowErrors($this->Lang('err_uploads_module_not_installed'));
			return;
		}
		$categorylist = $module->getCategoryList();
		if (empty($categorylist))
		{
			echo $this->ShowErrors($this->Lang('err_no_uploads_categories_defined'));
			echo '<a href="moduleinterface.php?module=Uploads&m1_active_tab=categories">'. $this->Lang('title_link_add_uploads_categories') . '</a>';
			return;
		}
		
		$this->smarty->assign('header_add_playlist', $this->Lang('header_add_playlist'));
		$this->smarty->assign('formstart', $this->CreateFormStart($id, 'admin_add_playlist', $returnid));
		$this->smarty->assign('labels',
			array(
				'playlist_name' => $this->Lang('name'), 
				'playlist_description' => $this->Lang('description')
			)
		);
		$this->smarty->assign('inputs',
			array(
				'playlist_name' => $this->CreateInputText($id, 'playlist_name', '', '20'), 
				'playlist_description' => $this->CreateTextArea(false, $id, isset($params['playlist_description']) ? $params['playlist_description'] : '', 'playlist_description', 'pageheadtags')
			)
		);
		$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
		$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
		$this->smarty->assign('formend', $this->CreateFormEnd());
		$tab['content'] = $this->ProcessTemplate('admin_add_playlist.tpl');
	}
	else
	{
		$this->doAction('admin_'.$tabname, $id, $params, $returnid);
		$tab['content'] = $this->ProcessTemplate('admin_'.$tabname.'.tpl');
	}
	$tab['end'] = $this->EndTab();
	$tabcontent[] = $tab;
}

// assign Smarty variables
$this->smarty->assign('errors', $errors);
$this->smarty->assign('tabheaders_start', $this->StartTabHeaders());
$this->smarty->assign('tabheaders'      , $tabheaders);
$this->smarty->assign('tabheaders_end'  , $this->EndTabHeaders());
$this->smarty->assign('tabcontent_start', $this->StartTabContent());
$this->smarty->assign('tabcontent'      , $tabcontent);
$this->smarty->assign('tabcontent_end'  , $this->EndTabContent());

// process the template
echo $this->ProcessTemplate('defaultadmin.tpl');


?>