<?php

class EnhancedXSPF extends CMSModule
{
	function GetName()
	{
		return 'EnhancedXSPF';
	}

	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}

	function GetVersion()
	{
		return '0.5';
	}

	function GetHelp()
	{
		return $this->Lang('help');
	}

	function GetAuthor()
	{
		return 'Dick Ittmann';
	}

	function GetAuthorEmail()
	{
		return 'dick <at> ittmann.nl';
	}

	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}

	function IsPluginModule()
	{
		return true;
	}

	function HasAdmin()
	{
		return true;
	}

	function GetAdminSection()
	{
		return 'extensions';
	}

	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}

	function VisibleToAdminUser()
	{
		return $this->CheckPermission('Use Enhanced XSPF');
	}

	function GetDependencies()
	{
		return array('Uploads' => '1.2.3');
	}

	function MinimumCMSVersion()
	{
		return "1.0.2";
	}

	function SetParameters()
	{
		$params = array_merge(
			// non-preference parameters
			$this->getExtraParameters(),
			array(
				// preference parameters
				'player',
				'extended_player_url',
				'slim_player_url',
				'player_width',
				'slim_player_height',
				'extended_player_height',
				'autoresume',
				'autoplay',
				'autoload',
				'repeat', 
				'shuffle', 
				'count_downloads', 
				'song_title', 
				'song', 
				'playlist'
			)
		);
		foreach ($params as $param)
		{
			$this->CreateParameter(
				$param, 
				$this->GetPreference($param), 
				$this->lang('help_parameter_' . $param)
			);
		}
	}

	function GetEventDescription($eventname)
	{
	    return $this->Lang('event_info_'.$eventname);
	}

	function GetEventHelp ($eventname)
	{
	    return $this->Lang('event_help_'.$eventname);
	}

	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}
	
	// NON-API FUNCTIONS BELOW
			
	function setDefaultPrefs()
	{
		$prefs = array(
			'player'                 => 'extended',
			'extended_player_url'    => $this->cms->config['root_url'] . '/modules/EnhancedXSPF/xspf/Extended/xspf_player.swf',
			'slim_player_url'        => $this->cms->config['root_url'] . '/modules/EnhancedXSPF/xspf/Slim/xspf_player_slim.swf',
			'player_width'           => '400',
			'slim_player_height'     => '15',
			'extended_player_height' => '170',
			'autoresume'             => '1',
			'autoload'               => '1',
			'autoplay'               => '0',
			'shuffle'                => '0',
			'repeat'                 => '0',
			'count_downloads'        => '0',
			'no_direct_downloads'    => '0'
		);
		foreach ($prefs as $pref => $value)
		{
			$this->SetPreference($pref, $value);
		}
	}
			
	/*
	 * @see xspf/xspfdoc.html#useage
	 */
	function getExtraParameters()
	{
		// non-preference parameters
		return array(
			'alpha',
			'alphabetize',
			'buffer',
			'color',
			'gotoany',
			'image',
//			'info_button_text',
			'infourl',
			'loadurl',
			'load_message',
			'main_image',
			'mainurl',
			'no_continue',
			'player_title',
//			'radio_mode',
			'repeat_playlist',
			'setup',
			'start_track',
			'statsurl',
			'timedisplay',
			'useId3',
			'volume_level'
		);
	}
}

?>
