<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: GCharts (c) 2013 by Oliver Seddon 
#         (oliver@threefold.co.uk)
#  An addon module for CMS Made Simple to add Google Charts to your pages
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

if (!isset($gCms)) exit;

if( !class_exists('gcharts_admin_ops') )
  {
    // this is required if called from the installer
    $fn = dirname(__FILE__).'/lib/class.gcharts_admin_ops.php';
    require_once($fn);
  }

$db = $this->GetDb();
$dict = NewDataDictionary( $db );
$flds = "
     gcharts_id I KEY,
	 gcharts_category_id I,
	 gcharts_element_id C(255),
	 gcharts_category_name C(255),
	 gcharts_name C(255),
	 gcharts_data X,
	 axisTitlesPosition C(255),
	 backgroundColor C(255),
	 chartArea C(255),
	 curveType C(255),
	 colors C(255),
	 enableInteractivity C(255),
	 focusTarget C(255),
	 fontSize C(255),
	 fontName C(255),
	 hAxes C(255),
	 hAxis C(255),
	 height C(255),
	 interpolatedNulls C(255),
	 isHtml C(255),
	 isStacked C(255),
	 is3D C(255),
	 legend C(255),
	 lineWidth C(255),
	 slices C(255),
	 pieSliceBorderColor C(255),
	 pieSliceText C(255),
	 pieSliceTextStyle C(255),
	 pointSize C(255),
	 reverseCategories C(255),
	 series C(255),
	 sliceVisibilityThreshold C(255),
	 pieResidueSliceColor C(255),
	 pieResidueSliceLabel C(255),
	 theme C(255),
	 title C(255),
	 titlePosition C(255),
	 titleTextStyle C(255),
	 tooltip C(255),
	 vAxes C(255),
	 vAxis C(255),
	 width C(255),
	 aggregationTarget C(255),
	 groupWidth C(255),
	 status C(25)
";

$taboptarray = array( 'mysql' => 'TYPE=MyISAM' );
$sqlarray = $dict->CreateTableSQL( cms_db_prefix()."module_gcharts",
				   $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_gcharts_seq");

$flds = "
	gcharts_category_id I KEY,
	gcharts_category_name C(255),
	parent_id I,
	hierarchy C(255),
	create_date ".CMS_ADODB_DT.",
	modified_date ".CMS_ADODB_DT."
";

$taboptarray = array('mysql' => 'TYPE=MyISAM');
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_gcharts_categories", 
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_gcharts_categories_seq");

// create a permission
$this->CreatePermission('Use GCharts', 'Use GCharts');
$this->CreatePermission('Approve GCharts', 'Approve GCharts For Frontend Display');
$this->CreatePermission('Delete GCharts', 'Delete GCharts Charts');

// create a preference
$this->SetPreference("allow_add", true);

# Setup categories
$query = 'INSERT INTO '.cms_db_prefix().'module_gcharts_categories (gcharts_category_id, gcharts_category_name, parent_id, create_date, modified_date) VALUES (?,?,?,'.$db->DBTimeStamp(time()).','.$db->DBTimeStamp(time()).')';
$db->Execute($query, array('1', 'Pie Chart', -1));

$query = 'INSERT INTO '.cms_db_prefix().'module_gcharts_categories (gcharts_category_id, gcharts_category_name, parent_id, create_date, modified_date) VALUES (?,?,?,'.$db->DBTimeStamp(time()).','.$db->DBTimeStamp(time()).')';
$db->Execute($query, array('2', 'Line Chart', -1));

$query = 'INSERT INTO '.cms_db_prefix().'module_gcharts_categories (gcharts_category_id, gcharts_category_name, parent_id, create_date, modified_date) VALUES (?,?,?,'.$db->DBTimeStamp(time()).','.$db->DBTimeStamp(time()).')';
$db->Execute($query, array('3', 'Bar Chart', -1));

$query = 'INSERT INTO '.cms_db_prefix().'module_gcharts_categories (gcharts_category_id, gcharts_category_name, parent_id, create_date, modified_date) VALUES (?,?,?,'.$db->DBTimeStamp(time()).','.$db->DBTimeStamp(time()).')';
$db->Execute($query, array('4', 'Column Chart', -1));

# Setup detail template
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.
  'templates'.DIRECTORY_SEPARATOR.'gcharts_list.tpl';
if( file_exists( $fn ) ) {
    $template = @file_get_contents($fn);
    $this->SetPreference('default_detail_template_contents',$template);
    $this->SetTemplate('detailSample',$template);
    $this->SetPreference('current_detail_template','Default');
}

# Setup permissions
$perm_id = $db->GetOne("SELECT permission_id FROM ".cms_db_prefix()."permissions WHERE permission_name = 'Modify GCharts'");
$group_id = $db->GetOne("SELECT group_id FROM ".cms_db_prefix()."groups WHERE group_name = 'Admin'");

$count = $db->GetOne("SELECT count(*) FROM " . cms_db_prefix() . "group_perms WHERE group_id = ? AND permission_id = ?", array($group_id, $perm_id));
if (isset($count) && intval($count) == 0)
{
	$new_id = $db->GenID(cms_db_prefix()."group_perms_seq");
	$query = "INSERT INTO " . cms_db_prefix() . "group_perms (group_perm_id, group_id, permission_id, create_date, modified_date) VALUES (".$new_id.", ".$group_id.", ".$perm_id.", ". $db->DBTimeStamp(time()) . ", " . $db->DBTimeStamp(time()) . ")";
	$db->Execute($query);
}

$group_id = $db->GetOne("SELECT group_id FROM ".cms_db_prefix()."groups WHERE group_name = 'Editor'");

$count = $db->GetOne("SELECT count(*) FROM " . cms_db_prefix() . "group_perms WHERE group_id = ? AND permission_id = ?", array($group_id, $perm_id));
if (isset($count) && intval($count) == 0)
{
	$new_id = $db->GenID(cms_db_prefix()."group_perms_seq");
	$query = "INSERT INTO " . cms_db_prefix() . "group_perms (group_perm_id, group_id, permission_id, create_date, modified_date) VALUES (".$new_id.", ".$group_id.", ".$perm_id.", ". $db->DBTimeStamp(time()) . ", " . $db->DBTimeStamp(time()) . ")";
	$db->Execute($query);
}

#Setup events
$this->CreateEvent('GChartsChartAdded');
$this->CreateEvent('GChartsChartEdited');
$this->CreateEvent('GChartsChartDeleted');
$this->CreateEvent('GChartsCategoryAdded');
$this->CreateEvent('GChartsCategoryEdited');
$this->CreateEvent('GChartsCategoryDeleted');

$this->RegisterModulePlugin(TRUE);
$this->RegisterSmartyPlugin('gcharts','function','function_plugin');

// and routes...
$route = new CmsRoute('/[gG]charts\/(?P<chartid>[0-9]+)\/(?P<returnid>[0-9]+)\/(?P<junk>.*?)\/d,(?P<detailtemplate>.*?)$/',
		      $this->GetName());
cms_route_manager::add_static($route);
$route = new CmsRoute('/[gG]charts\/(?P<chartid>[0-9]+)\/(?P<returnid>[0-9]+)\/(?P<junk>.*?)$/',$this->GetName());
cms_route_manager::add_static($route);
$route = new CmsRoute('/[gG]charts\/(?P<chartid>[0-9]+)\/(?P<returnid>[0-9]+)$/',$this->GetName());
cms_route_manager::add_static($route);
$route = new CmsRoute('/[gG]charts\/(?P<chartid>[0-9]+)$/',$this->GetName());
cms_route_manager::add_static($route);

// put mention into the admin log
$this->Audit( 0, 
	      $this->Lang('friendlyname'), 
	      $this->Lang('installed', $this->GetVersion()) );

	      
?>