<?php
if( !isset($gCms) ) exit;

$smarty->assign('formstart',$this->CreateFormStart($id,'defaultadmin'));  
	
$allcategories = (isset($params['allcategories'])?$params['allcategories']:'no');

if (isset($params['submit_massdelete']) )
  {
    if (!$this->CheckPermission('Delete GCharts'))
      {
	echo $this->ShowErrors($this->Lang('needpermission', array('Modify GCharts')));
      }
    else if( isset($params['sel']) && is_array($params['sel']) &&
	count($params['sel']) > 0 )
      {
        foreach( $params['sel'] as $gcharts_id )
	  {
	    gcharts_admin_ops::delete_chart( $gcharts_id );
	  }
      }
  }
else if (isset($params['submit_reassign']) )
  {
    if( isset($params['sel']) && is_array($params['sel']) &&
	count($params['sel']) > 0 )
      {
	$tmp = str_repeat('?,',count($params['sel']));
	$tmp = substr($tmp,0,strlen($tmp)-1);
	$query = 'UPDATE '.cms_db_prefix().'module_gcharts SET gcharts_category_id = ? WHERE gcharts_id IN ('.$tmp.')';
	$parms = array($params['category']);
	foreach( $params['sel']  as $p ) $parms[] = $p;
	$db->Execute($query,$parms);
      }
    else
      {
	echo $this->ShowErrors($this->Lang('error_nochartsselected'));
      }
  }

$categorylist = array();
$categorylist[$this->Lang('allcategories')] = '';
$query = "SELECT * FROM ".cms_db_prefix()."module_gcharts_categories ORDER BY hierarchy";
$dbresult = $db->Execute($query);

$curcategory = $this->GetPreference('chart_category');
$pagelimit = $this->GetPreference('chart_pagelimit',25);
$pagenumber = 1;
if( isset( $params['pagenumber'] ) )
  {
    $pagenumber = $params['pagenumber'];
  }
$startelement = ($pagenumber-1) * $pagelimit;
$sortby = $this->GetPreference('chart_sortby','gcharts_name DESC');
$sortlist = array();
$sortlist[$this->Lang('name_asc')] = 'gcharts_name ASC';
$sortlist[$this->Lang('name_desc')] = 'gcharts_name DESC';
$sortlist[$this->Lang('status_asc')] = 'status ASC';
$sortlist[$this->Lang('status_desc')] = 'status DESC';

$smarty->assign('prompt_category',$this->Lang('category'));
$smarty->assign('input_category',
		$this->CreateInputDropdown($id,'category',$categorylist,-1,$curcategory));
$smarty->assign('prompt_showchildcategories',
		$this->Lang('showchildcategories'));
$smarty->assign('input_allcategories',
		$this->CreateInputCheckbox($id,'allcategories','yes',$allcategories));
$smarty->assign('prompt_sorting',
		$this->Lang('prompt_sorting'));
$smarty->assign('input_sorting',
		$this->CreateInputDropdown($id,'sortby',$sortlist,-1,$sortby));
$smarty->assign('prompt_pagelimit',
		$this->Lang('prompt_pagelimit'));
$smarty->assign('input_pagelimit',
		$this->CreateInputDropdown($id,'pagelimit',
					   array('5'=>5,'25'=>25,'50'=>50,
						 '100'=>100,'500'=>500,'1000'=>1000,$this->Lang('unlimited')=>999999999),-1,$pagelimit));
	
$smarty->assign('formend',$this->CreateFormEnd());
	
//Load the current charts
$entryarray = array();

$dbresult = '';

$query1 = "SELECT n.*, nc.gcharts_category_name FROM ".cms_db_prefix()."module_gcharts n LEFT OUTER JOIN ".cms_db_prefix()."module_gcharts_categories nc ON n.gcharts_category_id = nc.gcharts_category_id ";
$query2 = "SELECT count(n.gcharts_id) AS count FROM ".cms_db_prefix()."module_gcharts n LEFT OUTER JOIN ".cms_db_prefix()."module_gcharts_categories nc ON n.gcharts_category_id = nc.gcharts_category_id ";
$parms = array();
if ($curcategory != '')
  {
    $query1 .= " WHERE nc.gcharts_category_name LIKE ?";
    $query2 .= " WHERE nc.gcharts_category_name LIKE ?";
    if( $allcategories == 'yes' )
      {
	$parms[] = $curcategory.'%';
      }
    else
      {
	$parms[] = $curcategory;
      }
  }
$query1 .= ' ORDER by '.$sortby;
//$query1 .= " LIMIT $pagelimit OFFSET $startelement";

// if is done to help adodb.
$numrows = -1;
if( count($parms) )
  {
    $dbresult = $db->SelectLimit( $query1, $pagelimit, $startelement, $parms);
    $row = $db->GetRow($query2,$parms);
    $numrows = $row['count'];
  }
else
  {
    $dbresult = $db->SelectLimit( $query1, $pagelimit, $startelement);
    $row = $db->GetRow($query2);
    $numrows = $row['count'];
  }

$pagecount = (int)($numrows/$pagelimit);
if( ($numrows % $pagelimit) != 0 ) $pagecount++;
// some pagination variables to smarty.
if( $pagenumber == 1 )
  {
    $smarty->assign('prevpage','<');
    $smarty->assign('firstpage','<<');
  }
else
  {
    $smarty->assign('prevpage',
		    $this->CreateLink($id,'defaultadmin',
				      $returnid,'<',
				      array('pagenumber'=>$pagenumber-1,
					    'active_tab'=>'charts')));
    $smarty->assign('firstpage',
		    $this->CreateLink($id,'defaultadmin',
				      $returnid,'<<',
				      array('pagenumber'=>1,
					    'active_tab'=>'charts')));
  }
if( $pagenumber >= $pagecount )
  {
    $smarty->assign('nextpage','>');
    $smarty->assign('lastpage','>>');
  }
else
  {
    $smarty->assign('nextpage',
		    $this->CreateLink($id,'defaultadmin',
				      $returnid,'>',
				      array('pagenumber'=>$pagenumber+1,
					    'active_tab'=>'charts')));
    $smarty->assign('lastpage',
		    $this->CreateLink($id,'defaultadmin',
				      $returnid,'>>',
				      array('pagenumber'=>$pagecount,
					    'active_tab'=>'charts')));
  }
$smarty->assign('pagenumber',$pagenumber);
$smarty->assign('pagecount',$pagecount);
$smarty->assign('oftext',$this->Lang('prompt_of'));

$rowclass = 'row1';

$admintheme =& $gCms->variables['admintheme'];
while ($dbresult && $row = $dbresult->FetchRow())
  {
    $onerow = new stdClass();
    
    $onerow->id = $row['gcharts_id'];
    $onerow->name = $this->CreateLink($id, 'editchart', $returnid, $row['gcharts_name'], array('chartid'=>$row['gcharts_id']));
    $onerow->data = $row['gcharts_data'];
    $onerow->status = $this->Lang($row['status']);
    if( $this->CheckPermission('Approve GCharts') )
      {
	if( $row['status'] == 'published' )
	  {
	    $onerow->approve_link = $this->CreateLink($id,'approvechart',
						    $returnid,
						    $admintheme->DisplayImage('icons/system/true.gif',$this->Lang('revert'),'','','systemicon'),array('approve'=>0,'chartid'=>$row['gcharts_id']));
	  }
	else
	  {
	    $onerow->approve_link = $this->CreateLink($id,'approvechart',
						    $returnid,
						    $admintheme->DisplayImage('icons/system/false.gif',$this->Lang('approve'),'','','systemicon'),array('approve'=>1,'chartid'=>$row['gcharts_id']));
	  }
      }
    $onerow->category = $row['gcharts_category_name'];

    $onerow->rowclass = $rowclass;
    
    $onerow->select = $this->CreateInputCheckbox($id,'sel[]',$row['gcharts_id']);
    if( $this->CheckPermission('Modify GCharts') ) {
      $onerow->editlink = $this->CreateLink($id, 'editchart', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('chartid'=>$row['gcharts_id']));
    }
    if( $this->CheckPermission('Delete GCharts') )
      {
	$onerow->deletelink = $this->CreateLink($id, 'deletechart', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('chartid'=>$row['gcharts_id']), $this->Lang('areyousure'));
      }
    
    $entryarray[] = $onerow;
    
    ($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
  }

$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('itemcount', count($entryarray));

if( $this->CheckPermission('Modify GCharts') ) {
  $smarty->assign('addlink', $this->CreateLink($id, 'addchart', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addchart'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addchart', $returnid, $this->Lang('addchart'), array(), '', false, false, 'class="pageoptions"'));
}

$smarty->assign('form2start',$this->CreateFormStart($id,'defaultadmin',$returnid));
$smarty->assign('form2end',$this->CreateFormEnd());
$smarty->assign('submit_reassign',$this->CreateInputSubmit($id,'submit_reassign',$this->Lang('submit')));
$categorylist = gcharts_ops::get_category_list();
$smarty->assign('categoryinput',$this->CreateInputDropdown($id,'category',$categorylist));
if( $this->CheckPermission('Delete GCharts') )
  {
    $smarty->assign('submit_massdelete',
		    $this->CreateInputSubmit($id,'submit_massdelete',$this->Lang('delete_selected'),
					     '','',$this->Lang('areyousure_deletemultiple')));
  }

$smarty->assign('reassigntext',$this->Lang('reassign_category'));
$smarty->assign('selecttext',$this->Lang('select'));
$smarty->assign('statustext',$this->Lang('status'));
$smarty->assign('statetext',$this->Lang('state'));
$smarty->assign('chartidtext', $this->Lang('id'));
$smarty->assign('elementtext', $this->Lang('element'));
$smarty->assign('nametext', $this->Lang('name'));
$smarty->assign('categorytext', $this->Lang('category'));
$smarty->assign('datatext', $this->Lang('data'));
$smarty->assign('axisTitlesPositiontext', $this->Lang('axisTitlesPosition'));
$smarty->assign('backgroundColortext', $this->Lang('backgroundColor'));
$smarty->assign('chartAreatext', $this->Lang('chartArea'));
$smarty->assign('colorstext', $this->Lang('colors'));
$smarty->assign('curveTypetext', $this->Lang('curveType'));
$smarty->assign('enableInteractivitytext', $this->Lang('enableInteractivity'));
$smarty->assign('focusTargettext', $this->Lang('focusTarget'));
$smarty->assign('fontSizetext', $this->Lang('fontSize'));
$smarty->assign('fontNametext', $this->Lang('fontName'));
$smarty->assign('hAxestext', $this->Lang('hAxes'));
$smarty->assign('hAxistext', $this->Lang('hAxis'));
$smarty->assign('heighttext', $this->Lang('height'));
$smarty->assign('interpolatedNullstext', $this->Lang('interpolatedNulls'));
$smarty->assign('isHtmltext', $this->Lang('isHtml'));
$smarty->assign('isStackedtext', $this->Lang('isStacked'));
$smarty->assign('is3Dtext', $this->Lang('is3D'));
$smarty->assign('legendtext', $this->Lang('legend'));
$smarty->assign('lineWidthtext', $this->Lang('lineWidth'));
$smarty->assign('slicestext', $this->Lang('slices'));
$smarty->assign('pieSliceBorderColortext', $this->Lang('pieSliceBorderColor'));
$smarty->assign('pieSliceTexttext', $this->Lang('pieSliceText'));
$smarty->assign('pieSliceTextStyletext', $this->Lang('pieSliceTextStyle'));
$smarty->assign('pointSizetext', $this->Lang('pointSize'));
$smarty->assign('reverseCategoriestext', $this->Lang('reverseCategories'));
$smarty->assign('seriestext', $this->Lang('series'));
$smarty->assign('sliceVisibilityThresholdtext', $this->Lang('sliceVisibilityThreshold'));
$smarty->assign('pieResidueSliceColortext', $this->Lang('pieResidueSliceColor'));
$smarty->assign('pieResidueSliceLabeltext', $this->Lang('pieResidueSliceLabel'));
$smarty->assign('themetext', $this->Lang('theme'));
$smarty->assign('titletext', $this->Lang('title'));
$smarty->assign('titlePositiontext', $this->Lang('titlePosition'));
$smarty->assign('titleTextStyletext', $this->Lang('titleTextStyle'));
$smarty->assign('tooltiptext', $this->Lang('tooltip'));
$smarty->assign('vAxestext', $this->Lang('vAxes'));
$smarty->assign('vAxistext', $this->Lang('vAxis'));
$smarty->assign('widthtext', $this->Lang('width'));

$gCms = cmsms();
$theme =& $gCms->variables['admintheme'];
$config = $this->GetConfig();
$themedir = $config['admin_url'].'/themes/'.$theme->themeName.'/images/icons/system';

$smarty->assign('iconurl',$themedir);

#Display template
echo $this->ProcessTemplate('chartlist.tpl');

// EOF
?>