<style type="text/css">
span.parent_event {
  font-weight: bold;
  color: lightgreen;
}
span.child_event {
  color: cyan;
}
</style>

<script type="text/javascript">
$(document).ready(function(){
  $('#deletetagged').click(function(){
    var len2 = $('.select:checked').length;
    if( len2 > 0 ) {
      return confirm('{$mod->Lang('confirmdeletetagged')}');
    } else {
      alert('{$mod->Lang('error_nothingselected')}');
      return false;
    }
  });
  $('#sel_all').click(function(){
    var v = $(this).attr('checked');
    if( v == 'checked' ) {
      $('.select').attr('checked','checked');
    } else {
      $('.select').removeAttr('checked');
    }
  });
  $('.select').click(function(){
    var v = $(this).attr('checked');
    if( v == 'checked' ) {
      var len1 = $('.select').length;
      var len2 = $('.select:checked').length;
      if( len1 == len2 ) {
        $('#sel_all').attr('checked','checked');
      }
    }
    else {
      $('#sel_all').removeAttr('checked');
    }
  });
  $('#show_filter').click(function(){
    $('#filterform').toggle('slow');
  });
  $('#dates > select').change(function(){
    $(this).closest('form').submit();
  });  
});
</script>

<div class="pageoverflow" id="filterform" style="display: none;">
  {$formstart}
  <fieldset>
    <legend>{$mod->Lang('filter')}:&nbsp;</legend>
    <div class="pageoverflow">
      <p class="pagetext">{$mod->Lang('cal_filter_by')}:</p>
      <p class="pageinput">
        <input type="text" name="{$actionid}filter_keyword" maxlength="255" value="{$filter.keyword}"/>
      </p>
    </div>
    <div class="pageoverflow">
      <p class="pagetext">{$mod->Lang('cal_show_only_events_in')}:</p>
      <p class="pageinput">
        <select name="{$actionid}filter_category">
        {html_options options=$categories selected=$filter.category}
        </select>
      </p>
    </div>
    <div class="pageoverflow">
      <p class="pagetext">{$mod->Lang('show_child_events')}:</p>
      <p class="pageinput">
        {cge_yesno_options prefix=$actionid name='filter_showchildren' selected=$filter.showchildren}
      </p>
    </div>
    <div class="pageoverflow">
      <p class="pagetext"></p>
      <p class="pageinput">
        <input type="submit" name="{$actionid}filter_submit" value="{$mod->Lang('submit')}"/>
        <input type="submit" name="{$actionid}filter_reset" value="{$mod->Lang('reset')}"/>
        <input type="submit" name="{$actionid}filter_conflicting" value="{$mod->Lang('filter_conflicting')}" onclick="return confirm('{$mod->Lang('areyousure_removeconflicting')}')"/>
      </p>
    </div>
  </fieldset>
  {$formend}
</div>

<div class="pageoptions">
 <div style="float: left; width: 49%;">
   <input type="checkbox" id="show_filter" value="1">&nbsp;<label for="show_filter">{if $filter.filter_applied}{$mod->Lang('show_filter_applied')}{else}{$mod->Lang('show_filter')}{/if}</label>&nbsp;&nbsp;
   {$addlink}&nbsp;&nbsp;{$import_link}
 </div>
 <div style="float: right; width: 49%; text-align: right;">
   {$formstart}
   <a href="{$prevmonth_url}" title="{$mod->Lang('prev_month')}">&laquo;</a>
   <label for="dates">{$mod->Lang('select_period')}:</label> <span id="dates">{html_select_date prefix="{$actionid}filter_" time=$filter.filter_date start_year=1990 end_year='+5' display_days=0}</span>
   <button type="submit" name="{$actionid}filter_homedate">{$mod->Lang('reset')}</button>
   <a href="{$nextmonth_url}" title="{$mod->Lang('next_month')}">&raquo;</a>
   {$formend}
 </div>
</div>

<div style="clear: both;"></div>

{$formstart2|default:''}
{if isset($events) && count($events)}
<table class="pagetable" cellspacing="0">
  <thead>
    <tr>
      <th>{$mod->Lang('cal_id')}</th>
      <th>{$mod->Lang('cal_title')}</th>
      <th>{$mod->Lang('start_date')}</th>
      <th>{$mod->Lang('end_date')}</th>
      <th>{$mod->Lang('recurs')}</th>
      <th>{$mod->Lang('recurs_until')}</th>
      <th>{$mod->Lang('parent')}</th>
      <th class="pageicon"></th>{* edit *}
      <th class="pageicon"></th>{* delete *}
      <th class="pageicon"><input type="checkbox" id="sel_all" value="1"/></th>
    </tr>
  </thead>
  <tbody>
  {foreach from=$events item='one'}
    {cycle values="row1,row2" assign='rowclass'}
    <tr class="{$rowclass}" onmouseover="this.className='{$rowclass}hover';" onmouseout="this.className='{$rowclass}';">
      <td>{$one.event_id}</td>
      <td>
        {if $one.is_parent}<span class="parent_event">
        {elseif $one.event_parent_id > 0}<span class="child_event">
        {/if}

        <a href="{$one.edit_url}" title="{$mod->Lang('edit_event')}">{$one.event_title|strip_tags|cms_escape}</a>
        {if $one.event_parent_id > 0}<span title="{$mod->Lang('title_child_event')}">*</span>{/if}

        {if $one.is_parent}</span>
        {elseif $one.event_parent_id > 0}</span>
        {/if}
      </td>
      <td>{if $one.event_date_end == 0}{$one.event_date_start|date_format:"%x"}{else}{$one.event_date_start|date_format:"%x %H:%M"}{/if}</td>
      <td>{if $one.event_date_end == 0}&nbsp;{else}{$one.event_date_end|date_format:"%x %H:%M"}{/if}</td>
      <td> {if $one.event_recur_period != 'none'}
            {if $one.event_recur_period == 'weekly'}
              {capture assign='tmp2'}<em>{$mod->Lang('on')} ({$mod->ToAbbreviatedWeekdays($one.event_recur_weekdays)})</em>{/capture}
	    {else}
              {assign var='tmp2' value=''}
            {/if}
            {if $one.event_recur_interval > 1}
              {capture assign='tmp'}plural_{$one.event_recur_period}{/capture}
              {$mod->Lang('every')} {$one.event_recur_interval} {$mod->Lang($tmp)} {$tmp2}
            {elseif isset($one.event.recur_period) and $one.event_recur_period != ''}
              {$mod->Lang($one.event_recur_period)} {$tmp2}
            {/if}
          {/if} 
      </td>
      <td>{if $one.event_recur_period != 'none'}{$one.event_date_recur_end|date_format:"%x"}
          {if $one.event_recur_nevents > 0} {$mod->Lang('max')} {$one.event_recur_nevents} {$mod->Lang('times')}{/if}{/if}
      </td>
      <td>{if $one.event_parent_id > 0}
            <span class="child_event"><a href="{$one.edit_parent_url}" title="{$mod->Lang('edit_parent_event')}">{$one.event_parent_id}</a></span>
          {/if}
      </td>
      <td>{$one.editlink}</td>
      <td>{$one.deletelink}</td>
      <td><input class="select" type="checkbox" name="{$actionid}tag[]" value="{$one.event_id}"/></td>
    </tr>
  {/foreach}
  </tbody>
</table>
{/if}

<div class="pageoverflow">
 {if isset($events) && count($events) > 0}
 <div style="float: right: width: 49%; text-align: right;">
   <input id="deletetagged" type="submit" name="{$actionid}delete_selected" value="{$mod->Lang('deletetagged')}"/>
 </div>
 {/if}
</div>
{$formend2|default:''}
