<?php

class cgc_event_loader
{
  private $_idlist;
  private $_eventtemplate;
  private $_events = array();
  private $_fields = array();
  private $_categories = array();
  private $_destpage;
  private $_url_prefix = 'calendar';
  private $_reverse = FALSE;
  private $_actionid;

  public function __construct($actionid,$idlist,$destpage,$reverse,$url_prefix = 'calendar')
  {
    if( is_array($idlist) ) {
      $this->_idlist = array();
      foreach( $idlist as $one ) {
	$one = (int)$one;
	if( $one < 1 ) continue;
	$this->_idlist[] = $one;
      }
      $this->_idlist = array_unique($this->_idlist);
    }
    else if( (int)$idlist > 0 ) {
      $this->_idlist = array((int)$idlist);
    }
    $this->_actionid = $actionid;
    $this->_reverse = (bool)$reverse;
    $this->_destpage = $destpage;
    $this->_url_prefix = $url_prefix;
  }

  public function set_event_template($eventtemplate)
  {
    $this->_eventtemplate = $eventtemplate;
  }

  private function reorder_customfields($customfields)
  {
    $fields = cms_utils::get_module('CGCalendar')->GetFields();
    $fields = cge_array::to_hash($fields,'field_name');

    $func = function($a,$b) use ($fields) {
      if( $a['event_id'] < $b['event_id'] ) return -1;
      if( $a['event_id'] > $b['event_id'] ) return 1;
      $aa = $fields[$a['field_name']];
      $aa = $fields[$b['field_name']];
      if( $aa['field_order'] < $bb['field_order'] ) return -1;
      if( $aa['field_order'] > $bb['field_order'] ) return 1;
      // now compare by field value.
      if( $a['field_value'] < $b['field_value'] ) return -1;
      if( $a['field_value'] > $b['field_value'] ) return -1;
      return 0;
    };

    usort($customfields,$func);
  }

  public function get_events()
  {
    $gCms = cmsms();
    $sorting = ($this->_reverse) ? 'DESC' : 'ASC';
    $query = 'SELECT * FROM '.cms_db_prefix().'module_cgcalendar_events WHERE event_id IN (';
    $query .= implode(',',$this->_idlist).')';
    $query .= " ORDER BY event_date_start $sorting";
    $db = cmsms()->GetDb();

    // get the parent ids and events.
    $events = $db->GetArray($query);
    $parent_ids = $this->_idlist;
    if( !is_array($events) || count($events) == 0 ) return;

    foreach( $events as $row ) {
      if( $row['event_parent_id'] > 0 ) $parent_ids[] = $row['event_parent_id'];
    }
    $parent_ids = array_unique($parent_ids);

    $query = 'SELECT * FROM '.cms_db_prefix().'module_cgcalendar_event_field_values 
              WHERE event_id IN ('.implode(',',$parent_ids).') ORDER BY event_id';
    $frs = $db->GetArray($query);
    $customfields = cge_array::to_hash($frs,'event_id');

    $query = 'SELECT * FROM '.cms_db_prefix().'module_cgcalendar_events_to_categories 
              WHERE event_id IN ('.implode(',',$this->_idlist).') ORDER BY event_id';
    $crs = $db->Execute($query);
    $allcategories = array();
    while( $crs && !$crs->EOF() ) {
      $row = $crs->fields;
      $allcategories[$row['event_id']][] = $row;
      $crs->MoveNext();
    }

    $users = array();
    {
      $userops = $gCms->GetUserOperations();
      $userlist = $userops->LoadUsers();
      foreach ($userlist as $oneuser) {
	$users[$oneuser->id] = $oneuser;
      }
    }

    $module = cms_utils::get_module('CGCalendar');
    foreach( $events as &$row ) {
      $titleSEO = munge_string_to_url($row['event_title']);
      $prettyurl = sprintf($this->_url_prefix.'/%d/%d-%s', $this->_destpage, $row['event_id'], $titleSEO);
      $parms = array();
      $parms['event_id'] = $row['event_id'];
      $parms['display'] = 'event';
      if( $this->_eventtemplate ) $parms['eventtemplate'] = $this->_eventtemplate;
      $row['url'] = $module->create_url($this->_actionid,'default',$this->_destpage,$parms,false,false,$prettyurl);
      //$row['url'] = $module->CreateLink($this->_actionid, 'default', $this->_destpage, '', $parms,  '', true, '', '', $prettyurl);

      $ptr = null;
      if( isset($allcategories[$row['event_id']]) ) {
	$ptr = $allcategories[$row['event_id']];
      }
      else if( $row['event_parent_id'] > 0 && isset($allcategories[$row['event_parent_id']]) ) {
	$ptr = $allcategories[$row['event_parent_id']];
      }
      if( $ptr ) {
	$categories = array();
	foreach( $ptr as $cat ) {
	  $categories[] = $cat['category_id'];
	}
	$row['categories'] = $categories;
	$row['category_names'] = $module->GetCategoryNames($categories);
      }

      $ptr = null;
      if( isset($customfields[$row['event_id']]) ) {
	$ptr = $customfields[$row['event_id']];
      }
      else if( $row['event_parent_id'] > 0 && isset($customfields[$row['event_parent_id']]) ) {
	$ptr = $customfields[$row['event_parent_id']];
      }
      if( $ptr ) {
	$fields = array();
	foreach( $ptr as $fld ) {
	  $fields[$fld['field_name']] = $fld['field_value'];
	}
	$row['fields'] = $fields;
      }

      if( $row['event_created_by'] < 0 ) {
	// negative values (smaller than -100) indicate an admin user account
	$uid = $row['event_created_by'] + 100 * -1;
	$row['admin_uid'] = $uid;
	if( isset($users[$uid]) ) $row['author'] = $users[$uid]->username;
      }

      $row['is_parent'] = ($row['event_recur_interval'] != 'none' && $row['event_recur_interval'] != '');
    }
    return $events;
  }
} // end of class

?>