<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Skeleton (c) 2008 
#      by Robert Allen (akrabat) and
#         Robert Campbell (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow displaying calendars,
#  and management and display of time based events.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !$gCms ) exit;
if( !$this->CheckPermission('Modify Calendar') ) return;

$bare_filter = array('showchildren'=>0,'keyword'=>'','category'=>-1,'filter_applied'=>0,'filter_date'=>'');
$filter = $bare_filter;
$ser_filter = $this->session_get('filter');
if( $ser_filter ) {
  $tmp = unserialize($ser_filter);
  $filter = array_merge($filter,$tmp);
}

// handle the filtering.
if( isset($params['filter_homedate']) ) {
  $filter['filter_date'] = '';
  $this->session_put('filter',serialize($filter));
}
else if( isset($params['filter_Month']) && isset($params['filter_Year']) ) {
  $filter['filter_date'] = trim($params['filter_Year'].'-'.trim($params['filter_Month']));
  $this->session_put('filter',serialize($filter));
}
else if( isset($params['date']) ) {
  $filter['filter_date'] = trim($params['date']);
  $this->session_put('filter',serialize($filter));
}
else if( isset($params['filter_submit']) ) {
  $filter['showchildren'] = (int)get_parameter_value($params,'filter_showchildren',0);
  $filter['keyword'] = trim(get_parameter_value($params,'filter_keyword',''));
  $filter['category'] = (int)get_parameter_value($params,'filter_category',0);
  $this->session_put('filter',serialize($filter));
}
else if( isset($params['filter_reset']) ) {
  $this->session_clear('filter');
  $filter = $bare_filter;
}
else if( isset($params['filter_conflicting']) ) {
  $this->Redirect($id,'admin_remove_conflicted',$returnid);
  return;
}
if( $filter['showchildren'] || $filter['keyword'] || ($filter['category'] > 0) || $filter['filter_date'] ) $filter['filter_applied'] = 1;

$smarty->assign('formstart',$this->CreateFormStart($id,'defaultadmin',$returnid));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('filter',$filter);
//$smarty->assign('input_keyword',$this->CreateInputText($id,'keyword',$filter['keyword'], 25, 100));

$categories = $this->GetCategories();
$category_array = array($this->Lang('cal_any_category')=>-1);
foreach($categories as $category) {
  $category_array[$category['category_name']] = $category['category_id'];
}
$smarty->assign('categories',array_flip($category_array));
$smarty->assign('input_categories',$this->CreateInputDropdown($id,'category_filter',$category_array, -1, $filter['category']));
$smarty->assign('input_submit',$this->CreateInputSubmit($id,'submit',$this->Lang('cal_go')));

$admintheme = cms_utils::get_theme_object();
$smarty->assign('import_link',
		$this->CreateLink($id, 'admin_import', $returnid, 
				 $admintheme->DisplayImage('icons/system/import.gif', $this->Lang('cal_import_events'),'','','systemicon'), 
				 array(), '', false, false, '').' '. 
		$this->CreateLink($id, 'admin_import', $returnid, $this->Lang('cal_import_events'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('addlink',
		$this->CreateLink($id, 'admin_add_event', $returnid, 
				 $admintheme->DisplayImage('icons/system/newobject.gif', $this->Lang('cal_add_event'),'','','systemicon'), 
				 array(), '', false, false, '') .' '. 
		$this->CreateLink($id, 'admin_add_event', $returnid, $this->Lang('cal_add_event'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('show_children', $this->CreateInputYesNoDropdown($id,'showchildren',$filter['showchildren']));

$tmpdate = $filter['filter_date'];
if( !$tmpdate ) $tmpdate = date('Y').'-'.date('m');
list($year,$month) = explode('-',$tmpdate,2);
$sdate = "$year-$month-01 00:00:00";
$eday = date('t',strtotime("$year-$month-02"));
$edate = "$year-$month-$eday 23:59:59";
{
  $t_year = $year;
  $t_month = $month - 1;
  if( $t_month < 1 ) {
    $t_year--;
    $t_month = 12;
  }
  $prevdate = "$t_year-$t_month";
  $smarty->assign('prevmonth_url',$this->create_url($id,'defaultadmin','',array('date'=>$prevdate)));

  $t_year = $year;
  $t_month = $month + 1;
  if( $t_month > 12 ) {
    $t_year++;
    $t_month = 1;
  }
  $nextdate = "$t_year-$t_month";
  $smarty->assign('nextmonth_url',$this->create_url($id,'defaultadmin','',array('date'=>$nextdate)));
}

$sql = 'SELECT E.* FROM '.$this->events_table_name . ' E';
$where = array();

$where[] = "((E.event_date_start BETWEEN '{$sdate}' AND '{$edate}') OR (E.event_date_end BETWEEN '{$sdate}' AND '{$edate}'))";
$sql = 'SELECT E.* FROM '. $this->events_table_name . " E";

if ($filter['category'] > 0 ) {
  $sql .= 'LEFT JOIN ' . $this->events_to_categories_table_name . ' EC ON EC.event_id = E.event_id';
  $where[] = 'EC.category_id = '.$filter['category'];
}
if( !$filter['showchildren'] ) {
  $where[] = 'COALESCE(E.event_parent_id,0) < 1';
}
if(!empty($filter['keyword'])) {
  $tmp = array();
  $tmp[] = "E.event_title LIKE '%{$filter['keyword']}%'";
  $tmp[] = "E.event_details LIKE '%{$filter['keyword']}%'";
  $tmp[] = "E.event_summary LIKE '%{$filter['keyword']}%'";
  $where[] = '('.implode(' OR ',$tmp).')';
}
$sql .= ' WHERE '.implode(' AND ',$where).' ORDER BY E.event_date_start ASC, E.event_title';
  
$rs = $db->Execute($sql);
$entries = array();
if ($rs && $rs->RecordCount() > 0) {
  $smarty->assign('formstart2',$this->CreateFormStart($id, 'deleteevents', $returnid));
  $smarty->assign('formend2',$this->CreateFormEnd());

  while( ($row = $rs->FetchRow()) ) {
    if( $filter['showchildren'] == 0 && $row['event_parent_id'] > 0 ) continue;
    $tmp = $db->UnixTimeStamp($row['event_date_end']);
    $row['is_parent']  = ($row['event_recur_period'] != 'none' && $row['event_recur_period'] != '');
    $row['edit_url']   = $this->CreateURL($id,'admin_add_event',$returnid,array('event_id'=>$row['event_id']));
    $row['checkbox']   = $this->CreateInputCheckBox($id,"tag".$row['event_id'],"tagged","");
    $row['editlink']   = $this->CreateLink($id, 'admin_add_event',$returnid, 
					  $admintheme->DisplayImage('icons/system/edit.gif', $this->Lang('cal_edit'),'','','systemicon'), 
					  array('event_id'=>$row['event_id']));
    if( $row['event_parent_id'] > 0 ) {
      $row['edit_parent_url'] = $this->CreateURL($id,'admin_add_event',$returnid,array('event_id'=>$row['event_parent_id']));
    }
    $row['deletelink'] = $this->CreateLink($id, 'admin_delete_event', $returnid, 
					  $admintheme->DisplayImage('icons/system/delete.gif', $this->Lang('cal_delete'),'','','systemicon'),
					  array('event_id'=>$row['event_id']), 
					  $this->Lang('cal_areyousure').' &quot;'.addslashes(strip_tags($row['event_title'])).'&quot;');
    $entries[] = $row;
  }

  // close off final column
  if( count($entries) ) $smarty->assign('events',$entries);
  $rs->Close();
}

echo $this->ProcessTemplate('admin_events_tab.tpl');
?>