<?php
$lang['act_cachecleaned'] = 'Cache Pulita';
$lang['add_row'] = 'Aggiungi riga';
$lang['alias'] = 'Alias';
$lang['aliases'] = 'Alias';
$lang['ask_clear_image_cache'] = 'Sicuro di voler rimuovere TUTTI i file dalla cache delle immagini?';
$lang['clear_all'] = 'Elimina Tutti i File';
$lang['clear_now'] = 'Elimina Ora';
$lang['delete'] = 'Cancella';
$lang['embedding'] = 'Immagini incorporate';
$lang['embedding_mode'] = 'Modalit&agrave; Incorporazione Immagine';
$lang['embed_sizelimit'] = 'Limite di grandezza per l&#039;immagine incorporabile (kb)';
$lang['embed_types'] = 'Tipo di immagine incorporabile';
$lang['error_alias_duplicatename_atrow'] = 'Duplica il nome alias specificato per l&#039;alias alla riga %d';
$lang['error_alias_noname_atrow'] = 'Nessun nome specificato per l&#039;alias alla riga %d';
$lang['error_alias_nooptions_atrow'] = 'Nessuna opzione specificata per l&#039;alias alla riga %d';
$lang['error_invalid_age'] = 'Et&agrave; preferenza non valido ... Nessuna operazione eseguita';
$lang['error_missingparam'] = 'Un parametro richiesto manca o non &egrave; valido: %s';
$lang['error_invalidparam'] = 'Parametro non valido nella chiamata: %s';
$lang['error_srcnotfound'] = 'Impossibile trovare un file in: %s';
$lang['error_remotefile'] = 'Problema recupero file remoto in %s';
$lang['error_unknownfilter'] = 'CGSmartImage - Filtro Sconosciuto: %s';
$lang['friendlyname'] = 'Calguys Smart Image Toolkit';
$lang['general'] = 'Generale';
$lang['help'] = '<h3>Cosa fa?</h3>
<p>Questo modulo facilita l&#039;elaborazione e la visualizzazione delle immagini nel tuo sito web. Permette una semplice elaborazione dell&#039;immagine, e l&#039;aggiunta di filigrana. Questo modulo rende banale il processo di visualizzazione delle immagini nel tuo sito. Inoltre fornisce funzionalit&agrave; per migliorare la valutazione delle prestazioni del tuo sito web, rendendolo potente e veloce al tempo stesso.</p>
<h3>Caratteristiche</h3>
<ul>
<li>Elaborazione e filtraggio delle immagini potenti ma semplici da usare. Il filtraggio comprende:
  <ul>
    <li>Sfocatura</li>
    <li>Luminosit&agrave;</li>
    <li>Colorazione</li>
    <li>Contrasto</li>
    <li>Ritaglio</li>
    <li><strong>Ritaglio e adattamento</strong></li>
    <li>Rilevamento dei bordi</li>
    <li>Rilievo</li> 
    <li>Scala di grigi</li>
    <li>Rimozione media</li>
    <li>Negativo</li>
    <li>Effetto pixel</li>
    <li>Ridimensionamento</li>
    <li>Rotazione</li>
    <li>Sfocatura selettiva</li>
    <li>Smussamento</li>
    <li>Filigrana</li>
  </ul>
</li><br/>
<li>Rilevamento intelligente di immagini. Specificare URL assoluti, percorsi assoluti o relativi ai file nella cartella principale del sito.</li>
<li>Scaricamento automatico, memorizzazione in cache, elaborazione, e rimemorizzazione in cache di immagini di siti remoti.</li>
<li>Ridimensionamento intelligente automatico (ridimensiona automaticamente alla larghezza ed altezza desiderate prima di servire l&#039;immagine... ridimensionando a larghezza E altezza provoca un ritaglio adattato). <em>(Basta specificare un parametro per la larghezza e/o uno per l&#039;altezza nel tag CGSmartImage).</em></li>
<li>Legge automaticamente le informazioni EXIF dell&#039;immagine e corregge l&#039;orientamento.</li>
<li>Rilevamento del cambiamento dell&#039;immagine, se l&#039;immagine principale &egrave; cambiata verranno generate immagini scalate. (per disabilitare questo comportamento, vedi il parametro notimecheck).</li>
<li>Generazione intelligente automatica degli attributi delle immagini.</li>
<li>Le immagini elaborate vengono memorizzate nella cache del server per velocizzarne la fruizione.</lI>
<li>Possibilit&agrave; di utilizzare un URL separato (CDN) per servire le immagini</li>
<li>Le elaborazioni dell&#039;immagine possono essere combinate e vengono eseguite in ordine.</li>
<li>Offre la possibilit&agrave; di inserire le immagini direttamente nel contenuto della pagina web, per minimizzare lo spazio.</li>
<li>Fornisce la capacit&agrave; di limitare elegantemente l&#039;inclusione delle immagini, solo per quei browser in grado di gestirle.</li>
<li>Combina gli argomenti comunemente usati in alias denominati.</li>
<li>Funziona anche nei folgi di stile con il tag {cms_stylesheet}.</li>
<li>Possibilit&agrave; di elaborare automaticamente le immagini all&#039;interno di un blocco html usando il tag per i blocchi {cgsi_convert}.</li>
<li>Altro...</li>
</ul>
<h3>Perch&eacute; usarlo?</h3>
<p>Ci sono quattro motivi molto importanti per utilizzare questo plugin:</p>
<ul>
  <li>Prestazioni: l&#039;utilizzo della incorporamento delle immagini (anche non usando altre funzioni) si traduce in un minor numero di richieste). La maggior parte dei browser effettua dalle due alle quattro richieste simultanee per volta verso lo stesso dominio. Questo pu&ograve; rallentare seriamente pagine web con un alto numero di immagini.</li>
  <li>Prestazioni: anche non usando l&#039;incorporamento, l&#039;invio di grandi immagini ai tuoi visitatori, chiedendo ai loro browser di scalarle, &egrave; molto molto lento.</li>
  <li>Sicurezza: CGSmartImage memorizza in cache le proprie immagini in una cartella separata, nacondendo quindi agli utenti le immagini originali (magari protetto da copyright). Se viene usato l&#039;incorporamento non potranno trovare la posizione originale dell&#039;immagine</li>
  <li>Semplicit&agrave;: le capacit&agrave; di filtraggio di CGSmartImage permettono di elaborare automaticamente le immagini per una loro visualizzazione armoniosa e sicura, senza che gli editori del sito debbano modificarle. Possono caricare immagini pi&ugrave; grandi, ed il tuo sito le tratter&agrave; in modo appropriato.</li>
</ul>
<h3>Come si usa?</h3>
<p>Il modo pi&ugrave; semplice di usare questo modulo &egrave; di collocarlo nello stesso posto in cui avresti collocato il tag {image}.  Ad esempio: qualcosa di simile a <code style=&quot;color: blue;&quot;>{CGSmartImage src=&#039;uploads/images/picture.jpg&#039;}</code>. Questo generer&agrave; il tag immagine senza alcuna elaborazione. E, se possibile, incorporer&agrave; l&#039;immagine direttamente nell&#039;output html.</p>
<p>Spesso si vuole applicare una filigrana alle immagini visualizzate nel frontend per evitarne il furto. Il modulo CGExtensions permette fornisce impostazioni di configurazione delle filigrane che possono essere abilitate per qualsiasi immagine con un tag simile a questo: <code style=&quot;color: blue;&quot;>{CGSmartImage src=&#039;uploads/images/picture.jpg&#039; filter_watermark=1}</code>. Questo provocher&agrave; la lettura dell&#039;immagine, l&#039;applicazione della filigrana secondo le impostazioni di CGExtensions, la memorizzazione in cache dell&#039;immagine alterata, quindi il suo incorporamento nel tuo output</p>
<p>E ancora, fotografie riprese dalle moderne macchine fotografiche digitali sono spesso troppo grandi per poter essere utilizzate in un sito web, quindi devono essere scalate prima di essere visualizzate nella pagina web. Questo si pu&ograve; fare abbastanza facilmente con un tag come: <code style=&quot;color: blue;&quot;>{CGSmartImage src=&#039;uploads/images/picture.jpg&#039; filter_watermark=1 filter_resize=&#039;w,350&#039;}</code>.  Come si pu&ograve; immaginare, la filigrana viene applicata all&#039;immagine prima che questa venga scalata ad una larghezza massima di 300 pixel (mantenendo le proporzioni). Quindi l&#039;immagine adattata verr&agrave; memorizzata in cache, e se il browser lo permette l&#039;immagine verr&agrave; incorporata nell&#039;output HTML. Se l&#039;incorporamento non &egrave; possibile, il tag img conterr&agrave; l&#039;URL all&#039;immagine nella cache.</p>
<p>Ora puoi combinare tra loro le opzioni qui sotto per ottenere molti effetti differenti sulle tue immagini, realizzare semplici gallerie, ed allo stesso tempo migliorare le prestazioni del tuo sito. Divertiti!</p>
<h3>Ridimensionamento immagine automatico</h3>
  <p>Se si specifica un parametro per la larghezza, e/o per l&#039;altezza, e non si specifica il parametro &quot;noautoscale&quot;, il modulo analizzar&agrave; i filtri che hai appena specificato, e se ancora non c&#039;&egrave; nessun filtro di ridimensionamento, aggiunge automaticamente un filtro per ridimensionare o ritagliare adattandola l&#039;immagine nell&#039;output. Questo &egrave; utile per generare automaticamente le miniature sul server, evitando al browser di ridimensionare l&#039;immagine.</p>
 <h3>Una Semplice Galleria</h3>
<p>Il codice sottostante utilizza il modulo {CGSmartImage}, fancybox, e un po&#039; di trucchi smarty per generare un semplice album lightbox da una sottocartella del sito web, elaborando contemporaneamente le immagini secondo gli standard web, e creando le miniature.</p>
<pre style=&quot;background-color: #ddd; border: 1px solid black;&quot;><code><span style=&quot;color: red;&quot;> 1:</span> <script type=&quot;text/javascript&quot;>{literal}
<span style=&quot;color: red;&quot;> 2:</span> jQuery(document).ready(function(){
<span style=&quot;color: red;&quot;> 3:</span>  jQuery(&#039;a.fancybox&#039;).fancybox();
<span style=&quot;color: red;&quot;> 4:</span> });
<span style=&quot;color: red;&quot;> 5:</span> {/literal}</script>
<span style=&quot;color: red;&quot;> 6:</span> {assign var=&#039;files&#039; value=&#039;uploads/album/*.jpg&#039;|glob}
<span style=&quot;color: red;&quot;> 7:</span> {if count($files)}
<span style=&quot;color: red;&quot;> 8:</span> <div style=&quot;width: 100%; height: 150px; overflow: auto;&quot;>
<span style=&quot;color: red;&quot;> 9:</span> {foreach from=$files item=&#039;file&#039;}
<span style=&quot;color: red;&quot;>10:</span>  <a rel=&#039;simple_album&#039; class="fancybox" href="<span style="color: blue;">{CGSmartImage src=$file filter_rotate=90 filter_watermark=1 filter_resize=&#039;h,500&#039; notag=1 noembed=1}</span>&quot;>
<span style=&quot;color: red;&quot;>11:</span>  <span style=&quot;color: blue;&quot;>{CGSmartImage src=$file filter_rotate=90 filter_grayscale=1 filter_watermark=1 filter_resize=&#039;h,150&#039;}</span>
<span style=&quot;color: red;&quot;>12:</span>  </a>
<span style=&quot;color: red;&quot;>13:</span> {/foreach}
<span style=&quot;color: red;&quot;>14:</span> </div>
<span style=&quot;color: red;&quot;>15:</span> {/if}
</code></pre><br/>
<p>Esaminiamolo.</p>
<p>Le righe dalla 1 alla 5 usano jQuery per caricare fancybox mediante ogni link con classe &quot;fancybox&quot;. Il plugin fancybox di jQuery &egrave; incluso nel modulo JQueryTools.</p>
<p>La riga 6 usa una funzione propria di php chiamata glob, ed alcuni trucchi smarty per trovare tutti i file JPG nella cartella uploads/album sotto la cartella principale del sito.</p>
<p>La riga 7 effettua un test per vedere se sono stati effettivamente trovati tutti i file nella linea di assegnazione di cui sopra. Questa istruzione if si chiude alla riga 15.</p>
<p>La riga 8 crea un div per contenere il nostro album. Per gli scopi di questo esempio gli stili sono stati inclusi inline, ma in un ambiente di produzione si dovrebbe usare una classe definita nel foglio di stile. Il tag di chiusura di questo div &egrave; alla riga 14, appena prima di <code>{/if}</code>.</p>
<p>La riga 9 inizia un ciclo su tutti i file trovati nella cartella. Questo ciclo si chiude alla riga 13.</p><br/>
<p>Le righe 10 e 11 fanno il vero prodigio. Qui viene creato un link con classe &quot;fancybox&quot; e viene aggiunto l&#039;attributo <code>rel</code> in modo che fancybox sappia che tutte queste immagini dovranno essere raggruppate insieme come un singolo album e ne permetta lo scorrimento con il click del mouse. Quindi, viene la parte in cui definiamo le nostre immagini.</p>
<p>Forniamo la variabile $file all&#039;argomento src del tag <code>{CGSmartImage}</code> in modo che prenda il nome di ogni jpg trovato durante il ciclo.</p>
<p>Le immagini con le quali ho condotto il test sono state caricate dal mio ipod, e tutte sembravano ruotate di 90 gradi in senso antiorario. Perci&ograve; il primo filtro che ho aggiunto &egrave; stata la rotazione di 90 gradi in senso orario con l&#039;argomento <code>filter_rotate=90</code>. In seguito le immagini necessitavano di una filigrana <em>(&egrave; solo un esempio, non credo proprio che qualcuno ruberebbe per fini commerciali le immagini sfocate del mio ipod)</em>, cos&igrave; ho aggiunto il parametro <code>filter_watermark=1</code>. Ed infine, poich&eacute; anche con l&#039;ipod touch &egrave; possibile scattare foto troppo grandi per essere visualizzate sullo schermo, le ho volute ridimensionare ad una altezza massima di 500 pixels. Questo &egrave; stato fatto con l&#039;argomento <code>filter_resize=h,500</code>. Abbiamo aggiunto l&#039;argomento <code>noembed=1</code> perch&eacute; fancybox non sa visualizzare immagini incorporate nella sua finestra popup. Questo ha definito l&#039;immagine che stavamo collegando.</p>
<p>Poi dobbiamo definire la miniatura dell&#039;immagine che abbiamo intenzione di utilizzare nella galleria. Questo modo di richiamare <code>{CGSmartImage}</code> &egrave; quasi identico al primo modo, tranne che per il fatto che usiamo un differente valore per l&#039;altezza della miniatura (150 pixels), e per divertirmi ho convertito la miniatura in scala di grigi <strong>prima</strong> di applicare la filigrana. Ho anche rimosso l&#039;argomento noembed=1 in modo che il sistema possa incorporare l&#039;immagine nell&#039;output HTML per i browser compatibili. L&#039;istantanea dello schermo qui sotto mostra il risultato.</p>
<img src=&quot;data:image/jpeg;base64,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&quot; alt=&quot;Il tuo browser non &egrave; compatibile con le immagini incorporate, mi spiace&quot;/>
<h3>Fogli di Stile:</h3>
<p>Questo modulo funziona anche con i flogli di stile, se si usa il tag {cms_stylesheet} nel modello della pagina. Poich&eacute; la sintassi di smarty &egrave; leggermente diversa all&#039;interno del tag {cms_stylesheet} si utilizza il modulo usando i delimitatori  [[ e ]].  Ovvero: <code style=&quot;color: blue;&quot;>div.header { background: url([[CGSmartImage src=&#039;uploads/picture.jpg&#039; notag=1]]); }</code></p>
<p>A causa del fatto che i fogli di stile vengono generati dopo la loro modificati e memorizzati nel filesystem non vi &egrave; alcun modo per determinare durante la richiesta quale browser sta richiedendo il foglio di stile, perci&ograve; l&#039;incorporamento verr&agrave; effettuato basandosi strettamente sulla rilevazione anticipata del parametro noembed. Se si &egrave; deciso di incorporare le immagini direttamente nei folgi di stile, potrebbe essere necessario aggiungere assistenza addizionale per i fogli di stile per i browser non compatibili con le immagini incorporate. Ovvero:  IE6.</p>
<h3>Elaborazione automatica</h3>
<p>Questo modulo include un tag di blocco smarty chiamato <code style=&quot;color: blue;&quot;>{cgsi_convert}</code> che pu&ograve; racchiudere un blocco html, o altri tag smarty per consentire l&#039;elaborazione automatica delle immagini. Questo tag pu&ograve; essere usato in questo modo: (ad esempio):</p>
<pre><code style=&quot;color: blue;&quot;>{cgsi_convert}{content}{/cgsi_convert}</code></pre>
<p>Questo permetter&agrave; agli utenti di includere immagini nelle pagine usando i normali strumenti wysiwyg, processandole  ed incorporandole automaticamente nella pagina utilizzando la magia di {CGSmartImage}.  Esempio: Vedi il seguente codice:</p>
<pre><code style=&quot;color: blue;&quot;>{cgsi_convert filter_grayscale=1 filter_watermark=1}{content}{/cgsi_convert}</code></pre>
<p>Il codice qui sopra catturer&agrave; tutti i tag immagine, e le convertir&agrave; in scala di grigio, quindi applicher&agrave; la filigrana (secondo le impostazioni presenti nel modulo CGExtensions). Tutti i parametri disponibili nel tag <code style=&quot;color: blue;&quot;>{CGSmartImage}</code> sono disponibili in questo tag (per la scalatura delle immagini ecc.). In pi&ugrave;, sono stati introdotti due nuovi parametri: <strong>max_width</strong> e <strong>max_height</strong> che possono essere usati per impostare la grandezza massima delle immagini.</p>
<div style=&quot;margin-left: 3em;&quot;><strong style=&quot;color: red;&quot;>Nota:</strong>
<p>Questo tag analizza il contenuto HTML compreso tra i tag di inizio e fine per trovare i tag <img>. Quindi generer&agrave; un output HTML sintatticamente valido per il sottoinsieme di codice previsto.  Pertanto &egrave; importante che il frammento di HTML passato al tag essere intatto e il pi&ugrave; vicino possibile ai valide. Pertanto &egrave; importante che il frammento di HTML passato al tag sia il pi&ugrave; intatto e valido possibile.  <strong>Usare con cautela.</strong>
</div>
<h3>Assistenza</h3>
<p>Questo modulo non include assistenza commerciale. Comunque, sono disponibili numerose risorse di aiuto:</p>
<ul>
<li>Per l&#039;ultima versione di questo modulo, FAQs, o per segnalare un Bug o per acquistare assistenza commerciale, sei pregato di visitare l&#039;home page del modulo di calguy a <a href="http://calguy1000.com">techcom.dyndns.org</a>.</li>
<li>Ulteriori discussioni su questo modulo possono essere trovate nei <a href="http://forum.cmsmadesimple.org">Forum di CMS Made Simple</a>.</li>
<li>L&#039;autore, calguy1000, pu&ograve; essere raggiunto spesso nel <a href="irc://irc.freenode.net/#cms">canale IRC CMS</a>.</li>
<li>Infine, pu&ograve; anche darsi che l&#039;autore risponda ad una richiesta diretta via email.</li>  
</ul>
<h3>Requisiti</h3>
<p>Per la manipolazione delle immagini, questo modulo fa largo uso della libreria GD per l&#039;elaborazione delle immagini.  In aggiunta, il plugin {cgsi_convert} usa in modo esteso le classi simplexml  e XMLDom proprie di php. Possono essereci altri requisiti supplementari. In caso di errori, assicurati che la segnalazione degli errori sia abilitata, e di aver analizzato i tuoi file di log. degli errori.</p>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2008, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org"><calguy1000@cmsmadesimple.org></a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>';
$lang['info_aliases'] = 'Gli alias possono essere usati nel tag CGSmartImage, dall&#039;opzione alias1 all&#039;alias5, per combinare tra loro opzioni usate di frequente';
$lang['info_croptofit_default_loc'] = 'Specificare la posizione predefinita da cui &quot;Ritagliare ed Adattare&quot;; avr&agrave; effetto su tutte le operazioni di ritaglio ed adattamento se non diversamente specificato nel parametro di posizionamento dell&#039;attributo del filtro filter_croptofit. La posizione predefinita &egrave; &quot;center&quot;';
$lang['image_url_hascachedir'] = 'L&#039;URL qui sopra tiene conto della cartella cache (_CGSmartImage)';
$lang['image_url_prefix'] = 'Prefisso URL Immagine';
$lang['info_cache_age'] = 'Specificare l&#039;et&agrave; massima di un file (in giorni) prima che sia rimosso e rigenerato. Questo &egrave; utile nel caso in cui siano stati modificati alcuni dei parametri usati nella generazione delle immagini, oppure per controllare la quota di spazio disco usato. Impostando 0 la cancellazione automatica del file &egrave; disabilitata';
$lang['info_embed_mode'] = 'Questa selezione determina il modo in cui il tag {smartimg} generer&agrave; l&#039;output. Se viene selezionato &quot;none&quot; non verr&agrave; eseguita nessuna incorporazione dell&#039;immagine. Selezionando &quot;smart&quot; il sistema decider&agrave; in base alla grandezza dell&#039;immagine, al tipo, ed al browser che sta richiedendo l&#039;immagine. Le altre opzioni includono sempre l&#039;incorporamento basato sulla grandezza dell&#039;immagine, o il tipo di immagine.';
$lang['info_embed_sizelimit'] = 'Se l&#039;opzione di incorporamento &egrave; determinata dalla grandezza dell&#039;immagine, specificare la grandezza massima delle immagini da incorporare (in  kilobytes. Raccomandato 32).';
$lang['info_embed_types'] = 'Se l&#039;opzione di incorporamento &egrave; determinata dal tipo di immagine, specificare qui le estensioni dei file da incorporare, separate da virgola. Questa opzione non fa distinzione tra maiuscole e minuscole.';
$lang['info_image_url_hascachedir'] = 'Se la propria CDN punta direttamente alla cartella cache delle immagini, si potrebbe voler attivare questa opzione.';
$lang['info_image_url_prefix'] = 'Specificare l&#039;URL da anteporre a tutte le immagini generate. L&#039;URL di uploads &egrave; l&#039;impostazione predefinita, comunque se si ha una propria CDN (o domini multipli che puntano alla stessa cartella), si potrebbe voler specificare un nome diverso.';
$lang['max_cache_age'] = 'Et&agrave; massima dei file nella cache (giorni)';
$lang['moddescription'] = 'Modulo per CMSMS per la generazione intelligente del tag image';
$lang['msg_aliases_updated'] = 'Alias Aggiornati';
$lang['msg_cachecleaned'] = 'Cartella Cache pulita. Rimossi %d file';
$lang['msg_cacheremoved'] = 'Cache Rimossa';
$lang['msg_prefsupdated'] = 'Preferenze Aggiornate';
$lang['none'] = 'Nessuno';
$lang['options'] = 'Opzioni';
$lang['param_alias'] = 'Il pannello di amministrazione CGSmartImage consente la creazione di numerosi alias di comando per combinare in un unico nome argomenti usati di frequente. Per utilizzare questi alias, usare un argomento del modulo alias##=alias_name, come alias1=foo alias2=foo.';
$lang['param_alt'] = 'Usato nella creazione di un tag img, specifica il valore dell&#039;attributo alt. Nota: se non specificato, sar&agrave; automaticamente calcolato un valore per questo attributo per consentire la validazione della maggior parte dei tag img. &Egrave; possibile inibire questo automatismo mediante il parametro &quot;noauto&quot;';
$lang['param_class'] = 'Usato nella creazione di un tag img, permette di specificare una o pi&ugrave; classi da includere nel tag. Ad esempio: class=&quot;fancybox,thumbnail&quot;';
$lang['param_filter_blur'] = '(qualsiasi) Specificare un valore per questo parametro per aggiungere un filtro sfocatura all&#039;immagine';
$lang['param_filter_brightness'] = '(intero) Aumenta la luminosit&agrave; dell&#039;immagine elaborata del valore intero specificato';
$lang['param_filter_colorize'] = '(r,g,b[,alpha]) - Come filter_grayscale &egrave; comunque possibile specificare il colore ed il valore alfa';
$lang['param_filter_contrast'] = '(intero) Modifica il contrasto dell&#039;immagine in base all&#039;intero specificato';
$lang['param_filter_crop'] = '(percentuale[,h_align,v_align]) - Effettua il ritaglio dell&#039;immagine specificata. I valori per il ritaglio sono specificati come una lista di parametri separati da virgola. Il primo valore (richiesto) &egrave; un intero percentuale della grandezza originale dell&#039;immagine. Il secondo ed il terzo parametro, opzionali, sono relativi a l,c,r (left,center,right) e t,c,b (top,center,bottom) e specificano il punto dell&#039;immagine da cui iniziare il ritaglio. Esempio: crop=33,b,r per effettuare un ritaglio del33% partendo dal margine inferiore destro dell&#039;immagine originale.';
$lang['param_filter_croptofit'] = '(larghezza,altezza,[,posizione]) - Effettua un ritaglio ed un adattamento dell&#039;immagine specificata. Tenta di scalare l&#039;immagine alla grandezza desiderata mantenendone il rapporto tra larghezza ed altezza, quindi focalizza l&#039;area selezionata dell&#039;immagine scalata. Parametri di ritaglio ed adattamento sono specificati come larghezza ed altezza desiderate per l&#039;immagine finale, insieme con un codice (opzionale) di posizione. Codici di posizione validi sono tl,tc,tr,cl,c,cr,bl,b,br relativi alle 9 posizioni all&#039;interno dell&#039;immagine. Se una posizione non viene specificata verr&agrave; usata una preferenza. Il valore predefinito &egrave; &quot;c&quot; per ritagliare-ed-adattare partendo dal centro dell&#039;immagine originale. Questo filtro non eseguir&agrave; in nessun caso un ingrandimento (upscaling).';
$lang['param_filter_edgedetect'] = '(niente) Evidenzia i bordi dell&#039;immagine';
$lang['param_filter_emboss'] = '(niente) Applica un rilievo all&#039;immagine';
$lang['param_filter_flip'] = '(mode) - Riflette l&#039;immagine specificata. Specificare 0 per orizzonatle, 1 per verticale, e 2 per riflettere in entrambe le direzioni.';
$lang['param_filter_grayscale'] = '(niente) Converte l&#039;immagine in scala di grigio';
$lang['param_filter_meanremoval'] = '(niente) Tenta di ottenere un effetto &quot;Schizzo&quot;';
$lang['param_filter_negate'] = '(niente) Rende l&#039;immagine in negativo';
$lang['param_filter_pixelate'] = '(grandezza[,avanzato]) Effetto pixel sull&#039;immagine, specificare una grandezza intera ed un booleano opzionale (il predefinito &egrave; false) per abilitare un effetto pixel avanzato';
$lang['param_filter_resize'] = 'tipo,numero[,numero] - Ridimensiona l&#039;immagine originale. Il filtro di ridimensionamento non effettua nessun controllo di ingrandimento.
I possibili valori sono:
<ul>
  <li>p,numero - Esegue un ridimensionamento semplice ad una determinata percentuale. Esempio: resize=p,50 per ridurre del 50% la grandezza originale</li>
  <li>w,numero - Esegue il ridimensionamento alla larghezza specificata (mantenendo il rapporto tra larghezza ed altezza). Esempio: resize=w,80 per creare una miniatura con larghezza massima di 80 pixel.</li>
  <li>h,numero - Esegue il ridimensionamento all&#039;altezza specificata (mantenendo il rapporto tra larghezza ed altezza). Esempio: resize=h,80 per creare una miniatura con altezza massima di 80 pixel.</li>
  <li>e,numero - Esegue il ridimensionamento impostando il lato maggiore al valore specificato (mantenendo il rapporto tra larghezza ed altezza). Esempio: resize=e,100 per creare una miniatura il cui lato maggiore sia di 100 pixel.
  <li>c,x,y - Esegue il ridimensionamento ad una grandezza personalizzata (senza mantenere il rapporto tra larghezza ed altezza). Esempio: filter_resize=c,50,75 per creare una miniatura di 50x75 pixel.</li>.
</ul>';
$lang['param_filter_resizetofit'] = '(larghezza,altezza[,colore[,trasparenza]]) - Esegue un ridimensionamento dell&#039;immagine specificata. Tenta di scalare l&#039;immagine alla grandezza di destinazione specificata mantenendone il rapporto tra larghezza ed altezza, l&#039;immagine &egrave; centrata rispetto all&#039;area specificata (orizzontalmente o verticalmente in base al rapporto larghezza/altezza ed alla grandezza finale), e circondata dal colore specificato. I colori possono essere specificati per nome (vedere i nomi di colore X11), o con il formato esadecimale #nnnnnn, o come valori rgb separati da : Esempio: filter_croptofit=600,400,#ff0000. Il valore speciale &quot;transparent&quot; pu&ograve; essere specificato per forzare uno sfondo trasparente. Il valore alpha pu&ograve; variare tra 0 e 127 per specificare vari gradi di trasparenza dello sfondo. Questo filtro non eseguir&agrave; in nessun caso un ingrandimento (upscaling).';
$lang['param_filter_rotate'] = '(angolo) Specificare un angolo intero (in senso antiorario) per ruotare l&#039;immagine. L&#039;immagine viene ruotata sul suo centro.';
$lang['param_filter_roundedcorners'] = '(radiale) Specificare un valore radiale intero (in pixel) per arrotondare gli angoli.';
$lang['param_filter_watermark'] = '(ninete), Impostare l&#039;applicazione della filigrana all&#039;immagine (come specificato nel pannello di amministrazione di CGExtensions )';
$lang['param_height'] = 'Usato nella creazione di un tag img, specifica il valore per l&#039;attributo height . Nota, se non viene specificato un valore, ne verr&agrave; calcolato automaticamente uno per questo attributo in modo che la maggior parte dei tag img siano validati.
 &Egrave; possibile sovrascrivere questo calcolo automatico mediante il parametro &quot;noauto&quot;. Questo parametro sar&agrave; inoltre usato insieme con il parametro &quot;width&quot; per effettuare un ridimensionamento finale o un filtro di ritaglio ed adattamento (a meno che non sia stato specificato anche il parametro &quot;noautoscale&quot; )';
$lang['param_id'] = 'Usato nella creazione di un tag img, permette di specificare un attributo id da includere nel tag. Esempio: id=&quot;tuoid&quot;';
$lang['param_max_height'] = 'Applicabile solo al tag  {cgsi_convert}, questo parametro permette si specificare un&#039;altezza massima per le immagine convertite';
$lang['param_max_width'] = 'Applicabile solo al tag  {cgsi_convert}, questo parametro permette si specificare una larghezza massima per le immagine convertite';
$lang['param_name'] = 'Usato nella creazione di un tag img,  specifica il valore dell&#039;attributo name.';
$lang['param_noauto'] = 'Non calcolare automaticamente i parametri per il tag img. Questo pu&ograve; comportare la mancata validazione del sito nel caso in cui alcuni parametri richiesti (width,height,alt) non siano specificati';
$lang['param_noautoscale'] = 'Se sono specificati i parametri width e height, questo parametro disabiliter&agrave; la scalatura automatica dell&#039;immagine.';
$lang['param_nobcache'] = 'Non permette la memorizzazione nella cache del browser dell&#039;immagine ridimensionata (utile in fase di sviluppo), aggiunge un numero univoco come parametro dell&#039;immagine che forzer&agrave; il browser a non memorizzarla nella cache.';
$lang['param_noembed'] = 'Forza la non inclusione dell&#039;immagine. Indipendentemente dalle impostazioni nel pannello di amministrazione, l&#039;URL ed il tag generati punteranno ad un file sul server. Nessuna inclusione (embedding) sar&agrave; eseguita';
$lang['param_notimecheck'] = 'Disabilitare il controllo temporale dei file nella cache.';
$lang['param_noremote'] = 'Non permettere il recupero di fonti da URL remoti';
$lang['param_norotate'] = 'Non tentare di leggere le informazioni exif dal file e correggere la rotazione immagine';
$lang['param_notag'] = 'Non generare un tag img, solo l&#039;url dell&#039;immagine memorizzata nella cache. Questo non ha alcun effetto se CGSmartImage viene utilizzato all&#039;interno di un foglio di stile.';
$lang['param_overwrite'] = 'Disattivare la memorizzazione nella cache e forzare il ricalcolo di tutti i filtri';
$lang['param_quality'] = 'Specificare la qualit&agrave; dell&#039;immagine prodotta. Un valore tra 0 e 100. Il valore predefinito, se non specificato, &egrave; di 75.';
$lang['param_rel'] = 'Usato durante la creazione di un tag di immagine permette di specificare un attributo opzionale rel (in genere utilizzato con gli album di tipo javascript). Esempio: rel=&quot;album&quot;';
$lang['param_silent'] = 'Ignorare silenziosamente gli errori';
$lang['param_src'] = 'Specificare l&#039;origine per l&#039;elaborazione delle immagini (se presente) o il tag img generato. Nota, questo parametro &egrave; flessibile, e il modulo tenter&agrave; molti metodi per trovare il file immagine sorgente sul server web come segue:
<ul>
   <li> Prima controlla se il valore src specificato corrisponde ad un file esistente nel filesystem.</ li>
   <li>In seguito, verifica se il valore specificato per il parametro src &egrave; un URL e inizia con uploads_url (come specificato nel config.php)</ li>
   <li>Poi, verifica se il valore specificato per il parametro src &egrave; un URL e inizia con root_url (come specificato nel config.php)</ li>
   <li>Quindi, verifica se il valore specificato per il parametro src &egrave; un URL e inizia con ssl_url (come specificato nel config.php)</ li>
</ ul>
 &Egrave; anche possibile suddividere il parametro src in pi&ugrave; argomenti, il che &egrave; utile per esempio quando il percorso del file e il nome del file sono memorizzati in variabili smarty separate. &Egrave; possibile specificare src come src1 = \ $ the_path src2 = \ $ the_filename. Il sistema aggiunge automaticamente un / tra ogni argomento. Non vi &egrave; alcun limite al numero di parametri src.';
$lang['param_style'] = 'Usato durante la creazione di un tag img, permette di specificare gli stili alternativi per il tag. Esempio: style = &quot;border: 1px solid black;&quot;';
$lang['param_title'] = 'Specificare un attributo opzionale title per il tag img. Esempio: title=&quot;Questo &egrave; il tooltip&quot;';
$lang['param_width'] = 'Usato durante la creazione di un tag img, specifica il valore per l&#039;attributo width. Nota, se non viene specificato un valore, ne verr&agrave; calcolato automaticamente uno per questo attributo in modo che la maggior parte dei tag img siano validati. &Egrave; possibile sovrascrivere questo calcolo automatico mediante il parametro &quot;noauto&quot;. Questo parametro sar&agrave; inoltre usato insieme con il parametro &quot;height&quot; per effettuare un ridimensionamento finale o un filtro di ritaglio ed adattamento (a meno che non sia stato specificato anche il parametro &quot;noautoscale&quot; )';
$lang['postinstall'] = 'Modulo installato';
$lang['postuninstall'] = 'Tutti i dati associati a questo modulo sono stati rimosssi';
$lang['prompt_croptofit_default_loc'] = 'Punto predefinito dal quale effettuare un riditaglio ed adattamento (&quot;crop to fit&quot;)';
$lang['prompt_embed_sizelimit'] = 'Basato sulla grandezza dell&#039;immagine';
$lang['prompt_embed_smartlimited'] = 'Modalit&agrave; Intelligente ma limita la dimensione dell&#039;immagine';
$lang['prompt_embed_type'] = 'Basato sul tipo di immagine';
$lang['prompt_loc_bottomleft'] = 'In Basso a Sinistra (bl)';
$lang['prompt_loc_bottomcenter'] = 'In Basso al Centro (bc)';
$lang['prompt_loc_bottomright'] = 'In Basso a Destra (br)';
$lang['prompt_loc_centerleft'] = 'Centro Sinistra (cl)';
$lang['prompt_loc_center'] = 'Centro (c)';
$lang['prompt_loc_centerright'] = 'Centro Destra (cl)';
$lang['prompt_loc_topleft'] = 'In Alto a Sinistra (tl)';
$lang['prompt_loc_topcenter'] = 'In Alto al Centro (tc)';
$lang['prompt_loc_topright'] = 'In Alto a Destra (tr)';
$lang['resizing'] = 'Ridimensionamento';
$lang['smart'] = 'Intelligente';
$lang['submit'] = 'Invia';
$lang['utma'] = '156861353.1909536516.1358165232.1358165232.1358165232.1';
$lang['utmz'] = '156861353.1358165232.1.1.utmccn=(direct)|utmcsr=(direct)|utmcmd=(none)';
$lang['qca'] = '1209917266-36464638-3168787';
$lang['utmb'] = '156861353';
$lang['utmc'] = '156861353';
?>