<script type="text/javascript">
$(document).ready(function(){
  var _tabs = [];
  {foreach $senders as $key => $val}
  _tabs.push('{$key}');
  {/foreach}

  $('#tabwrap').tabs();
  
  // disable all but the first tab.
  var n = $('#tablist > li').length;

  // enable only selected tabs.
  $('#senders').change(function(){
    var x = [];
    for( var i = 1; i < n - 1; i++ ) { x.push(i); }
    $('#tabwrap').tabs('option','disabled',x);

    $('option:selected',this).each(function(){
      var v = $(this).val();
      var i = _tabs.indexOf(v)+1;
      $('#tabwrap').tabs('enable',i);
    });
  });
  $('#senders').trigger('change');

  $('textarea').on('keyup',function(){
   var n = $(this).val().length;
   var el_max = $(this).prevAll('.charlimit');
   var el_num = $(this).prevAll('.charcount');
   if( typeof el_num != 'undefined' ) {
     var out = n;
     if( typeof el_max != undefined ) {
       var max = $(el_max).html();
       if( n >= max ) {
         out = '<span style="color: red;">'+n+'</span>';
       } else if( n / max > 0.85 ) {
         out = '<span style="color: orange;">'+n+'</span>';
       }
     }
     $(el_num).html(out);
   }
  });
  $('textarea').trigger('keyup'); // trigger a keyup
});
</script>
<h3>{$mod->Lang('send_message')}</h3>
{if isset($module)}
<h4>{$mod->Lang('blast_article_from',$module)} {if $source_data->title}: {$source_data->title}{/if}</h4>
{/if}

{$formstart}
<div class="pageoverflow">
  <p class="pagetext"></p>
  <p class="pageinput">
    <input id="submit" type="submit" name="{$actionid}submit" value="{$mod->Lang('submit')}"/>
    <input type="submit" name="{$actionid}cancel" value="{$mod->Lang('cancel')}"/>
  </p>
</div>

<div id="tabwrap">
  <ul id="tablist">
    <li><a href="#tab_main">{$mod->Lang('main')}</a></li>
    {foreach $senders as $one=>$name}
    <li><a href="#tab_{$one}">{$name}</a></li>
    {/foreach}
    <li><a href="#tab_help">{$mod->Lang('help')}</a></li>
  </ul>
  <div id="tab_main">
    <div class="pageoverflow">
      <p class="pagetext"><label for="senders">{$mod->Lang('destinations')}:</label></p>
      <p class="pageinput">
        <table>
          <tr>
            <td valign="top">
            <select id="senders" name="{$actionid}senders[]" multiple="multiple" size="3">
            {html_options options=$senders selected=$saved_senders}
            </select>
            </td>
            <td valign="top">{$mod->Lang('info_senders')}</td>
          </tr>
        </table>
      </p>
    </div>
  </div>
  {foreach $senders as $one => $name}
    {$info=$sender_info[$one]}
    <div id="tab_{$one}" class="sender_tab">
      {* this defines the messaging tab *}
      {if $info.info_message}<div class="information">{$info.info_message}</div>{/if}
      <div class="pageoverflow">
        <p class="pagetext">{$mod->Lang('message')}:</p>
        <p class="pageinput"> 
          {if $info.charlimit > 0}{$mod->Lang('character_count')}: <span class="charcount">0</span> / <span class="charlimit">{$info.charlimit}</span><br/>{/if}
          <textarea name="{$actionid}{$one}_msg" rows="3" cols="50"{if $info.charlimit} maxlength="{$info.charlimit}"{/if}>{$sender_msgs.$one}</textarea>
        </p>
      </div>
      {if $info.picture && $source_data->count_pictures()}
        <div class="pageoverflow">
          <p class="pagetext">{$mod->Lang('picture')}:</p>
          <p class="pageinput">
            <select class="picture_dropdown" name="{$actionid}{$one}_picture">
            {html_options options=$source_data->pictures}
            </select>
          </p>
        </div>
      {/if}

      {if $info.link && $source_data->canonical }
        <div class="pageoverflow">
          <p class="pagetext">{$mod->Lang('link')}:</p>
          <p class="pageinput">
            <input type="texT" name="{$actionid}{$one}_link" value="{$source_data->canonical}" size="80"/>
          </p>
        </div>
        {if $info.linktitle}
          <div class="pageoverflow">
            <p class="pagetext">{$mod->Lang('link_title')}:</p>
            <p class="pageinput">
              <input type="text" name="{$actionid}{$one}_linkname" value="{$source_data->title}" size="80"/>
            </p>
          </div>
        {/if}
        {if $info.caption}
          <div class="pageoverflow caption_wrap">
            <p class="pagetext">{$mod->Lang('link_caption')}:</p>
            <p class="pageinput">
              <input type="text" class="caption" name="{$actionid}{$one}_caption" value="" size="80"/>
            </p>
          </div>
        {/if}
        {if $info.description}
          <div class="pageoverflow description_wrap">
            <p class="pagetext">{$mod->Lang('link_description')}:</p>
            <p class="pageinput">
              <input type="text" class="description" name="{$actionid}{$one}_description" value="" size="80" maxlength="255"/>
            </p>
          </div>
        {/if}
      {/if}
    </div>
  {/foreach}
  <div id="tab_help">
    <div class="information" style="display: block;">{$mod->Lang('info_messagebox_smarty')}</div>
    <table class="pagetable">
      <thead>
        <tr>
          <th width="25%">{$mod->Lang('variable')}</th>
          <th>{$mod->Lang('description')}</th>
        </tr>
      </thead>
      <tbody>
        <tr><td valign="top">{ldelim}$input_data->title{rdelim}</td><td>{$mod->Lang('srcdata_title')}</td></tr>
        <tr><td valign="top">{ldelim}$input_data->summary{rdelim}</td><td>{$mod->Lang('srcdata_summary')}</td></tr>
        <tr><td valign="top">{ldelim}$input_data->canonical{rdelim}</td><td>{$mod->Lang('srcdata_canonical')}</td></tr>
        <tr><td valign="top">{ldelim}$input_data->pictures{rdelim}</td><td>{$mod->Lang('srcdata_pictures')}</td></tr>
        <tr><td valign="top">{ldelim}$input_data->links{rdelim}</td><td>{$mod->Lang('srcdata_links')}</td></tr>
      </tbody>
    </table>
  </div>
</div>{* #tabwrap *}
{$formend}