<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: SocialBlaster (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to facilitate blasting information to multiple social networks
#  at once.  Requires inedividial modules to handle the actual posting to social modules.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class sb_utils 
{
  private function __construct() {}

  public static function get_feeders()
  {
    $mod = cms_utils::get_module(MOD_CGSOCIALBLASTER);
    $hostmodules = $mod->GetModulesWithCapability('cg_socialblast_feeder');
    return $hostmodules;
  }

  public static function get_senders()
  {
    $mod = cms_utils::get_module(MOD_CGSOCIALBLASTER);
    $blastmodules = $mod->GetModulesWithCapability('cg_socialblast_sender');
    return $blastmodules;
  }

  public static function get_sender_info()
  {
    $tmp = self::get_senders();
    if( is_array($tmp) && count($tmp) ) {
      $out = array();
      foreach( $tmp as $one ) {
	$mod = cms_utils::get_module($one);
	if( !is_object($mod) ) continue; // weird, but okay...
	if( !method_exists($mod,'get_sender_info') ) continue; // oops, improper implementation.
	$res = $mod->get_sender_info();
	if( !is_object($res) ) continue; // weird.
	$out[$res['module']] = $res;
      }
      if( is_array($out) && count($out) ) return $out;
    }
  }

  public static function get_sender_list()
  {
    $senders = self::get_sender_info();
    if( is_array($senders) && count($senders) ) {
      $list = array();
      foreach( $senders as $one ) {
	$list[$one['module']] = $one['socialname'];
      }
      return $list;
    }
  }
}
#
# EOF
#
?>