<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: SocialBlaster (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to facilitate blasting information to multiple social networks
#  at once.  Requires inedividial modules to handle the actual posting to social modules.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class sb_sender_info implements ArrayAccess
{
  private $_data = array();

  public function __construct($module,$socialname,$charlimit,$picture = 0)
  {
    $this->_data['module'] = $module;
    $this->_data['socialname'] = $socialname;
    $this->_data['charlimit'] = (int)$charlimit;
    $this->_data['picture'] = $picture; // bool
    $this->_data['linktitle'] = 0; // bool
    $this->_data['link'] = 0; // bool
    $this->_data['caption'] = 0; // bool
    $this->_data['description'] = 0; // bool
    $this->_data['info_message'] = ''; // string
  }

  public function OffsetGet($k)
  {
    switch( $k ) {
    case 'module':
    case 'socialname':
    case 'charlimit':
    case 'linktitle':
    case 'picture':
    case 'info_message':
    case 'link':
    case 'caption':
    case 'description':
      return $this->_data[$k];

    default:
      throw new Exception("Invalid key $k for sb_sender_info object");
    }
  }

  public function OffsetSet($k,$v)
  {
    switch( $k ) {
    case 'module':
    case 'socialname':
    case 'linktitle':
    case 'picture':
    case 'info_message':
    case 'link':
    case 'caption':
    case 'description':
      $this->_data[$k] = trim($v);
      break;

    case 'charlimit':
      $this->_data[$k] = (int)$v;
      break;

    default:
      throw new Exception("Invalid key $k for sb_sender_info object");
    }
  }

  public function OffsetExists($k)
  {
    switch( $k ) {
    case 'module':
    case 'linktitle':
    case 'info_message':
    case 'picture':
    case 'socialname':
    case 'charlimit':
    case 'link':
    case 'caption':
    case 'description':
      return isset($this->_data[$k]);

    default:
      throw new Exception("Invalid key $k for sb_sender_info object");
    }
  }

  public function OffsetUnset($k)
  {
    return; // do nothing.
  }

}

#
# EOF
#
?>