<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: SocialBlaster (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to facilitate blasting information to multiple social networks
#  at once.  Requires inedividial modules to handle the actual posting to social modules.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

/**
 * A simple class that describes the information returned by a module for CGSocialBlaster to blast out
 * this is usually some information from a blog article or a news article
 *
 * This information is then used in the blast form to fill out the default form values for sending data to the various social media
 * platforms.  Some social media platforms may use different fields, or combine them.
 *
 * Public members:
 *  title: - (string) A title for the object being shared.
 *  canonical: - (string) A canonical URL to the object being shared.
 *  summary: (string) Some text describing the object (note, different media platforms have different limits on the number of characters that can be sent.
 *  pictures: (array of names and URLs) to images.  The CGSocialBlaster module will allow the administrator to choose one image to attach to the social media post (if the platform supports it).
 *
 * Public methods:
 *   add_picture($url,$name) - Adds a picture to the sb_content object... note, duplicates are not permitted.
 *   count_pictures() - Returns a count of the pictures added to the object
 */
final class sb_content
{
  private $_title;
  private $_linktitle;
  private $_summary;
  private $_canonical;
  private $_pictures = array();

  public function __get($key)
  {
    switch($key) {
    case 'title':
    case 'linktitle':
    case 'summary':
    case 'pictures':
    case 'canonical':
      $key = '_'.$key;
      return $this->$key;
      break;

    case 'canonical_short':
      $key = '_canonical';
      $tmp = ModuleOperations::get_modules_with_capability('shorten_url');
      if( !is_array($tmp) || count($tmp) == 0 ) return $this->$key;
      foreach( $tmp as $name ) {
	$mod = cms_utils::get_module($name);
	if( !$mod ) continue;
	return $mod->shorten_url($this->$key);
      }
      break;

    default:
      throw new CmsInvalidDataException($key.' is an invalid member for a '.get_class($this));
    }
  }

  public function __set($key,$val)
  {
    switch($key) {
    case 'title':
    case 'linktitle':
    case 'summary':
    case 'canonical':
      $key = '_'.$key;
      $this->$key = trim($val);
      break;

    case 'pictures':
      if( !is_array($val) || count($val) == 0 ) throw new CmsInvalidDataException('pictures must be a hash of name and url');
      $this->pictures = $val;
      break;

    default:
      throw new CmsInvalidDataException($key.' is an invalid member for a '.get_class($this));
    }
  }

  public function add_picture($url,$name)
  {
    $url = trim($url);
    $name = trim($name);
    if( !startswith($url,'http') && !startswith($url,'ftp:') ) {
      throw new CmsInvalidDataException('Invalid URL passed to sb_content->add_picture');
    }
    if( $name == '' ) throw new CmsInvalidDataException('Invalid picture name passed to sb_content->add_picture');
    $this->_pictures[$url] = $name;
  }

  public function count_pictures()
  {
    return count($this->_pictures);
  }
} // end of class

#
# EOF
#
?>