<h3>What does this do?</h3>
  <p>This module allows an authorized administrator to easily share blog articles, and other objects to one or more social media networks at the same time.</p>
  <p>This mdoule interfaces with &quot;Sender&quot; modules and &quot;Media&quot; modules, provides a smarty tag, and an administrator interface to allow sharing details about an object such as a blog article with different social media networks.</p>
  <p>
<h3>Features</h3>
  <ul>
  <li>Template controlled default values for post messages.</li>
  <li>Provides the ability to customize the message (and possibly picture and link) for each social network.</li>
  <li>Smarty tag supports overriding the default values for message content.</li>
  <li>Supports attaching a picture, and a link (with name, description, and caption) to facebook. <em>Uses the CGFBPost module for this.</em></li>
  <li>Provides a test interface.</li>
  <li>More</li>
  </ul>
<h3>Requirements:</h3>
  <ul>
   <li>At least one configured, and installed Sender module <em>(like CGBlog).</em>
   <li>At least one configured and installed Media module <em>(like CGFBApp, or CGTWeet).</em>
  </ul>
<h3>How do I Use it?</h3>
  <ol>
    <li>Install and configure your Sender modules:
       <p>In the case of CGBlog you will need to create and configure your default templates, pretty urls, and navigation for blog articles, and create at least one published blog article.</p>
     </li>
     <li>Install and configure your Media modules:
       <p>CGTweet and CGFBPost are examples of working media modules.  Each of these modules has their own installation and configuration requirements.</p>
     </li>
     <li>Give authorized user groups the &quot;Blast to Social Media&quot; Permission.</li>
     <li>Go to the admin panel of the sender module and look for the &quot;Share&quot; icon link on each item that can be shared.
      <p>Clicking on that link should display a form which allows you to select which media networks to send to, and to customize the content for each message.</p>
     </li>
  </ol>
<h3>Creating a Sender Module</h3>
  <p><strong>Note:</strong> I also refer to a &quot;Sender&quot; module as a &quot;Feeder&quot; module, as it feeds information to CGSocialBlaster.</p>
  <p>Creating a sender module is a 3 step process for experienced CMSMS developers:</p>
  <ol>

    <li>Override the <span style="color: blue;">HasCapability</span> method in your module class to return true for the <span style="color: blue;">'cg_socialblast_feeder'</span> capability. i.e:
<pre><code>public function HasCapability($capability, $params = array()) {
&nbsp;&nbsp;  if( $capability == 'cg_socialblast_feeder' ) return TRUE;
&nbsp;&nbsp;  return FALSE;
}</code></pre>
    </li>
 
    <li>Add a <span style="color: blue;">get_blaster_content</span> method to your module that, given an integer id for an item returns an <span style="color: blue;">sb_content</span> object.  i.e:
<pre><code>public function &get_blaster_content($articleid) {
&nbsp;&nbsp;$content = new sb_content;
&nbsp;&nbsp;$content->summary = 'The initial content for my message';
&nbsp;&nbsp;return $content;
}</code></pre>
<p><strong>Note:</strong> the sb_content object is a intended to be a generic object that holds data suitable for many social networks.  Although you should try to complete the object as much as possible, it is also possible that some Media modules may not use all of the data provided in this object.</p>
<p>For reference to the sb_content object see the <span style="color: blue;">lib/class.sb_content.php</span> file included with the module.</p>
    </li>

    <li>Add the smarty tag to your admin template to provide a link to the &quot;blast&quot; action. i.e:<br/>
    <pre><code>{cgsocblaster module='MyModule' key=$item_id}</code></pre>
    </li>
  </ol>
<h3>The <span style="color: blue;">{cgsocblaster}</span> smarty plugin</h3>
<p>This plugin can only be used from the admin panel of a CMSMS module.  It provides a link <em>(or just a URL)</em> to an action in the CGSocialBlaster module, and information to allow for the filling of default values in that form.</p>
<p>Parameters:</p>
<ul>
<li>module - (optional string) - The module name that is providing the data.  If supplied, the key parameter must also be used.</li>
<li>key - (optional string) - A unique identifier that the module can use to retrieve data. Must be used in conjunction with the module parameter.</li>
<li>subject = (optional string) - Provide an optional default subject <em>(title)</em> to the CGSocialBlaster module for editing.  If not specified it will be retrieved from the module callback.</li>
<li>body - (optional string) - Provide an optional default message to the CGSocialBlaster module for editing. If not specified, it will be retrieved via the module callback.</li>
<li>picture - (optional string) - Provide an optional URL to an image to the CGSocialBlaster module for editing.  If not specified, one can be retrieved via the module callback.</li>
<li>returnto - (optional string) - Provide an optional URL to return to after the social media posting is complete (or cancelled). If not specified, the system will use the current URL.</li>
<li>title - (optional string) - Provide an optional title to the created link. If not specified a default value will be used.</li>
<li>urlonly - (optional boolean) - Indicates whether the system should generate a complete link with icon and title, or just a url.  default is false.</li>
<li>icon - (optional string) - Allows overriding the icon used in creating the link.</li>
</ul>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2013, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>