<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: SocialBlaster (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to facilitate blasting information to multiple social networks
#  at once.  Requires inedividial modules to handle the actual posting to social modules.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->VisibleToAdminUser() ) return;

if( isset($params['prefs_submit']) ) {
  if( isset($params['friendlyname']) ) $this->SetPreference('friendlyname',trim($params['friendlyname']));
  foreach( $params as $key => $val ) {
    if( startswith($key,'template_') ) {
      $pref = 'msgtpl_'.substr($key,strlen('template_'));
      $this->SetPreference($pref,$val);
    }
  }
  echo $this->ShowMessage($this->Lang('msg_prefs_saved'));
}
$smarty->assign('formstart',$this->CGCreateFormStart($id,'defaultadmin',$returnid));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('friendlyname',$this->GetPreference('friendlyname'));
$smarty->assign('hostmodules',sb_utils::get_feeders());

$senders = sb_utils::get_senders();
$smarty->assign('blastmodules',$senders);

$dflttemplate = <<<EOT
{\$input_data->summary} {\$input_data->canonical}
EOT;
$templates = array();
foreach( $senders as $one ) {
  $templates[$one] = $this->GetPreference('msgtpl_'.$one,$dflttemplate);
}
$smarty->assign('templates',$templates);

echo $this->ProcessTemplate('defaultadmin.tpl');

#
# EOF
#
?>