<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: SocialBlaster (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to facilitate blasting information to multiple social networks
#  at once.  Requires inedividial modules to handle the actual posting to social modules.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->VisibleToAdminUser() ) return;

$senders = sb_utils::get_sender_list();


try {
  if( isset($params['cancel']) ) {
    if( isset($params['returnto']) ) redirect($params['returnto']);
    $this->SetMessage($this->Lang('msg_cancelled'));
    $this->Redirect($id,'defaultadmin',$returnid);
  }
  if( isset($params['submit']) ) {
    if( !isset($params['senders']) || !is_array($params['senders']) || count($params['senders']) == 0 ) {
      throw new Exception($this->Lang('error_nosenders'));
    }
    $saved_senders = $params['senders'];
    $this->SetPreference('saved_senders',implode(',',$saved_senders));
    $notif_msg = unserialize(base64_decode($params['notif_msg']));
    $smarty->assign('input_data',$notif_msg);

    // build the messages
    $error = null;
    foreach( $saved_senders as $one ) {
      try {
	$msg = new notification_message;
	foreach( $params as $key => $value ) {
	  if( !startswith($key,$one) ) continue;
	  if( $value == '' ) continue;
	  $newkey = substr($key,strlen($one)+1);
	  if( $msg->valid_key($newkey) ) $msg->$newkey = $value;
	}

	$mod = cms_utils::get_module($one);
	$mod->send_message($msg);
      }
      catch( Exception $e ) {
	// if an error occurs sending one message, lets try to continue with others
	$error = $e->GetMessage();
      }
    }
    if( $error ) throw new CmsException($e->GetMessage());
    
    // it all worked.
    if( isset($params['returnto']) ) {
      $url = $params['returnto'];
      $url .= '&m1_cg_message='.urlencode($this->Lang('msg_blast_success'));
      redirect($url);
    }
    $this->ShowMessage($this->Lang('msg_blast_success'));
  }
}
catch( Exception $e ) {
  echo $this->ShowErrors($e->GetMessage());
}

//
// build the display
//
$notif_msg = new sb_content;
if( isset($params['data']) ) {
  $tmp = unserialize(base64_decode($params['data']));
  unset($params['data']);
  $params = array_merge($params,$tmp);
  if( isset($params['module']) && isset($params['key']) ) {
    // call back to the module and get the data...
    $smarty->assign('module',$params['module']);
    $mod = cms_utils::get_module($params['module']);
    if( !is_object($mod) || !method_exists($mod,'get_blaster_content') ) {
      echo $this->ShowErrors($this->Lang('error_module_notcompatible'));
    }
    else {
      $tmp = $mod->get_blaster_content($params['key']);
      if( !is_object($tmp) ) {
	echo $this->ShowErrors($this->Lang('error_module_nomessage'));
      }
      else {
	// clean up the data.
	$tmp->summary = trim(strip_tags($tmp->summary));
	$notif_msg = $tmp;
      }
    }
  }
}

if( isset($params['module']) ) $parms['module'] = $params['module'];
if( isset($params['key']) ) $parms['key'] = $params['key'];
$pictures = $notif_msg->pictures;
if( is_array($pictures) && count($pictures) ) {
  $pictures = array_merge(array(''=>$this->Lang('none')),$pictures);
  $notif_msg->pictures = $pictures;
}
$smarty->assign('input_data',$notif_msg);
$smarty->assign('source_data',$notif_msg);
$smarty->assign('sender_info',sb_utils::get_sender_info());
$smarty->assign('senders',$senders);

// prepare the default message templates.
$senders = sb_utils::get_sender_list();
$sender_msgs = array();
foreach( $senders as $one => $name ) {
  $tpl = $this->GetPreference('msgtpl_'.$one);
  if( $tpl ) {
    $sender_msgs[$one] = $this->ProcessTemplateFromData($tpl);
  }
  else {
    $sender_msgs[$one] = $notif_msg->summary;
  }
}
$smarty->assign('sender_msgs',$sender_msgs);

$saved_senders = $this->GetPreference('saved_senders');
if( $saved_senders != '' ) {
  $saved_senders = explode(',',$saved_senders);
}
else {
  $saved_senders = array_keys($senders);
}
$smarty->assign('saved_senders',$saved_senders);

$parms = array();
if( isset($params['returnto']) ) $parms['returnto'] = $params['returnto'];
$parms['notif_msg'] = base64_encode(serialize($notif_msg));

$smarty->assign('formstart',$this->CGCreateFormStart($id,'blast',$returnid,$parms));
$smarty->assign('formend',$this->CreateFormEnd());

echo $this->ProcessTemplate('blast.tpl');
#
# EOF
#
?>