<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialBlaster (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to facilitate blasting information to multiple social networks
#  at once.  Requires inedividial modules to handle the actual posting to social modules.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class CGSocialBlaster extends CGExtensions
{
  const PERMNAME = 'Blast to Social Media';

  public function GetName() { return get_class($this); }
  public function GetVersion() { return '1.0.2'; }
  public function GetHelp() { return file_get_contents(__DIR__.'/help.inc'); }
  public function GetAuthor() { return 'calguy1000'; }
  public function GetAuthorEmail() { return 'calguy1000@cmsmadesimple.org'; }
  public function GetChangeLog() { return file_get_contents(__DIR__.'/changelog.inc'); }
  public function IsPluginModule() { return FALSE; } // no frontend for this one.
  public function HasAdmin() { return TRUE; }
  public function GetAdminSection() { return 'extensions'; }
  public function GetAdminDescription() { return $this->Lang('moddescription'); }
  public function VisibleToAdminUser() { return $this->CheckPermission($this::PERMNAME); }
  public function GetDependencies() { return array('CGExtensions'=>'1.37','CGSimpleSmarty'=>'1.7'); }
  public function MinimumCMSVersion() { return '1.11.7'; }
  public function InstallPostMessage() { return $this->Lang('postinstall'); }
  public function UninstallPostMessage() { return $this->Lang('postuninstall'); }
  public function UninstallPreMessage() { return $this->Lang('really_uninstall'); }

  public function InitializeAdmin()
  {
    $this->AddImageDir('images');

    $smarty = cmsms()->GetSmarty();
    $smarty->register_function('cgsocblaster',array($this,'plugin_social_blaster'));
  }

  public function GetFriendlyName() 
  {
    $friendlyname = trim($this->GetPreference('friendlyname'));
    if( !$friendlyname ) $friendlyname = $this->Lang('friendlyname');
    return $friendlyname;
  }

  static public function plugin_social_blaster($params,&$template)
  {
    $uid = get_userid(FALSE);
    if( !check_permission($uid,CGSocialBlaster::PERMNAME) ) return;

    $mod = cms_utils::get_module(MOD_CGSOCIALBLASTER);
    $smarty = $template->smarty;
    $data = array();
    $data['module'] = '';
    $data['key'] = '';
    $data['subject'] = '';
    $data['body'] = '';
    $data['picture'] = '';
    $data['returnto'] = cge_url::current_url();

    $data['title'] = $mod->Lang('title_share_social');
    $data['urlonly'] = 0;
    $data['icon'] = 'social_sm.gif';

    foreach( $params as $key => $value ) {
      $value = trim($value);
      if( $value == '' ) continue;
      if( in_array($key,array_keys($data)) ) $data[$key] = $value;
    }

    // check requirements
    if( $data['module'] != '' && $data['key'] != '' ) {
      // we're good
    }
    else if( $data['body'] != '' ) {
      // we're good
    }
    else {
      // not so good.
      audit('','CGSocialBlaster','cgsocblaster plugin called with invalid parameters');
      return;
    }

    $parms = $data;
    unset($data['urlonly']);
    unset($data['icon']);
    unset($data['title']);
    foreach( $data as $key => $value ) {
      if( $value == '' ) unset($data[$key]);
    }

    $out = null;
    $tmp = array('data'=>base64_encode(serialize($data)));
    if( $parms['urlonly'] ) {
      $out = $mod->create_url('cgsb_','blast','',$tmp);
    }
    else {
      $img = $mod->DisplayImage($parms['icon'],$parms['title'],'',16,16);
      $url = $mod->create_url('cgsb_','blast','',$tmp);
      $out = "<a href=\"{$url}\" title=\"{$parms['title']}\">{$img}</a>";
    }

    if( isset($params['assign']) ) {
      $smarty->assign($params['assign'],$out);
      return;
    }
    return $out;
  }

} // class

?>
