<h3>What does this do?</h3>
  <p>CGFBPost is a simple <em>Media module</em> for sending facebook wall posts as an the wall/application owner rather than a user.  This module is used in conjunction with the CGSocialBlaster module <em>(and other modules like CGTweet)</em> to share items like blog articles and products with multiple media networks at the same time.</p>
<h3>Features</h3>
  <ul>
    <li>Provides interaction with the CGNotifier module to allow sending notifications via twitter.</li>
    <li>Provides interection with the CGSocialBlaster module to allow sending notifications to multiple social networks at once from modules like CGBlog.</li>
  </ul>
<h3>Requirements:</h3>
  <p>Other than the list of CMSMS module dependencies, there are some things that this module requires in order to work properly:</p>
  <ul>
    <li>Facebook App Credentials
      <p>You need to provide the facebook App ID, And App Secret in the modules admin panel.</p>
    </li>
    <li>The Page ID to post to, and an access token.
   <p>This module basically uses a facebook application to provide seamless posting from CMSMS to a facebook page<em>/wall</em> on behalf of a user.  A user must authenticate the application, thus providing the module with access tokens.</p>
   <p>In order to do this, a facebook user with adminstrator access to a facebook page needs to add and authenticate the application.</p>
    <p>This modules admin panel provides an &quot;Authentication&quot; tab.  It provides a link for the facebook user to authenticate the application, and select the Facebook page that this module will post to.  <strong>Note:</strong> See the section about facebook credentials below.</p>
    </li>
  </ul>

<h3>How do I Use it?</h3>
  <p><strong>Note:</strong> At this time, this module has no administrator or frontend functionality of its own, it is used by the CGSocialBlaster module, which must be installed for this module to function.</li>
  <ol>
    <li>Create a Facebook Application.</li>
    <li>Your Facebook account must have administrator access to at least one facebook page.</li>
    <li>In the modules admin panel specify the Facebook apps &quot;App ID&quot; and &quot;App Secret&quot; and press submit.</li>
    <li>In the modules admin panel, click the login link to login to facebook link so that a facebook user can authenticate the app.</li>
    <li>Choose the facebook page<em>/wall</em> that this module will post to.</li>
    <li>Install and configure the CGSocialBlaster module.</li>
    <li>Install and configure a <em>sender module</em> (such as CGBlog).</li>
    <li><strong>Optional, but Recommended</strong> Insert the appropriate opengraph tags into your templates so that your various pages become opengraph objects.  See the <em>CGFBApp</em> module for a convenient and simple way to do this.</li>
  </ol>

<h3>Facebook Credentials</h3>
<p>This module attempts to get long-lasting credentials from facebook so that the app is authorized to post to the facebook wall without having to refresh credentials on a frequent basis.  However, these credentials may not last forever.</p>
<p>From time to time the access tokens provided by Facebook may expire or become invalid for other reasons, in which case a user will need to re-authenticate.</p>
<p>If the user who authorized the app deletes that app from his list another user with admin access to at least one facebook page will need to authorize the application.</p>

<h3>Sender Modules</h3>
<p>Sender modules are CMSMS modules that are configured to allow sending information to the CGSocialBlaster module.  At this time CGBlog is the only module that supports this.</p>

<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2013, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>