<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBPost (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to facilitate posting to a facebook app's wall, or to
#  a wall authorized by a user.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->VisibleToAdminUser() ) return;

$fb_appid = $this->GetPreference('fb_appid');
$fb_appsecret = $this->GetPreference('fb_appsecret');
$smarty->assign('fb_appid',$fb_appid);
$smarty->assign('fb_appsecret',$fb_appsecret);

if( $fb_appid && $fb_appsecret ) {
  require_once(__DIR__.'/lib/fb/facebook.php');
  $fb_user_accesstoken = $this->GetPreference('fb_user_accesstoken');
  $smarty->assign('fb_user_accesstoken',$fb_user_accesstoken);

  $fbobj = new Facebook(array('appId'=>$fb_appid,'secret'=>$fb_appsecret));
  if( $fb_user_accesstoken ) $fbobj->setAccessToken($fb_user_accesstoken); // we wanna use this token.
  $fb_page_accesstoken = $this->GetPreference('fb_page_accesstoken');
  $smarty->assign('fb_page_accesstoken',$fb_page_accesstoken);

  $user = $fbobj->GetUser();
  if( $user ) {
    try {
      // this should get the user profile.  should throw an exception if our access token is invalid.
      $user_profile = $fbobj->api('/me');
      if( $user_profile ) $smarty->assign('user_profile',$user_profile);
      if( $fb_user_accesstoken == '' ) {
	// we have an empty access token... either was never set, or has invalidated
	// so we need to get another one.
	// this (should) make sure we get an extended one.
	$fbobj->setExtendedAccessToken();
	$fb_user_accesstoken = $fbobj->getAccessToken();
	$this->SetPreference('fb_user_accesstoken',$fb_user_accesstoken);
      }

      // here we build a list of the pages the user has access to.
      $accounts = $fbobj->api('/me/accounts');
      $pagelist = array(''=>$this->Lang('none'));
      if( is_array($accounts) && isset($accounts['data']) && count($accounts['data']) ) {
	foreach( $accounts['data'] as $account ) {
	  $pagelist[$account['id']] = $account['name'];
	}
      }
      if( is_array($pagelist) && count($pagelist) ) $smarty->assign('pagelist',$pagelist);

      $page_id = $this->GetPreference('fb_pageid');
      $smarty->assign('fb_pageid',$page_id);

      $logout_url = $fbobj->getLogoutUrl();
      $smarty->assign('logout_url',$logout_url);
      $smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_auth_tab',$returnid));
      $smarty->assign('formend',$this->CreateFormEnd());
    }
    catch( Exception $e ) {
      // assume our access token was never set,invalidated.
      $fb_user_accesstoken = '';
      $this->SetPreference('fb_user_accesstoken',$fb_user_accesstoken);
      $smarty->assign('fb_user_accesstoken',$fb_user_accesstoken);

      $parms['scope'] = 'publish_stream,manage_pages';
      $login_url = $fbobj->getLoginUrl($parms);
      $smarty->assign('login_url',$login_url);
    }
  }
  else {
    $parms['scope'] = 'publish_stream,manage_pages';
    $login_url = $fbobj->getLoginUrl($parms);
    $smarty->assign('login_url',$login_url);
  }
}
			    
echo $this->ProcessTemplate('admin_auth_tab.tpl');

#
# EOF
#
?>