<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBPost (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to facilitate posting to a facebook app's wall, or to
#  a wall authorized by a user.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->VisibleToAdminUser() ) return;
$this->SetCurrentTab('test');

$fb_appid = $this->GetPreference('fb_appid');
$fb_appsecret = $this->GetPreference('fb_appsecret');
$fb_pageid = $this->GetPreference('fb_pageid');
$fb_user_accesstoken = $this->GetPreference('fb_user_accesstoken');
$fb_page_accesstoken = $this->GetPreference('fb_page_accesstoken');

if( !($fb_appid != '' && $fb_pageid != '' && $fb_appsecret != '' && $fb_user_accesstoken != '' && $fb_page_accesstoken != '') ) {
  $this->SetError($this->Lang('warn_noaccesstoken'));
  $this->RedirecToTab($id);
}

require_once(__DIR__.'/lib/fb/facebook.php');

$msg = array();
foreach( $params as $key => $value ) {
  if( !startswith($key,'post_') ) continue;
  if( $value == '' ) continue;
  $key = substr($key,5);
  if( $key == 'msg' ) $key = 'message';
  $msg[$key] = trim($value);
}

$post_url = "/{$fb_pageid}/feed";
$res = null;
try {
  $fbobj = new Facebook(array('appId'=>$fb_appid,'secret'=>$fb_appsecret));
  $fbobj->setAccessToken($fb_page_accesstoken); // post as the page.
  $res = $fbobj->api($post_url,'POST',$msg);
  if( !is_array($res) || !isset($res['id']) ) throw new Exception('Facebook Post failed');
  $this->SetMessage($this->Lang('msg_post_success'));
}
catch( Exception $e ) {
  $this->SetError($e->getMessage());
}

$this->RedirectToTab($id);

#
# EOF
#
?>