<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBPost (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to facilitate posting to a facebook app's wall, or to
#  a wall authorized by a user.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class CGFBPost extends CGExtensions
{
  public function GetName() { return 'CGFBPost'; }
  public function GetFriendlyName() { return $this->Lang('friendlyname'); }
  public function GetVersion() { return '1.0.0.1'; }
  public function GetHelp() { return file_get_contents(__DIR__.'/help.inc'); }
  public function LazyLoadAdmin() { return TRUE; }
  public function GetAuthor() { return 'calguy1000'; }
  public function GetAuthorEmail() { return 'calguy1000@cmsmadesimple.org'; }
  public function GetChangeLog() { return file_get_contents(__DIR__.'/changelog.inc'); }
  public function IsPluginModule() { return FALSE; } // no frontend for this one.
  public function HasAdmin() { return TRUE; }
  public function GetAdminSection() { return 'extensions'; }
  public function GetAdminDescription() { return $this->Lang('moddescription'); }
  public function VisibleToAdminUser() { return $this->CheckPermission('Modify Site Preferences'); }
  public function GetDependencies() { return array('CGExtensions'=>'1.37'); }
  public function MinimumCMSVersion() { return '1.11.7'; }
  public function InitializeFrontend() { $this->RestrictUnknownParams(); }
  public function InstallPostMessage() { return $this->Lang('postinstall'); }
  public function UninstallPostMessage() { return $this->Lang('postuninstall'); }
  public function UninstallPreMessage() { return $this->Lang('really_uninstall'); }	

  public function HasCapability($capability, $params = array())
  {
    if( $capability == 'cg_messaging_client' ) return TRUE;
    if( $capability == 'cg_socialblast_sender' ) return TRUE;
    return FALSE;
  }

  function get_transport_name() { return 'Facebook'; }

  public function &get_sender_info()
  {
    $res = new sb_sender_info($this->GetName(),'Facebook',63000,1);
    $res['link'] = $res['linktitle'] = $res['caption'] = $res['description'] = $res['picture'] = 1;
    $res['info_message'] = $this->Lang('info_sender_facebook');
    return $res;
  }

  public function send_message(notification_message $msg)
  {
    if( !$msg->body ) throw new Exception($this->Lang('error_invalidmessage'));

    $fb_appid = $this->GetPreference('fb_appid');
    $fb_appsecret = $this->GetPreference('fb_appsecret');
    $fb_pageid = $this->GetPreference('fb_pageid');
    $fb_user_accesstoken = $this->GetPreference('fb_user_accesstoken');
    $fb_page_accesstoken = $this->GetPreference('fb_page_accesstoken');
    
    if( !($fb_appid != '' && $fb_pageid != '' && $fb_appsecret != '' && $fb_user_accesstoken != '' && $fb_page_accesstoken != '') ) {
      throw new Exception($this->Lang('warn_noaccesstoken'));
    }

    // prepare the message...
    $fbmsg = array();
    $fbmsg['message'] = strip_tags(trim($msg->body)); // posts can't be in HTML for Facecrack ... sorry.
    if( $msg->subject ) $fbmsg['subject'] = trim($msg->subject);
    if( $msg->link ) {
      $fbmsg['link'] = trim($msg->link);
      if( $msg->linkname ) $fbmsg['name'] = trim($msg->linkname);
      if( $msg->caption ) $fbmsg['caption'] = trim($msg->caption);
      if( $msg->description ) $fbmsg['description'] = trim($msg->description);
    }
    if( $msg->picture ) $fbmsg['picture'] = trim($msg->picture);

    // final check of the message
    foreach( $fbmsg as $key => $value ) {
      $value = trim($value);
      if( !$value ) unset($fbmsg[$key]);
    }
    if( isset($fbmsg['source']) || isset($fbmg['picture']) ) {
      if( !isset($fbmsg['name']) ) $fbmsg['name'] = get_site_preference('sitename', 'CMSMS Site');
    }

    $post_url = "/{$fb_pageid}/feed";
    $res = null;
    try {
      require_once(__DIR__.'/lib/fb/facebook.php');
      $fbobj = new Facebook(array('appId'=>$fb_appid,'secret'=>$fb_appsecret));
      $fbobj->setAccessToken($fb_page_accesstoken); // post as the page.
      $res = $fbobj->api($post_url,'POST',$fbmsg);
      if( !is_array($res) || !isset($res['id']) ) {
	audit('',$this->GetName(),'Facebook Post Failed');
	throw new Exception($this->Lang('error_postfailed'));
      }
      audit('',$this->GetName(),'Sent facebook post #'.$res['id']);
    }
    catch( Exception $e ) {
      $this->SetError($e->getMessage());
    }

  }

} // class

?>
