{* this sample template requires jquery and fancybox... feel free to implement it however you which 
To Include JQuery and Javascript on the page that calls this add the following to the 'page specific metadata' when editing a page
or add it to your page template.
{JQueryTools action=require lib=jquery,fancybox'}
{JQueryTools action=placeholder}
*}

<style type="text/css">
img.icon {
  width: 16px;
  height: 16px;
}
img.vertcenter {
  vertical-align: middle;
}
div#cgn_skeleton > fieldset {
  border: 1px solid silver;
  padding: 1em;
}
</style>

<script type="text/javascript">
function myzeroFill(num,len) {
 len -= num.toString().length;
 var s = '';
 for( i = 0; i < len; i++ ) {
   s = s + '0';
 }
 s = s + num.toString();
 return s;
}

if( typeof(jQuery) == 'undefined' ) {
  alert('jquery is not defined.  please include jquery libraries');
  return false;
}
else {
  $(document).ready(function(){
    // hide the submit button if there are no items.
    var l = $('div#cgn_items table tbody tr').length;
    if( l == 0 ) $('#savebtn').hide();

    $('#cgn_addedit_submit').live('click',function(e){
      e.preventDefault();
      var form = $('#cgn_skeleton_popup > form');
      // get form data.

      var op = $('[name=op]',form).val();
      var idx = $('[name=idx]',form).val();
      var priority = $('[name=priority]',form).val();
      var priority_text = $('[name=priority] option:selected',form).text();
      var module = $('[name=module]',form).val();
      var module_text = $('[name=module] option:selected',form).text();
      var sth = $('[name=start_timeHour]',form).val();
      var stm = $('[name=start_timeMinute]',form).val();
      var start_time = sth*3600+stm*60;
      var eth = $('[name=end_timeHour]',form).val();
      var etm = $('[name=end_timeMinute]',form).val();
      var end_time = eth*3600+etm*60;
      var send_method = $('[name=send_method]',form).val();
      var send_method_text = $('[name=send_method] option:selected',form).text();
      var sig1 = priority+module+start_time+end_time+send_method;
      var sig1a = priority+module+send_method;
 
      // validate
      if( end_time <= start_time && start_time != 0 ) {
        alert('{$mod->Lang('error_invalid_endtime')}');
        return;
      }

      // check for duplicate
      var dup = 0;
      $('div#cgn_items table tbody tr').each(function(){
        var priority = $('.cgn_item_priority',this).val();      
        var module = $('.cgn_item_module',this).val();
        var start_time = $('.cgn_item_start_time',this).val();
        var end_time = $('.cgn_item_end_time',this).val();
        var send_method = $('.cgn_item_send_method',this).val();
	var sig2 = priority+module+start_time+end_time+send_method;
	var sig2a = priority+module+send_method;
        var idx2 = $(this).index();
        if( (sig1 == sig2 || sig1a == sig2a) && idx != idx2 ) dup = 1;
      });
      if( dup == 1 ) {
        alert('{$mod->Lang('error_duplicate_item')}');
        return false;
      }

      // get the table row.
      var tr;
      var insert = 0;
      if( op == 'add' ) {
        var tr = $('table#cgn_item_skeleton tr').first().clone();
        insert = 1;
      } else {
        alert('not done');
      }
	
      // populate the table row.
      $('.cgn_item_priority',tr).val(priority);
      $('.cgn_item_module',tr).val(module);
      $('.cgn_item_start_time',tr).val(start_time);
      $('.cgn_item_end_time',tr).val(end_time);
      $('.cgn_item_send_method',tr).val(send_method);

      $('.td_priority',tr).html(priority_text);
      $('.td_module',tr).html(module_text);
      $('.td_start_time',tr).html(myzeroFill(sth,2)+':'+myzeroFill(stm,2));
      $('.td_end_time',tr).html(myzeroFill(eth,2)+':'+myzeroFill(etm,2));
      $('.td_send_method',tr).html(send_method_text);

      if( insert ) {
        $('div#cgn_items > table > tbody').append(tr);
      }

      $('#savebtn').show();
      $.fancybox.close();
    });

    $('a#cgn_additem').live('click',function(e){
      e.preventDefault();
      var form = $('#cgn_skeleton_popup > form');
      $('[name=op]',form).val('add');
      $('[name=idx]',form).val('-1');
      $('legend#cgn_skeleton_legend').html('{$mod->Lang('add_profile_item')}');

      $.fancybox({
        href: '#cgn_skeleton'
      });
    });

    $('img.edititem').live('click',function(e){
      var tr = $(this).closest('tr');
      var idx = $(tr).index();
      var form = $('#cgn_skeleton_popup > form');
      $('[name=op]',form).val('edit');
      $('[name=idx]',form).val(idx);
      $('legend#cgn_skeleton_legend').html('{$mod->Lang('edit_profile_item')}');

      var priority = $('.cgn_item_priority',tr).val();      
      var module = $('.cgn_item_module',tr).val();
      var start_time = $('.cgn_item_start_time',tr).val();
      var end_time = $('.cgn_item_end_time',tr).val();
      var send_method = $('.cgn_item_send_method',tr).val();

      var sth = Math.floor(start_time / 3600);
      var stm = Math.floor(start_time % 3600 / 60);
      var eth = Math.floor(end_time / 3600);
      var etm = Math.floor(end_time % 3600 / 60);
      $('[name=priority]',form).val(priority);
      $('[name=module]',form).val(module);
      $('[name=send_method]',form).val(send_method);
      $('[name=start_timeHour]',form).val(myzeroFill(sth,2));
      $('[name=start_timeMinute]',form).val(myzeroFill(stm,2));
      $('[name=end_timeHour]',form).val(myzeroFill(eth,2));
      $('[name=end_timeMinute]',form).val(myzeroFill(etm,2));

      $.fancybox({
        href: '#cgn_skeleton'
      });
    });

    $('img.delitem').live('click',function(){
      $(this).closest('tr').remove();
      var l = $('div#cgn_items table tbody tr').length;
      if( l == 0 ) $('#savebtn').hide();
    });
  });
};
</script>

{if isset($error)}<div class="error">{$error}</div>{/if}

{* this is the popup form *}
<div style="width: 15em; display: none;" id="cgn_skeleton">
  <fieldset id="cgn_skeleton_popup" class="cgn_profile_item">
    <legend id="cgn_skeleton_legend">{$mod->Lang('add_profile_item')}</legend>
    <form id="cgn_skeleton_form" method="post">
      <input type="hidden" name="op" class="op" value="add"/>
      <input type="hidden" name="idx" class="idx" value="add"/>

      <div class="form_row">
        <p class="form_prompt">{$mod->Lang('priority')}:</p>
        <p class="form_input">
          <select name="priority" class="item_priority">
            {html_options options=$priorities}
          </select>
        </p>
      </div>

      <div class="form_row">
        <p class="form_prompt">{$mod->Lang('module')}:</p>
        <p class="form_input">
          <select name="module" class="item_module">
            {html_options options=$modules}
          </select>
        </p>
      </div>

      <div class="form_row">
        <p class="form_prompt">{$mod->Lang('start_time')}:</p>
        <p class="form_input item_starttime">
          {html_select_time prefix=start_time time='0:00' display_seconds=false display_meridian=false minute_interval=5}
          <a class="help" title="{$mod->Lang('help_time_servertime')} {$timezone}">{$helpicon}</a>
        </p>
      </div>

      <div class="form_row">
        <p class="form_prompt">{$mod->Lang('end_time')}:</p>
        <p class="form_input item_endtime">
          {html_select_time prefix=end_time time='0:00' display_seconds=false display_meridian=false minute_interval=5}
        </p>
      </div>

      <div class="form_row">
        <p class="form_prompt">{$mod->Lang('send_method')}:</p>
        <p class="form_input">
          <select name="send_method" class="item_method">
            {html_options options=$send_methods}
          </select>
        </p>
      </div>

      <div class="form_row">
        <p class="form_prompt"></p>
        <p class="form_input">
          <input type="submit" id="cgn_addedit_submit" value="{$mod->Lang('submit')}"/>
        </p>
      </div>
    </form>
  </fieldset>
</div>

{function do_row}
  <tr>
    <td class="td_priority">{$priorities[$row->priority]}</td>
    <td class="td_module">{$modules[{$row->module}]}</td>
    <td class="td_start_time">{$row->start_time|time_fmt}</td>
    <td class="td_end_time">{$row->end_time|time_fmt}</td>
    <td class="td_send_method">{$send_methods[$row->send_method]}</td>
    <td>
      {$edititem_img}&nbsp;{$deleteitem_img}
    </td>
    <td style="display: none;">
      <input type="hidden" class="cgn_item_priority" name="{$actionid}cgn_priority[]" value="{$row->priority}"/>
      <input type="hidden" class="cgn_item_module" name="{$actionid}cgn_module[]" value="{$row->module}"/>
      <input type="hidden" class="cgn_item_start_time" name="{$actionid}cgn_start_time[]" value="{$row->start_time|date_format}"/>
      <input type="hidden" class="cgn_item_end_time" name="{$actionid}cgn_end_time[]" value="{$row->end_time|date_format}"/>
      <input type="hidden" class="cgn_item_send_method" name="{$actionid}cgn_send_method[]" value="{$row->send_method}"/>
    </td>
  </tr>
{/function}

<div id="cgnotifier_editprofile">
  <table id="cgn_item_skeleton" style="display: none;">
    <tr>
      <td class="td_priority"></td>
      <td class="td_module"></td>
      <td class="td_start_time"></td>
      <td class="td_end_time"></td>
      <td class="td_send_method"></td>
      <td>
        {$edititem_img}&nbsp;{$deleteitem_img}
      </td>
      <td style="display: none;">
        <input type="hidden" class="cgn_item_priority" name="{$actionid}cgn_priority[]" value=""/>
        <input type="hidden" class="cgn_item_module" name="{$actionid}cgn_module[]" value=""/>
        <input type="hidden" class="cgn_item_start_time" name="{$actionid}cgn_start_time[]" value=""/>
        <input type="hidden" class="cgn_item_end_time" name="{$actionid}cgn_end_time[]" value=""/>
        <input type="hidden" class="cgn_item_send_method" name="{$actionid}cgn_send_method[]" value=""/>
      </td>
    </tr>
  </table>

  {$formstart}
  <div id="cgn_items">
    <table width="100%">
      <thead>
        <tr>
          <th>{$mod->Lang('priority')}</th>
          <th>{$mod->Lang('module')}</th>
          <th>{$mod->Lang('start_time')}</th>
          <th>{$mod->Lang('end_time')}</th>
          <th>{$mod->Lang('handler')}</th>
          <th>{* icons *}</th>
      </thead>
      <tbody>
      {foreach from=$profile->get_items() item='item'}
        {do_row row=$item}
      {/foreach}
      </tbody>
    </table>
  </div>
  <div class="form_row">
    <p class="form_prompt"></p>
    <p class="form_input">
      <input id="savebtn" type="submit" name="{$actionid}cgn_save" value="{$mod->Lang('save')}"/>&nbsp;
      <a href="#cgn_skeleton" id="cgn_additem" title="{$mod->Lang('add_profile_entry')}">{$additem_img} {$mod->Lang('add_profile_entry')}</a>
    </p>
  </div>
  {$formend}
</div>