<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGNotifier (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# An addon module for CMSMS to allow sending notifications in various forms.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class notification_profile_item
{
  private static $_keys = array('priority','module','send_method','start_time','end_time');
  private $_data = array();

  public function __get($key)
  {
    if( !in_array($key,self::$_keys) ) throw new Exception('Attempt to retrieve invalid value '.$key.' from object');
    if( isset($this->_data[$key]) ) return $this->_data[$key];
  }

  public function __set($key,$value)
  {
    if( !in_array($key,self::$_keys) ) throw new Exception('Attempt to set invalid value into object');
    $this->_data[$key] = $value;
  }

  public function validate()
  {
    if( !$this->priority || !$this->module ) {
      // gotta have one of these
      throw new Exception('Invalid notification profile: must have priority and module');
    }

    if( !$this->send_method ) {
      throw new Exception('Invalid notification profile: must have send method');
    }

    if( ($this->priority > notification_message::PRIORITY_LOW || 
	 $this->priority < notification_message::PRIORITY_HIGH) && $this->priority != -1 ) {
      throw new Exception('Invalid notification message: invalid priority '.$this->priority);
    }

    // todo: check originator

    if( $this->start_time ) {
      // start time is between 0 and 24 hours...
      if( $this->start_time < 0 || $this->start_time > (24 * 3600 - 1) ) {
	throw new Exception('Invalid notification message: invalid start time');
      }
      if( !$this->end_time ) throw new Exception('Invalid notification message: start time with no end time');
      if( $this->end_time < 0 || $this->end_time > (24 * 3600 - 1) ) {
	throw new Exception('Invalid notification message: invalid end time');
      }
      if( $this->start_time > $this->end_time ) {
	throw new Exception('Invalid notification message: invalid end time');
      }
    }
  }
}


class notification_profile
{
  private $_items; // array of notification_profile_item 
  private $_uid;

  public function get_item_count()
  {
    return count($this->_items);
  }

  public function get_items()
  {
    return $this->_items;
  }

  public function add_item(notification_profile_item $item)
  {
    if( !is_array($this->_items) ) $this->_items = array();
    $this->_items[] = $item;
  }

  public function find_item(notification_message &$msg)
  {
    $output = array();
    foreach( $this->_items as $one_item ) {
      if( $one_item->priority != -1 && $one_item->priority != $msg->priority ) continue;
      if( $one_item->module != -1 && $msg->module != '' && $one_item->module != $msg->module ) continue;
      if( $one_item->start_time < $one_item->end_time ) {
	$st = mktime(0,0,0)+$one_item->start_time;
	$et = mktime(0,0,0)+$one_item->end_time;
	$now = time();
	if( $st >= $et && ($st > $now || $et < $now) ) continue;
      }

      $output[] = $one_item;
    }

    if( count($output) ) return $output;
  }

  public function validate()
  {
    foreach( $this->_items as $one_item ) {
      $one_item->validate();
    }
  }
}

#
# EOF
#
?>